/*
 * Decompiled with CFR 0.152.
 */
package org.elastic.jdt.ls.core.internal;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.handlers.HoverHandler;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.managers.ContentProviderManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class ExtendedHoverHandler
extends HoverHandler {
    public ExtendedHoverHandler(PreferenceManager preferenceManager) {
        super(preferenceManager);
    }

    public Hover extendedHover(TextDocumentPositionParams position, IProgressMonitor monitor) {
        Hover hover = this.removeLinkInHoverContent(this.hover(position, monitor));
        String uri = position.getTextDocument().getUri();
        ITypeRoot unit = JDTUtils.resolveTypeRoot((String)uri);
        if (unit != null && !monitor.isCanceled()) {
            try {
                String content;
                if (URIUtil.isFileURI((URI)JDTUtils.toURI((String)uri))) {
                    File file = ResourceUtils.toFile((URI)JDTUtils.toURI((String)uri));
                    content = Files.toString((File)file, (Charset)Charsets.UTF_8);
                } else if (unit instanceof IClassFile) {
                    IClassFile classFile = (IClassFile)unit;
                    ContentProviderManager contentProvider = JavaLanguageServerPlugin.getContentProviderManager();
                    content = contentProvider.getSource(classFile, monitor);
                    JavaLanguageServerPlugin.logInfo((String)content);
                } else {
                    return hover;
                }
                ASTParser parser = ASTParser.newParser((int)13);
                char[] source = content.toCharArray();
                parser.setIgnoreMethodBodies(false);
                parser.setSource(source);
                CompilationUnit ast = (CompilationUnit)parser.createAST(null);
                NodeFinder fNodeFinder = new NodeFinder((ASTNode)ast, JsonRpcHelpers.toOffset((IBuffer)unit.getBuffer(), (int)position.getPosition().getLine(), (int)position.getPosition().getCharacter()), 0);
                ASTNode node = fNodeFinder.getCoveringNode();
                if (node != null) {
                    hover.setRange(JDTUtils.toRange((IOpenable)unit, (int)node.getStartPosition(), (int)node.getLength()));
                }
            }
            catch (IOException | JavaModelException e) {
                JavaLanguageServerPlugin.logException((String)"get range error", (Throwable)e);
            }
        }
        return hover;
    }

    private Hover removeLinkInHoverContent(Hover hover) {
        List contents = (List)hover.getContents().getLeft();
        if (contents == null) {
            return hover;
        }
        int i = 0;
        while (i < contents.size()) {
            String originMarkdown = (String)((Either)contents.get(i)).getLeft();
            if (originMarkdown != null) {
                contents.set(i, Either.forLeft((Object)this.FromLinkToCode(originMarkdown)));
            }
            ++i;
        }
        hover.setContents(contents);
        return hover;
    }

    private String FromLinkToCode(String origin) {
        String regex = "\\[([^\\]]+)\\](\\([^\\)]+\\)|\\[[^\\]]+\\])";
        return origin.replaceAll(regex, "`$1`");
    }
}

