/*
 * Decompiled with CFR 0.152.
 */
package org.elastic.jdt.ls.core.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.internal.net.ProxySelector;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.ls.core.internal.ConnectionStreamFactory;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.ServiceStatus;
import org.eclipse.jdt.ls.core.internal.managers.ContentProviderManager;
import org.eclipse.jdt.ls.core.internal.managers.DigestStore;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.elastic.jdt.ls.core.internal.ElasticJDTLanguageServer;
import org.elastic.jdt.ls.core.internal.ElasticLanguageServer;
import org.elastic.jdt.ls.core.internal.ParentProcessWatcher;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.ServiceTracker;

public class ElasticJavaLanguageServerPlugin
extends Plugin {
    public static final String MANUAL = "Manual";
    public static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    public static final String HTTPS_NON_PROXY_HOSTS = "https.nonProxyHosts";
    public static final String HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    public static final String HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTPS_PROXY_USER = "https.proxyUser";
    public static final String HTTP_PROXY_USER = "http.proxyUser";
    public static final String SERVER_SOURCE_ID = "Java";
    @Deprecated
    public static final String PLUGIN_ID = "org.eclipse.jdt.ls.core";
    private static ElasticJavaLanguageServerPlugin pluginInstance;
    private static BundleContext context;
    private ServiceTracker<IProxyService, IProxyService> proxyServiceTracker = null;
    private static InputStream in;
    private static PrintStream out;
    private static PrintStream err;
    private ElasticLanguageServer languageServer;
    private ProjectsManager projectsManager;
    private DigestStore digestStore;
    private ContentProviderManager contentProviderManager;
    private ElasticJDTLanguageServer protocol;
    private PreferenceManager preferenceManager;

    public static ElasticLanguageServer getLanguageServer() {
        return pluginInstance == null ? null : ElasticJavaLanguageServerPlugin.pluginInstance.languageServer;
    }

    public static BundleContext getBundleContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        try {
            Platform.getBundle((String)"org.eclipse.core.resources").start(1);
        }
        catch (BundleException e) {
            ElasticJavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        try {
            ElasticJavaLanguageServerPlugin.redirectStandardStreams();
        }
        catch (FileNotFoundException e) {
            ElasticJavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        context = bundleContext;
        pluginInstance = this;
        this.preferenceManager = new PreferenceManager();
        this.initializeJDTOptions();
        this.digestStore = new DigestStore(this.getStateLocation().toFile());
        this.projectsManager = new ProjectsManager(this.preferenceManager);
        try {
            ResourcesPlugin.getWorkspace().addSaveParticipant(PLUGIN_ID, (ISaveParticipant)this.projectsManager);
        }
        catch (CoreException e) {
            ElasticJavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        this.contentProviderManager = new ContentProviderManager(this.preferenceManager);
        ElasticJavaLanguageServerPlugin.logInfo(((Object)((Object)this)).getClass() + " is started");
        this.configureProxy();
    }

    private void configureProxy() {
        String httpHost = System.getProperty(HTTP_PROXY_HOST);
        String httpPort = System.getProperty(HTTP_PROXY_PORT);
        final String httpUser = System.getProperty(HTTP_PROXY_USER);
        final String httpPassword = System.getProperty(HTTP_PROXY_PASSWORD);
        String httpsHost = System.getProperty(HTTPS_PROXY_HOST);
        String httpsPort = System.getProperty(HTTPS_PROXY_PORT);
        String httpsUser = System.getProperty(HTTPS_PROXY_USER);
        String httpsPassword = System.getProperty(HTTPS_PROXY_PASSWORD);
        String httpsNonProxyHosts = System.getProperty(HTTPS_NON_PROXY_HOSTS);
        String httpNonProxyHosts = System.getProperty(HTTP_NON_PROXY_HOSTS);
        if (StringUtils.isNotBlank((CharSequence)httpUser) || StringUtils.isNotBlank((CharSequence)httpsUser)) {
            IProxyService proxyService;
            try {
                Platform.getBundle((String)"org.eclipse.core.net").start(1);
            }
            catch (BundleException e) {
                ElasticJavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
            if (StringUtils.isNotBlank((CharSequence)httpUser) && StringUtils.isNotBlank((CharSequence)httpPassword)) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(httpUser, httpPassword.toCharArray());
                    }
                });
            }
            if ((proxyService = this.getProxyService()) != null) {
                IProxyData[] proxies;
                ProxySelector.setActiveProvider((String)MANUAL);
                IProxyData[] iProxyDataArray = proxies = proxyService.getProxyData();
                int n = proxies.length;
                int n2 = 0;
                while (n2 < n) {
                    IProxyData proxy = iProxyDataArray[n2];
                    if ("HTTP".equals(proxy.getType())) {
                        proxy.setHost(httpHost);
                        proxy.setPort(httpPort == null ? -1 : Integer.valueOf(httpPort));
                        proxy.setPassword(httpPassword);
                        proxy.setUserid(httpUser);
                    }
                    if ("HTTPS".equals(proxy.getType())) {
                        proxy.setHost(httpsHost);
                        proxy.setPort(httpsPort == null ? -1 : Integer.valueOf(httpsPort));
                        proxy.setPassword(httpsPassword);
                        proxy.setUserid(httpsUser);
                    }
                    ++n2;
                }
                try {
                    proxyService.setProxyData(proxies);
                    if (httpHost != null) {
                        System.setProperty(HTTP_PROXY_HOST, httpHost);
                    }
                    if (httpPort != null) {
                        System.setProperty(HTTP_PROXY_PORT, httpPort);
                    }
                    if (httpUser != null) {
                        System.setProperty(HTTP_PROXY_USER, httpUser);
                    }
                    if (httpPassword != null) {
                        System.setProperty(HTTP_PROXY_PASSWORD, httpPassword);
                    }
                    if (httpsHost != null) {
                        System.setProperty(HTTPS_PROXY_HOST, httpsHost);
                    }
                    if (httpsPort != null) {
                        System.setProperty(HTTPS_PROXY_PORT, httpsPort);
                    }
                    if (httpsUser != null) {
                        System.setProperty(HTTPS_PROXY_USER, httpsUser);
                    }
                    if (httpsPassword != null) {
                        System.setProperty(HTTPS_PROXY_PASSWORD, httpsPassword);
                    }
                    if (httpsNonProxyHosts != null) {
                        System.setProperty(HTTPS_NON_PROXY_HOSTS, httpsNonProxyHosts);
                    }
                    if (httpNonProxyHosts != null) {
                        System.setProperty(HTTP_NON_PROXY_HOSTS, httpNonProxyHosts);
                    }
                }
                catch (CoreException e) {
                    ElasticJavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
            }
        }
    }

    public IProxyService getProxyService() {
        try {
            if (this.proxyServiceTracker == null) {
                this.proxyServiceTracker = new ServiceTracker(context, IProxyService.class.getName(), null);
                this.proxyServiceTracker.open();
            }
            return (IProxyService)this.proxyServiceTracker.getService();
        }
        catch (Exception e) {
            ElasticJavaLanguageServerPlugin.logException(e.getMessage(), e);
            return null;
        }
    }

    private void startConnection() throws IOException {
        this.protocol = new ElasticJDTLanguageServer(ElasticJavaLanguageServerPlugin.getProjectsManager(), ElasticJavaLanguageServerPlugin.getPreferencesManager());
        ConnectionStreamFactory connectionFactory = new ConnectionStreamFactory();
        Launcher launcher = Launcher.createLauncher((Object)((Object)this.protocol), JavaClientConnection.JavaLanguageClient.class, (InputStream)connectionFactory.getInputStream(), (OutputStream)connectionFactory.getOutputStream(), (ExecutorService)Executors.newCachedThreadPool(), (Function)new ParentProcessWatcher(ElasticJavaLanguageServerPlugin.getLanguageServer()));
        this.protocol.connectClient((JavaClientConnection.JavaLanguageClient)launcher.getRemoteProxy());
        launcher.startListening();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        ElasticJavaLanguageServerPlugin.logInfo(((Object)((Object)this)).getClass() + " is stopping:");
        pluginInstance = null;
        context = null;
        ResourcesPlugin.getWorkspace().removeSaveParticipant(PLUGIN_ID);
        this.projectsManager = null;
        this.contentProviderManager = null;
        this.languageServer = null;
    }

    public WorkingCopyOwner getWorkingCopyOwner() {
        return this.protocol.getWorkingCopyOwner();
    }

    public static ElasticJavaLanguageServerPlugin getInstance() {
        return pluginInstance;
    }

    public static void log(IStatus status) {
        if (context != null) {
            Platform.getLog((Bundle)context.getBundle()).log(status);
        }
    }

    public static void log(CoreException e) {
        ElasticJavaLanguageServerPlugin.log(e.getStatus());
    }

    public static void logError(String message) {
        if (context != null) {
            ElasticJavaLanguageServerPlugin.log((IStatus)new Status(4, context.getBundle().getSymbolicName(), message));
        }
    }

    public static void logInfo(String message) {
        if (context != null) {
            ElasticJavaLanguageServerPlugin.log((IStatus)new Status(1, context.getBundle().getSymbolicName(), message));
        }
    }

    public static void logException(String message, Throwable ex) {
        if (context != null) {
            ElasticJavaLanguageServerPlugin.log((IStatus)new Status(4, context.getBundle().getSymbolicName(), message, ex));
        }
    }

    public static void sendStatus(ServiceStatus serverStatus, String status) {
        if (pluginInstance != null && ElasticJavaLanguageServerPlugin.pluginInstance.protocol != null) {
            ElasticJavaLanguageServerPlugin.pluginInstance.protocol.sendStatus(serverStatus, status);
        }
    }

    static void startLanguageServer(ElasticLanguageServer newLanguageServer) throws IOException {
        if (pluginInstance != null) {
            ElasticJavaLanguageServerPlugin.pluginInstance.languageServer = newLanguageServer;
            pluginInstance.startConnection();
        }
    }

    private void initializeJDTOptions() {
        Hashtable javaCoreOptions = JavaCore.getOptions();
        javaCoreOptions.put("org.eclipse.jdt.core.codeComplete.visibilityCheck", "enabled");
        JavaCore.setOptions((Hashtable)javaCoreOptions);
    }

    public static ProjectsManager getProjectsManager() {
        return ElasticJavaLanguageServerPlugin.pluginInstance.projectsManager;
    }

    public static DigestStore getDigestStore() {
        return ElasticJavaLanguageServerPlugin.pluginInstance.digestStore;
    }

    public static ContentProviderManager getContentProviderManager() {
        return ElasticJavaLanguageServerPlugin.pluginInstance.contentProviderManager;
    }

    public static String getVersion() {
        return context == null ? "Unknown" : context.getBundle().getVersion().toString();
    }

    private static void redirectStandardStreams() throws FileNotFoundException {
        in = System.in;
        out = System.out;
        err = System.err;
        System.setIn(new ByteArrayInputStream(new byte[0]));
        boolean isDebug = Boolean.getBoolean("jdt.ls.debug");
        if (isDebug) {
            String id = "jdt.ls-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            File workspaceFile = root.getRawLocation().makeAbsolute().toFile();
            File rootFile = new File(workspaceFile, ".metadata");
            rootFile.mkdirs();
            File outFile = new File(rootFile, ".out-" + id + ".log");
            FileOutputStream stdFileOut = new FileOutputStream(outFile);
            System.setOut(new PrintStream(stdFileOut));
            File errFile = new File(rootFile, ".error-" + id + ".log");
            FileOutputStream stdFileErr = new FileOutputStream(errFile);
            System.setErr(new PrintStream(stdFileErr));
        } else {
            System.setOut(new PrintStream(new ByteArrayOutputStream()));
            System.setErr(new PrintStream(new ByteArrayOutputStream()));
        }
    }

    public static InputStream getIn() {
        return in;
    }

    public static PrintStream getOut() {
        return out;
    }

    public static PrintStream getErr() {
        return err;
    }

    public static PreferenceManager getPreferencesManager() {
        if (pluginInstance != null) {
            return ElasticJavaLanguageServerPlugin.pluginInstance.preferenceManager;
        }
        return null;
    }

    public void unregisterCapability(String id, String method) {
        if (this.protocol != null) {
            this.protocol.unregisterCapability(id, method);
        }
    }

    public void registerCapability(String id, String method) {
        this.registerCapability(id, method, null);
    }

    public void registerCapability(String id, String method, Object options) {
        if (this.protocol != null) {
            this.protocol.registerCapability(id, method, options);
        }
    }

    public void setProtocol(ElasticJDTLanguageServer protocol) {
        this.protocol = protocol;
    }

    public ElasticJDTLanguageServer getProtocol() {
        return this.protocol;
    }

    public JavaClientConnection getClientConnection() {
        if (this.protocol != null) {
            return this.protocol.getClientConnection();
        }
        return null;
    }

    public static void setPreferencesManager(PreferenceManager preferenceManager) {
        if (pluginInstance != null) {
            ElasticJavaLanguageServerPlugin.pluginInstance.preferenceManager = preferenceManager;
        }
    }
}

