/*
 * Decompiled with CFR 0.152.
 */
package org.elastic.jdt.ls.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ServiceStatus;

public class BuildPathHelper {
    private final InfoRecorder rootInfoRecorder;
    private JavaClientConnection connection;

    public BuildPathHelper(IPath rootPath, JavaClientConnection connection) {
        this.rootInfoRecorder = new InfoRecorder(rootPath.toFile());
        this.connection = connection;
    }

    public void IncludeAllJavaFiles() {
        WorkspaceJob job = new WorkspaceJob("Include java files"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                long start = System.currentTimeMillis();
                BuildPathHelper.this.connection.sendStatus(ServiceStatus.Starting, "Begin to include all java files...");
                try {
                    BuildPathHelper.this.crawler(BuildPathHelper.this.rootInfoRecorder);
                    BuildPathHelper.this.includeJavaFiles(BuildPathHelper.this.rootInfoRecorder);
                    JavaLanguageServerPlugin.logInfo((String)("Include all Java paths in " + (System.currentTimeMillis() - start) + "ms"));
                    BuildPathHelper.this.connection.sendStatus(ServiceStatus.Started, "Ready");
                }
                catch (Exception e) {
                    JavaLanguageServerPlugin.logException((String)"Include Java paths failed ", (Throwable)e);
                    BuildPathHelper.this.connection.sendStatus(ServiceStatus.Error, e.getMessage());
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return "java-ls-initialization-jobs".equals(family);
            }
        };
        job.setPriority(50);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }

    private void crawler(InfoRecorder infoRecorder) {
        File[] listOfFilesAndDirectory = infoRecorder.dir.listFiles();
        if (listOfFilesAndDirectory != null) {
            File[] fileArray = listOfFilesAndDirectory;
            int n = listOfFilesAndDirectory.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileName = FilenameUtils.getName((String)file.toString());
                if (!fileName.startsWith(".") && fileName != "build") {
                    if (file.isDirectory()) {
                        InfoRecorder childInfoRecorder = new InfoRecorder(file);
                        if (!this.inBuildPath(childInfoRecorder)) {
                            infoRecorder.children.add(childInfoRecorder);
                            this.crawler(childInfoRecorder);
                        }
                    } else if ("java".equals(FilenameUtils.getExtension((String)file.getName()))) {
                        infoRecorder.shouldBeIncluded = true;
                    }
                }
                ++n2;
            }
        }
        if (!infoRecorder.children.isEmpty() && !infoRecorder.shouldBeIncluded) {
            boolean childrenAllIncluded = true;
            for (InfoRecorder child : infoRecorder.children) {
                childrenAllIncluded &= child.shouldBeIncluded;
            }
            infoRecorder.shouldBeIncluded = childrenAllIncluded;
        }
    }

    private void includeJavaFiles(InfoRecorder infoRecorder) {
        if (infoRecorder.shouldBeIncluded) {
            try {
                if (infoRecorder.javaProject != null && infoRecorder.sourcePath != null) {
                    ProjectUtils.addSourcePath((IPath)infoRecorder.sourcePath, (IPath[])infoRecorder.exclusionPath, (IJavaProject)infoRecorder.javaProject);
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException((String)("Fail to add source:" + infoRecorder.dir.getPath()), (Throwable)e);
            }
        } else {
            infoRecorder.children.forEach(c -> this.includeJavaFiles((InfoRecorder)c));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean inBuildPath(InfoRecorder recorder) {
        if (recorder.javaProject == null) {
            return false;
        }
        try {
            IClasspathEntry[] existingEntries;
            IClasspathEntry[] iClasspathEntryArray = existingEntries = recorder.javaProject.getRawClasspath();
            int n = existingEntries.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3 && entry.getPath().equals((Object)recorder.sourcePath)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException((String)("Cannot get classpath for" + recorder.javaProject.toString()), (Throwable)e);
        }
        return false;
    }

    class InfoRecorder {
        File dir;
        IPath sourcePath;
        IJavaProject javaProject;
        IPath[] exclusionPath = new IPath[0];
        boolean shouldBeIncluded = false;
        List<InfoRecorder> children = new ArrayList<InfoRecorder>();

        public InfoRecorder(File dir) {
            this.dir = dir;
            Path path = new Path(dir.getPath());
            IProject project = this.findBelongedProject((IPath)path);
            if (project != null) {
                this.javaProject = JavaCore.create((IProject)project);
                IPath relativeSourcePath = path.makeRelativeTo(project.getLocation());
                this.sourcePath = relativeSourcePath.isEmpty() ? project.getFullPath() : project.getFolder(relativeSourcePath).getFullPath();
            } else {
                IPath workspaceRoot = ProjectUtils.findBelongedWorkspaceRoot((IPath)path);
                if (workspaceRoot != null) {
                    try {
                        project = ProjectUtils.createInvisibleProjectIfNotExist((IPath)workspaceRoot);
                        this.javaProject = JavaCore.create((IProject)project);
                        IFolder workspaceLink = project.getFolder("_");
                        List subProjects = ProjectUtils.getVisibleProjects((IPath)workspaceRoot);
                        this.exclusionPath = (IPath[])subProjects.stream().map(subProject -> {
                            IPath relativePath = subProject.getLocation().makeRelativeTo(workspaceRoot);
                            return workspaceLink.getFolder(relativePath).getFullPath();
                        }).toArray(IPath[]::new);
                        IPath relativeSourcePath = path.makeRelativeTo(workspaceRoot);
                        this.sourcePath = relativeSourcePath.isEmpty() ? workspaceLink.getFullPath() : workspaceLink.getFolder(relativeSourcePath).getFullPath();
                    }
                    catch (CoreException | OperationCanceledException e) {
                        JavaLanguageServerPlugin.logException((String)("Failed to create invisible project for " + workspaceRoot.toString()), (Throwable)e);
                    }
                }
            }
        }

        private IProject findBelongedProject(IPath sourceFolder) {
            List projects = Stream.of(ProjectUtils.getAllProjects()).filter(ProjectUtils::isJavaProject).sorted(new Comparator<IProject>(){

                @Override
                public int compare(IProject p1, IProject p2) {
                    return p2.getLocation().toOSString().length() - p1.getLocation().toOSString().length();
                }
            }).collect(Collectors.toList());
            for (IProject project : projects) {
                if (!project.getLocation().isPrefixOf(sourceFolder)) continue;
                return project;
            }
            return null;
        }
    }
}

