/*
 * Decompiled with CFR 0.152.
 */
package org.elastic.jdt.ls.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ReferenceParams;
import org.elastic.jdt.ls.core.internal.ElasticJavaLanguageServerPlugin;

public class ExtendedReferencesHandler {
    private PreferenceManager preferenceManager;
    private final int MAX_REFERENCES = 1000;

    public ExtendedReferencesHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    private IJavaSearchScope createSearchScope(ITypeRoot unit) throws JavaModelException {
        IJavaProject[] projects = new IJavaProject[]{unit.getJavaProject()};
        int scope = 1;
        if (this.preferenceManager.isClientSupportsClassFileContent()) {
            scope |= 2;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])projects, (int)scope);
    }

    public List<Location> findReferences(ReferenceParams param, IProgressMonitor monitor) {
        ITypeRoot unit = JDTUtils.resolveTypeRoot((String)param.getTextDocument().getUri());
        final ArrayList<Location> locations = new ArrayList<Location>();
        try {
            IJavaElement elementToSearch = JDTUtils.findElementAtSelection((ITypeRoot)JDTUtils.resolveTypeRoot((String)param.getTextDocument().getUri()), (int)param.getPosition().getLine(), (int)param.getPosition().getCharacter(), (PreferenceManager)this.preferenceManager, (IProgressMonitor)monitor);
            if (elementToSearch == null) {
                return locations;
            }
            final boolean includeClassFiles = this.preferenceManager.isClientSupportsClassFileContent();
            SearchEngine engine = new SearchEngine();
            SearchPattern pattern = SearchPattern.createPattern((IJavaElement)elementToSearch, (int)2);
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.createSearchScope(unit), new SearchRequestor(){
                private int currentSymbolNum = 0;

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    if (this.currentSymbolNum >= 1000) {
                        return;
                    }
                    Object o = match.getElement();
                    if (o instanceof IJavaElement) {
                        IClassFile cf;
                        IJavaElement element = (IJavaElement)o;
                        ICompilationUnit compilationUnit = (ICompilationUnit)element.getAncestor(5);
                        Location location = null;
                        if (compilationUnit != null) {
                            location = JDTUtils.toLocation((ICompilationUnit)compilationUnit, (int)match.getOffset(), (int)match.getLength());
                        } else if (includeClassFiles && (cf = (IClassFile)element.getAncestor(6)) != null && cf.getSourceRange() != null) {
                            location = JDTUtils.toLocation((IClassFile)cf, (int)match.getOffset(), (int)match.getLength());
                        }
                        if (location != null) {
                            locations.add(location);
                            ++this.currentSymbolNum;
                        }
                    }
                }
            }, monitor);
        }
        catch (CoreException e) {
            ElasticJavaLanguageServerPlugin.logException("Find references failure ", e);
        }
        return locations;
    }
}

