/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.util.gradle.BuildActionUtil;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.buildship.core.internal.util.gradle.ModelUtils;
import org.eclipse.buildship.core.internal.workspace.FetchStrategy;
import org.eclipse.buildship.core.internal.workspace.ModelProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;

public final class DefaultModelProvider
implements ModelProvider {
    private final GradleBuild gradleBuild;
    private final Cache<Object, Object> cache = CacheBuilder.newBuilder().build();

    public DefaultModelProvider(GradleBuild gradleBuild) {
        this.gradleBuild = gradleBuild;
    }

    @Override
    public <T> T fetchModel(Class<T> model, FetchStrategy strategy, CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        return DefaultModelProvider.injectCompatibilityModel(this.executeModelQuery(model, monitor, strategy, model));
    }

    @Override
    public <T> Collection<T> fetchModels(Class<T> model, FetchStrategy strategy, CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        if (this.supportsCompositeBuilds(tokenSource, monitor)) {
            return DefaultModelProvider.injectCompatibilityModel(model, this.executeCompositeModelQuery(model, monitor, strategy, model));
        }
        return ImmutableList.of(this.fetchModel(model, strategy, tokenSource, monitor));
    }

    private static <T> T injectCompatibilityModel(T model) {
        if (model instanceof EclipseProject) {
            return (T)ModelUtils.createCompatibilityModel((EclipseProject)model);
        }
        return model;
    }

    private static <T> Collection<T> injectCompatibilityModel(Class<T> modelClass, Collection<T> models) {
        if (modelClass == EclipseProject.class) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (T model : models) {
                result.add((Object)ModelUtils.createCompatibilityModel((EclipseProject)model));
            }
            return result.build();
        }
        return models;
    }

    private <T> T executeModelQuery(final Class<T> model, final IProgressMonitor monitor, FetchStrategy fetchStrategy, Class<?> cacheKey) {
        return this.executeOperation(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return DefaultModelProvider.this.gradleBuild.withConnection(connection -> connection.getModel(model), monitor);
            }
        }, fetchStrategy, cacheKey);
    }

    private <T> Collection<T> executeCompositeModelQuery(final Class<T> model, final IProgressMonitor monitor, FetchStrategy fetchStrategy, Class<?> cacheKey) {
        return (Collection)this.executeOperation(new Callable<Collection<T>>(){

            @Override
            public Collection<T> call() throws Exception {
                BuildAction query = BuildActionUtil.compositeModelQuery(model);
                return DefaultModelProvider.this.gradleBuild.withConnection(connection -> (Collection)connection.action(query).run(), monitor);
            }
        }, fetchStrategy, cacheKey);
    }

    private <T> T executeOperation(Callable<T> operation, FetchStrategy fetchStrategy, Class<?> cacheKey) {
        if (FetchStrategy.FROM_CACHE_ONLY == fetchStrategy) {
            Object result = this.cache.getIfPresent(cacheKey);
            return (T)result;
        }
        if (FetchStrategy.FORCE_RELOAD == fetchStrategy) {
            this.cache.invalidate(cacheKey);
        }
        T value = this.getFromCache(cacheKey, operation);
        return value;
    }

    private <U> U getFromCache(Class<?> cacheKey, Callable<U> cacheValueLoader) {
        try {
            Object result = this.cache.get(cacheKey, cacheValueLoader);
            return (U)result;
        }
        catch (Exception e) {
            if (e instanceof UncheckedExecutionException && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new GradlePluginsRuntimeException(e);
        }
    }

    private boolean supportsCompositeBuilds(CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        BuildEnvironment buildEnvironment = this.fetchModel(BuildEnvironment.class, FetchStrategy.FORCE_RELOAD, tokenSource, monitor);
        GradleVersion gradleVersion = GradleVersion.version(buildEnvironment.getGradle().getGradleVersion());
        return gradleVersion.getBaseVersion().compareTo(GradleVersion.version("3.3")) >= 0;
    }
}

