/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.AbstractTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.CaptureType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.WildcardType;

public final class TypeVariable
extends AbstractTypeVariable {
    private ITypeParameter fJavaTypeParameter;

    protected TypeVariable(TypeEnvironment environment) {
        super(environment);
    }

    protected void initialize(ITypeBinding binding, ITypeParameter javaTypeParameter) {
        Assert.isTrue((boolean)binding.isTypeVariable());
        Assert.isNotNull((Object)javaTypeParameter);
        this.fJavaTypeParameter = javaTypeParameter;
        super.initialize(binding);
    }

    @Override
    public int getKind() {
        return 12;
    }

    @Override
    public boolean doEquals(TType type) {
        return this.fJavaTypeParameter.equals(((TypeVariable)type).fJavaTypeParameter);
    }

    @Override
    public int hashCode() {
        return this.fJavaTypeParameter.hashCode();
    }

    @Override
    protected boolean doCanAssignTo(TType lhs) {
        switch (lhs.getKind()) {
            case 1: 
            case 2: {
                return false;
            }
            case 3: 
            case 4: {
                return false;
            }
            case 6: {
                return false;
            }
            case 5: 
            case 7: 
            case 8: {
                return this.canAssignOneBoundTo(lhs);
            }
            case 9: 
            case 10: 
            case 11: {
                return ((WildcardType)lhs).checkAssignmentBound(this);
            }
            case 12: {
                return this.doExtends((TypeVariable)lhs);
            }
            case 13: {
                return ((CaptureType)lhs).checkLowerBound(this);
            }
        }
        return false;
    }

    private boolean doExtends(TypeVariable other) {
        int i = 0;
        while (i < this.fBounds.length) {
            TType bound = this.fBounds[i];
            if (other.equals(bound) || bound.getKind() == 12 && ((TypeVariable)bound).doExtends(other)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.fJavaTypeParameter.getElementName();
    }

    @Override
    public String getPrettySignature() {
        if (this.fBounds.length == 1 && this.fBounds[0].isJavaLangObject()) {
            return this.fJavaTypeParameter.getElementName();
        }
        StringBuilder result = new StringBuilder(this.fJavaTypeParameter.getElementName());
        if (this.fBounds.length > 0) {
            result.append(" extends ");
            result.append(this.fBounds[0].getPlainPrettySignature());
            int i = 1;
            while (i < this.fBounds.length) {
                result.append(" & ");
                result.append(this.fBounds[i].getPlainPrettySignature());
                ++i;
            }
        }
        return result.toString();
    }

    @Override
    protected String getPlainPrettySignature() {
        return this.fJavaTypeParameter.getElementName();
    }
}

