/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.memory;

import java.util.ArrayList;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.AbstractMemoryRenderingBindingsProvider;
import org.eclipse.debug.ui.memory.IMemoryRenderingBindingsProvider;
import org.eclipse.debug.ui.memory.IMemoryRenderingManager;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;

class RenderingBindings
extends AbstractMemoryRenderingBindingsProvider
implements IMemoryRenderingBindingsProvider {
    protected IConfigurationElement fConfigurationElement;
    private IMemoryRenderingType[] fAllTypes;
    private IMemoryRenderingType[] fRenderingTypes;
    private IMemoryRenderingType[] fDefaultTypes;
    private IMemoryRenderingBindingsProvider fProvider;
    private Expression fExpression;
    public static final String ATTR_RENDERING_IDS = "renderingIds";
    public static final String ATTR_DEFAULT_IDS = "defaultIds";
    public static final String ATTR_PRIMARY = "primaryId";
    public static final String ATTR_PROVIDER = "class";
    private static final IMemoryRenderingType[] EMPTY = new IMemoryRenderingType[0];

    RenderingBindings(IConfigurationElement element) {
        this.fConfigurationElement = element;
    }

    private IMemoryRenderingType[] getBindings() {
        if (this.fRenderingTypes == null) {
            int i;
            String ids = this.fConfigurationElement.getAttribute(ATTR_RENDERING_IDS);
            ArrayList<IMemoryRenderingType> list = new ArrayList<IMemoryRenderingType>();
            IMemoryRenderingManager manager = this.getManager();
            if (ids != null) {
                String[] strings = ids.split(",");
                i = 0;
                while (i < strings.length) {
                    String id = strings[i].trim();
                    IMemoryRenderingType type = manager.getRenderingType(id);
                    if (type != null) {
                        list.add(type);
                    }
                    ++i;
                }
            }
            IMemoryRenderingType[] defaultBindings = this.getDefaultBindings();
            i = 0;
            while (i < defaultBindings.length) {
                list.remove(defaultBindings[i]);
                ++i;
            }
            this.fRenderingTypes = list.toArray(new IMemoryRenderingType[list.size()]);
        }
        return this.fRenderingTypes;
    }

    private IMemoryRenderingType[] getDefaultBindings() {
        if (this.fDefaultTypes == null) {
            IMemoryRenderingType type;
            String primaryId;
            String ids = this.fConfigurationElement.getAttribute(ATTR_DEFAULT_IDS);
            ArrayList<IMemoryRenderingType> list = new ArrayList<IMemoryRenderingType>();
            IMemoryRenderingManager manager = this.getManager();
            if (ids != null) {
                String[] strings = ids.split(",");
                int i = 0;
                while (i < strings.length) {
                    String id = strings[i].trim();
                    IMemoryRenderingType type2 = manager.getRenderingType(id);
                    if (type2 != null) {
                        list.add(type2);
                    }
                    ++i;
                }
            }
            if ((primaryId = this.getPrimaryId()) != null && (type = manager.getRenderingType(primaryId)) != null) {
                list.add(type);
            }
            this.fDefaultTypes = list.toArray(new IMemoryRenderingType[list.size()]);
        }
        return this.fDefaultTypes;
    }

    private String getPrimaryId() {
        return this.fConfigurationElement.getAttribute(ATTR_PRIMARY);
    }

    protected IMemoryRenderingBindingsProvider getProvider(IMemoryBlock memoryBlock) {
        if (this.isBound(memoryBlock) && this.fProvider == null) {
            String name = this.fConfigurationElement.getAttribute(ATTR_PROVIDER);
            if (name != null) {
                try {
                    this.fProvider = (IMemoryRenderingBindingsProvider)this.fConfigurationElement.createExecutableExtension(ATTR_PROVIDER);
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
            if (this.fProvider != null) {
                this.fProvider.addListener(this::fireBindingsChanged);
            }
        }
        return this.fProvider;
    }

    private boolean isBound(IMemoryBlock block) {
        Expression expression = this.getExpression();
        if (expression != null) {
            IEvaluationContext context = DebugUIPlugin.createEvaluationContext(block);
            try {
                return expression.evaluate(context) == EvaluationResult.TRUE;
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
                return false;
            }
        }
        return true;
    }

    void validate() throws CoreException {
        if (this.fConfigurationElement.getAttribute(ATTR_PROVIDER) != null && (this.fConfigurationElement.getAttribute(ATTR_RENDERING_IDS) != null || this.fConfigurationElement.getAttribute(ATTR_DEFAULT_IDS) != null || this.fConfigurationElement.getAttribute(ATTR_PRIMARY) != null)) {
            Status status = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, "<renderingBindings> element cannot specify other attributes when class is present", null);
            throw new CoreException((IStatus)status);
        }
    }

    private Expression getExpression() {
        if (this.fExpression == null) {
            IConfigurationElement enablement;
            IConfigurationElement[] elements = this.fConfigurationElement.getChildren("enablement");
            IConfigurationElement iConfigurationElement = enablement = elements.length > 0 ? elements[0] : null;
            if (enablement != null) {
                try {
                    this.fExpression = ExpressionConverter.getDefault().perform(enablement);
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
        }
        return this.fExpression;
    }

    @Override
    public IMemoryRenderingType[] getRenderingTypes(IMemoryBlock block) {
        if (this.isBound(block)) {
            IMemoryRenderingBindingsProvider provider = this.getProvider(block);
            if (provider == null) {
                if (this.fAllTypes == null) {
                    IMemoryRenderingType[] defaultBindings = this.getDefaultBindings();
                    IMemoryRenderingType[] bindings = this.getBindings();
                    this.fAllTypes = new IMemoryRenderingType[defaultBindings.length + bindings.length];
                    int i = 0;
                    while (i < defaultBindings.length) {
                        this.fAllTypes[i] = defaultBindings[i];
                        ++i;
                    }
                    i = 0;
                    int j = defaultBindings.length;
                    while (i < bindings.length) {
                        this.fAllTypes[j] = bindings[i];
                        ++i;
                        ++j;
                    }
                }
                return this.fAllTypes;
            }
            return provider.getRenderingTypes(block);
        }
        return EMPTY;
    }

    @Override
    public IMemoryRenderingType[] getDefaultRenderingTypes(IMemoryBlock block) {
        if (this.isBound(block)) {
            IMemoryRenderingBindingsProvider provider = this.getProvider(block);
            if (provider == null) {
                return this.getDefaultBindings();
            }
            return provider.getDefaultRenderingTypes(block);
        }
        return EMPTY;
    }

    @Override
    public IMemoryRenderingType getPrimaryRenderingType(IMemoryBlock block) {
        if (this.isBound(block)) {
            IMemoryRenderingBindingsProvider provider = this.getProvider(block);
            if (provider == null) {
                String primaryId = this.getPrimaryId();
                if (primaryId != null) {
                    return this.getManager().getRenderingType(primaryId);
                }
            } else {
                return provider.getPrimaryRenderingType(block);
            }
        }
        return null;
    }

    private IMemoryRenderingManager getManager() {
        return DebugUITools.getMemoryRenderingManager();
    }
}

