/*
 * Decompiled with CFR 0.152.
 */
package org.elastic.jdt.ls.core.internal.manifest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.ls.core.internal.AbstractProjectImporter;
import org.eclipse.jdt.ls.core.internal.managers.BasicFileDetector;
import org.elastic.jdt.ls.core.internal.ElasticJavaLanguageServerPlugin;
import org.elastic.jdt.ls.core.internal.manifest.ProjectCreator;
import org.elastic.jdt.ls.core.internal.manifest.model.Config;
import org.elastic.jdt.ls.core.internal.manifest.model.ProjectInfo;

public class GradleManifestImporter
extends AbstractProjectImporter {
    public static final String GRADLE_MANIFEST_FILE = "manifest.json";
    public static final String IMPORTING_GRADLE_MANIFEST_PROJECTS = "Importing Gradle manifest project(s)";
    private Collection<Path> directories;

    public boolean applies(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (this.rootFolder == null) {
            return false;
        }
        ElasticJavaLanguageServerPlugin.getPreferencesManager();
        if (this.directories == null) {
            BasicFileDetector gradleManifestDetector = new BasicFileDetector(this.rootFolder.toPath(), GRADLE_MANIFEST_FILE).includeNested(false);
            this.directories = gradleManifestDetector.scan(monitor);
        }
        return !this.directories.isEmpty();
    }

    public void importToWorkspace(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (!this.applies(monitor)) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.directories.size() + 1));
        subMonitor.setTaskName(IMPORTING_GRADLE_MANIFEST_PROJECTS);
        ElasticJavaLanguageServerPlugin.logInfo(IMPORTING_GRADLE_MANIFEST_PROJECTS);
        subMonitor.worked(1);
        ProjectCreator pc = new ProjectCreator();
        for (Path projectDir : this.directories) {
            Config config = this.deserializedConfig(String.valueOf(projectDir.toString()) + "/" + GRADLE_MANIFEST_FILE);
            String rootProjectName = config.getProjectInfos().stream().filter(info -> info.getPath().equals(":")).findFirst().get().getName();
            config.getProjectInfos().forEach(info -> pc.createJavaProjectFromProjectInfo(projectDir, rootProjectName, (ProjectInfo)info, (IProgressMonitor)subMonitor.newChild(1)));
        }
        subMonitor.done();
    }

    private Config deserializedConfig(String file) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            Gson gson = new GsonBuilder().create();
            return (Config)gson.fromJson((Reader)bufferedReader, Config.class);
        }
        catch (FileNotFoundException e) {
            ElasticJavaLanguageServerPlugin.logException("Cannot parse manifest config file: " + file, e);
            return null;
        }
    }

    public void reset() {
        this.directories = null;
    }
}

