/*
 * Decompiled with CFR 0.152.
 */
package org.elastic.jdt.ls.core.internal;

import java.util.ArrayList;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.handlers.DocumentSymbolHandler;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.elastic.jdt.ls.core.internal.DetailSymbolInformation;
import org.elastic.jdt.ls.core.internal.ElasticJavaLanguageServerPlugin;
import org.elastic.jdt.ls.core.internal.Full;
import org.elastic.jdt.ls.core.internal.FullParams;
import org.elastic.jdt.ls.core.internal.QnameHelper;
import org.elastic.jdt.ls.core.internal.Reference;
import org.elastic.jdt.ls.core.internal.ReferenceCategory;
import org.elastic.jdt.ls.core.internal.SymbolLocator;
import org.elastic.jdt.ls.core.internal.hover.JavaElementLabels;

public class FullHandler {
    private final PreferenceManager preferenceManager;

    public FullHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public Full full(FullParams fullParams, IProgressMonitor monitor) {
        ITypeRoot unit = JDTUtils.resolveTypeRoot((String)fullParams.getTextDocumentIdentifier().getUri());
        TextDocumentIdentifier textDocument = fullParams.getTextDocumentIdentifier();
        return this.getFull(unit, fullParams.isReference(), textDocument, monitor);
    }

    private Full getFull(ITypeRoot unit, boolean isReference, TextDocumentIdentifier textDocument, IProgressMonitor monitor) {
        try {
            IJavaElement[] elements = unit.getChildren();
            ArrayList<DetailSymbolInformation> symbols = new ArrayList<DetailSymbolInformation>(elements.length);
            ArrayList<Reference> references = new ArrayList<Reference>();
            this.collectSymbols(unit, elements, symbols, monitor);
            if (isReference) {
                this.collectReferences(references, textDocument, monitor);
            }
            return new Full(symbols, references);
        }
        catch (JavaModelException e) {
            ElasticJavaLanguageServerPlugin.logException("Problem getting outline for" + unit.getElementName(), e);
            if (e.getMessage().indexOf("exist") != -1) {
                throw new RuntimeException("temporarily unavailable");
            }
            return null;
        }
    }

    private void collectSymbols(ITypeRoot unit, IJavaElement[] elements, ArrayList<DetailSymbolInformation> symbols, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            try {
                if (monitor.isCanceled()) {
                    return;
                }
                if (element instanceof IParent) {
                    this.collectSymbols(unit, this.filter(((IParent)element).getChildren()), symbols, monitor);
                }
                Location rawLocation = JDTUtils.toLocation((IJavaElement)element);
                int type = element.getElementType();
                if ((type == 7 || type == 8 || type == 9) && rawLocation != null) {
                    SymbolInformation si = new SymbolInformation();
                    String qname = JavaElementLabels.getTextLabel(element, JavaElementLabels.ALL_FULLY_QUALIFIED);
                    String name = JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_DEFAULT);
                    si.setName(name == null ? element.getElementName() : name);
                    si.setName(name == null ? element.getElementName() : name);
                    si.setKind(DocumentSymbolHandler.mapKind((IJavaElement)element));
                    if (element.getParent() != null) {
                        si.setContainerName(element.getParent().getElementName());
                    }
                    rawLocation.setUri(ResourceUtils.toClientUri((String)rawLocation.getUri()));
                    si.setLocation(rawLocation);
                    DetailSymbolInformation detailSymbolInfo = new DetailSymbolInformation(si, QnameHelper.getSimplifiedQname(qname));
                    if (!symbols.contains(detailSymbolInfo)) {
                        symbols.add(detailSymbolInfo);
                    }
                }
            }
            catch (Exception e) {
                ElasticJavaLanguageServerPlugin.logException("Problem when do indexing for" + unit.getElementName(), e);
            }
            ++n2;
        }
    }

    private void collectReferences(final ArrayList<Reference> references, final TextDocumentIdentifier textDocument, IProgressMonitor monitor) {
        ICompilationUnit compilationUnit = JDTUtils.resolveCompilationUnit((String)textDocument.getUri());
        ASTParser parser = ASTParser.newParser((int)13);
        parser.setKind(8);
        parser.setSource(compilationUnit);
        parser.setResolveBindings(true);
        parser.setEnvironment(null, null, null, true);
        parser.setBindingsRecovery(true);
        final CompilationUnit ast = (CompilationUnit)parser.createAST(null);
        ast.accept(new ASTVisitor(){

            public boolean visit(QualifiedName node) {
                IBinding bind = node.resolveBinding();
                if (bind == null) {
                    return false;
                }
                try {
                    this.addReferenceOfNode(bind.getJavaElement(), this.toRange(node.getStartPosition(), node.getLength()));
                }
                catch (Exception exception) {
                    return false;
                }
                return false;
            }

            public boolean visit(SuperFieldAccess node) {
                IVariableBinding bind = node.resolveFieldBinding();
                if (bind == null) {
                    return false;
                }
                try {
                    this.addReferenceOfNode(bind.getJavaElement(), this.toRange(node.getStartPosition(), node.getLength()));
                }
                catch (Exception exception) {
                    return false;
                }
                return true;
            }

            public boolean visit(FieldAccess node) {
                IVariableBinding bind = node.resolveFieldBinding();
                if (bind == null) {
                    return false;
                }
                try {
                    this.addReferenceOfNode(bind.getJavaElement(), this.toRange(node.getStartPosition(), node.getLength()));
                }
                catch (Exception exception) {
                    return false;
                }
                return true;
            }

            public boolean visit(ConstructorInvocation node) {
                IMethodBinding bind = node.resolveConstructorBinding();
                if (bind == null) {
                    return false;
                }
                try {
                    this.addReferenceOfNode(bind.getJavaElement(), this.toRange(node.getStartPosition(), node.getLength()));
                }
                catch (Exception exception) {
                    return false;
                }
                return true;
            }

            public boolean visit(SuperConstructorInvocation node) {
                IMethodBinding bind = node.resolveConstructorBinding();
                if (bind == null) {
                    return false;
                }
                try {
                    this.addReferenceOfNode(bind.getJavaElement(), this.toRange(node.getStartPosition(), node.getLength()));
                }
                catch (Exception exception) {
                    return false;
                }
                return true;
            }

            public boolean visit(SuperMethodInvocation node) {
                IMethodBinding bind = node.resolveMethodBinding();
                if (bind == null) {
                    return false;
                }
                try {
                    this.addReferenceOfNode(bind.getJavaElement(), this.toRange(node.getStartPosition(), node.getLength()));
                }
                catch (Exception exception) {
                    return false;
                }
                return true;
            }

            public boolean visit(MethodInvocation node) {
                IMethodBinding bind = node.resolveMethodBinding();
                if (bind == null) {
                    return false;
                }
                try {
                    this.addReferenceOfNode(bind.getJavaElement(), this.toRange(node.getStartPosition(), node.getLength()));
                }
                catch (Exception exception) {
                    return false;
                }
                return true;
            }

            private void addReferenceOfNode(IJavaElement element, Range range) {
                try {
                    Location rawLocation = JDTUtils.toLocation((String)textDocument.getUri());
                    rawLocation.setRange(range);
                    if (element != null) {
                        Reference reference;
                        Location location = JDTUtils.toLocation((IJavaElement)element);
                        if (element instanceof IMember && ((IMember)element).getClassFile() != null) {
                            location = JDTUtils.toLocation((IClassFile)((IMember)element).getClassFile());
                        }
                        if (location != null) {
                            reference = new Reference(ReferenceCategory.UNCATEGORIZED, rawLocation, new SymbolLocator(location));
                        } else {
                            String qname = JavaElementLabels.getTextLabel(element, JavaElementLabels.ALL_FULLY_QUALIFIED);
                            reference = new Reference(ReferenceCategory.UNCATEGORIZED, rawLocation, new SymbolLocator(QnameHelper.getSimplifiedQname(qname), DocumentSymbolHandler.mapKind((IJavaElement)element)));
                        }
                        references.add(reference);
                    }
                }
                catch (JavaModelException e) {
                    ElasticJavaLanguageServerPlugin.logException("Find references failure ", e);
                }
            }

            private Range toRange(int start, int length) {
                Range range = JDTUtils.newRange();
                this.setPosition(range.getStart(), start);
                this.setPosition(range.getEnd(), start + length);
                return range;
            }

            private void setPosition(Position position, int offset) {
                int line = ast.getLineNumber(offset) - 1;
                int column = ast.getColumnNumber(offset);
                position.setLine(line);
                position.setCharacter(column);
            }
        });
    }

    private IJavaElement[] filter(IJavaElement[] elements) {
        return (IJavaElement[])Stream.of(elements).filter(e -> !this.isInitializer((IJavaElement)e) && !this.isSyntheticElement((IJavaElement)e)).toArray(IJavaElement[]::new);
    }

    private boolean isInitializer(IJavaElement element) {
        String name;
        return element.getElementType() == 9 && (name = element.getElementName()) != null && name.indexOf(60) >= 0;
    }

    private boolean isSyntheticElement(IJavaElement element) {
        if (!(element instanceof IMember)) {
            return false;
        }
        IMember member = (IMember)element;
        if (!member.isBinary()) {
            return false;
        }
        try {
            return Flags.isSynthetic((int)member.getFlags());
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

