/*
 * Decompiled with CFR 0.152.
 */
package org.elastic.jdt.ls.core.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.ls.core.internal.CancellableProgressMonitor;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.JDTLanguageServer;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.elastic.jdt.ls.core.internal.BuildPathHelper;
import org.elastic.jdt.ls.core.internal.EDefinitionHandler;
import org.elastic.jdt.ls.core.internal.ElasticJavaLanguageServerPlugin;
import org.elastic.jdt.ls.core.internal.ExtendedHoverHandler;
import org.elastic.jdt.ls.core.internal.ExtendedReferencesHandler;
import org.elastic.jdt.ls.core.internal.Full;
import org.elastic.jdt.ls.core.internal.FullHandler;
import org.elastic.jdt.ls.core.internal.FullParams;
import org.elastic.jdt.ls.core.internal.SymbolLocator;
import org.elastic.jdt.ls.core.internal.SynchronizedWorkspaceFolderChangeHandler;

public class ElasticJDTLanguageServer
extends JDTLanguageServer {
    private static final int FORCED_EXIT_CODE = 1;
    private ProjectsManager pm = JavaLanguageServerPlugin.getProjectsManager();
    private PreferenceManager preferenceManager = JavaLanguageServerPlugin.getPreferencesManager();

    public ElasticJDTLanguageServer(ProjectsManager projects, PreferenceManager preferenceManager) {
        super(JavaLanguageServerPlugin.getProjectsManager(), JavaLanguageServerPlugin.getPreferencesManager());
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        ElasticJavaLanguageServerPlugin.logInfo("Elastic Java Language Server version: " + ElasticJavaLanguageServerPlugin.getVersion());
        CompletableFuture result = super.initialize(params);
        BuildPathHelper pathHelper = new BuildPathHelper(ResourceUtils.canonicalFilePathFromURI((String)params.getRootUri()), super.getClientConnection());
        pathHelper.IncludeAllJavaFiles();
        try {
            Job.getJobManager().join((Object)"java-ls-initialization-jobs", null);
        }
        catch (InterruptedException | OperationCanceledException e) {
            JavaLanguageServerPlugin.logException((String)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public void initialized(InitializedParams params) {
        ElasticJavaLanguageServerPlugin.logInfo(">> initialized");
        if (this.preferenceManager.getClientPreferences().isCompletionDynamicRegistered()) {
            this.registerCapability(Preferences.COMPLETION_ID, "textDocument/completion", CompletionHandler.DEFAULT_COMPLETION_OPTIONS);
        }
        if (this.preferenceManager.getClientPreferences().isWorkspaceSymbolDynamicRegistered()) {
            this.registerCapability(Preferences.WORKSPACE_SYMBOL_ID, "workspace/symbol");
        }
        if (this.preferenceManager.getClientPreferences().isDocumentSymbolDynamicRegistered()) {
            this.registerCapability(Preferences.DOCUMENT_SYMBOL_ID, "textDocument/documentSymbol");
        }
        if (this.preferenceManager.getClientPreferences().isDefinitionDynamicRegistered()) {
            this.registerCapability(Preferences.DEFINITION_ID, "textDocument/definition");
        }
        if (this.preferenceManager.getClientPreferences().isTypeDefinitionDynamicRegistered()) {
            this.registerCapability(Preferences.TYPEDEFINITION_ID, "textDocument/typeDefinition");
        }
        if (this.preferenceManager.getClientPreferences().isHoverDynamicRegistered()) {
            this.registerCapability(Preferences.HOVER_ID, "textDocument/hover");
        }
        if (this.preferenceManager.getClientPreferences().isReferencesDynamicRegistered()) {
            this.registerCapability(Preferences.REFERENCES_ID, "textDocument/references");
        }
        if (this.preferenceManager.getClientPreferences().isDocumentHighlightDynamicRegistered()) {
            this.registerCapability(Preferences.DOCUMENT_HIGHLIGHT_ID, "textDocument/documentHighlight");
        }
        if (this.preferenceManager.getClientPreferences().isFoldgingRangeDynamicRegistered()) {
            this.registerCapability(Preferences.FOLDINGRANGE_ID, "textDocument/foldingRange");
        }
        if (this.preferenceManager.getClientPreferences().isWorkspaceFoldersSupported()) {
            this.registerCapability(Preferences.WORKSPACE_CHANGE_FOLDERS_ID, "workspace/didChangeWorkspaceFolders");
        }
        if (this.preferenceManager.getClientPreferences().isImplementationDynamicRegistered()) {
            this.registerCapability(Preferences.IMPLEMENTATION_ID, "textDocument/implementation");
        }
        try {
            MethodUtils.invokeMethod((Object)JavaLanguageServerPlugin.getInstance().getProtocol(), (String)"syncCapabilitiesToSettings", (Object[])new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            ElasticJavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        Job initializeWorkspace = new Job("Initialize workspace"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    JobHelpers.waitForBuildJobs((int)3600000);
                    ElasticJavaLanguageServerPlugin.logInfo(">> build jobs finished");
                }
                catch (OperationCanceledException e) {
                    ElasticJavaLanguageServerPlugin.logException(e.getMessage(), e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        initializeWorkspace.setPriority(40);
        initializeWorkspace.setSystem(true);
        initializeWorkspace.schedule();
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        ElasticJavaLanguageServerPlugin.logInfo(">> java/didChangeWorkspaceFolders");
        SynchronizedWorkspaceFolderChangeHandler handler = new SynchronizedWorkspaceFolderChangeHandler(this.pm);
        handler.update(params);
        BuildPathHelper pathHelper = new BuildPathHelper(ResourceUtils.canonicalFilePathFromURI((String)((WorkspaceFolder)params.getEvent().getAdded().get(0)).getUri()), super.getClientConnection());
        pathHelper.IncludeAllJavaFiles();
        try {
            Job.getJobManager().join((Object)"java-ls-initialization-jobs", null);
        }
        catch (InterruptedException | OperationCanceledException e) {
            JavaLanguageServerPlugin.logException((String)e.getMessage(), (Throwable)e);
        }
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        this.setActiveElementInASTProvider(JDTUtils.resolveCompilationUnit((String)params.getTextDocument().getUri()));
        return super.documentSymbol(params);
    }

    public CompletableFuture<Hover> hover(TextDocumentPositionParams position) {
        ElasticJavaLanguageServerPlugin.logInfo(">> document/hover");
        ExtendedHoverHandler handler = new ExtendedHoverHandler(this.preferenceManager);
        this.setActiveElementInASTProvider(JDTUtils.resolveCompilationUnit((String)position.getTextDocument().getUri()));
        return this.computeAsync(monitor -> handler.extendedHover(position, (IProgressMonitor)monitor));
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        ElasticJavaLanguageServerPlugin.logInfo(">> document/references");
        ExtendedReferencesHandler handler = new ExtendedReferencesHandler(this.preferenceManager);
        this.setActiveElementInASTProvider(JDTUtils.resolveCompilationUnit((String)params.getTextDocument().getUri()));
        return this.computeAsync(monitor -> handler.findReferences(params, (IProgressMonitor)monitor));
    }

    @JsonRequest(value="textDocument/full", useSegment=false)
    public CompletableFuture<Full> full(FullParams fullParams) {
        ElasticJavaLanguageServerPlugin.logInfo(">> document/full");
        FullHandler handler = new FullHandler(this.preferenceManager);
        this.setActiveElementInASTProvider(JDTUtils.resolveCompilationUnit((String)fullParams.getTextDocumentIdentifier().getUri()));
        return this.computeAsync(monitor -> handler.full(fullParams, (IProgressMonitor)monitor));
    }

    @JsonRequest(value="textDocument/edefinition", useSegment=false)
    public CompletableFuture<SymbolLocator> eDefinition(TextDocumentPositionParams position) {
        ElasticJavaLanguageServerPlugin.logInfo(">> document/edefinition");
        EDefinitionHandler handler = new EDefinitionHandler(this.preferenceManager);
        this.setActiveElementInASTProvider(JDTUtils.resolveCompilationUnit((String)position.getTextDocument().getUri()));
        return this.computeAsync(monitor -> handler.eDefinition(position, (IProgressMonitor)monitor));
    }

    public void exit() {
        ElasticJavaLanguageServerPlugin.logInfo(">> exit");
        ElasticJavaLanguageServerPlugin.getLanguageServer().exit();
        Executors.newSingleThreadScheduledExecutor().schedule(() -> {
            ElasticJavaLanguageServerPlugin.logInfo("Forcing exit after 1 min.");
            System.exit(1);
        }, 1L, TimeUnit.MINUTES);
    }

    private <R> CompletableFuture<R> computeAsync(Function<IProgressMonitor, R> code) {
        return CompletableFutures.computeAsync(cc -> code.apply(this.toMonitor((CancelChecker)cc)));
    }

    private IProgressMonitor toMonitor(CancelChecker checker) {
        return new CancellableProgressMonitor(checker);
    }

    private void setActiveElementInASTProvider(ICompilationUnit unit) {
        if (unit != null) {
            CoreASTProvider.getInstance().setActiveJavaElement((ITypeRoot)unit);
        }
    }

    private void waitForLifecycleJobs(IProgressMonitor monitor) {
        try {
            Job.getJobManager().join((Object)"DocumentLifeCycleJobs", monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InterruptedException e) {
            JavaLanguageServerPlugin.logException((String)e.getMessage(), (Throwable)e);
        }
    }
}

