/*
 * Decompiled with CFR 0.152.
 */
package org.elastic.jdt.ls.core.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.taskdefs.Javac;
import org.eclipse.ant.internal.ui.datatransfer.ProjectCreator;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntTaskNode;
import org.eclipse.ant.internal.ui.model.IAntElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ls.core.internal.AbstractProjectImporter;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.managers.BasicFileDetector;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.elastic.jdt.ls.core.internal.ANTUtils;

public class AntProjectImporter
extends AbstractProjectImporter {
    public static final String IMPORTING_ANT_PROJECTS = "Importing Ant project(s)";
    public static final String ANT_FILE = "build.xml";
    private Collection<Path> directories;

    public boolean applies(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (this.rootFolder == null) {
            return false;
        }
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferencesManager != null && !preferencesManager.getPreferences().isImportMavenEnabled()) {
            return false;
        }
        if (this.directories == null) {
            BasicFileDetector antDetector = new BasicFileDetector(this.rootFolder.toPath(), ANT_FILE).includeNested(false);
            this.directories = antDetector.scan(monitor);
        }
        return !this.directories.isEmpty();
    }

    public void importToWorkspace(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (!this.applies(monitor)) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)105);
        subMonitor.setTaskName(IMPORTING_ANT_PROJECTS);
        JavaLanguageServerPlugin.logInfo((String)IMPORTING_ANT_PROJECTS);
        ProjectCreator pc = new ProjectCreator();
        for (Path project : this.directories) {
            AntProjectNode antProjectNode = ANTUtils.getProjectNode(String.valueOf(project.toString()) + '/' + ANT_FILE);
            if (antProjectNode == null) continue;
            ArrayList<AntTaskNode> javacNodes = new ArrayList<AntTaskNode>();
            ANTUtils.getJavacNodes(javacNodes, (IAntElement)antProjectNode);
            List<?> javacTasks = ANTUtils.resolveJavacTasks(javacNodes);
            try {
                Javac javacTask = (Javac)javacTasks.get(0);
                IJavaProject javaProject = pc.createJavaProjectFromJavacNode(project.getFileName().toString(), javacTask, (IProgressMonitor)subMonitor);
                if (javaProject != null) continue;
                JavaLanguageServerPlugin.logError((String)"ant project is null");
            }
            catch (Exception e) {
                JavaLanguageServerPlugin.logException((String)"import ant project error", (Throwable)e);
            }
        }
        subMonitor.done();
    }

    public void reset() {
    }
}

