/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.preferences;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.internal.core.manipulation.CodeTemplateContextType;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.StatusFactory;
import org.eclipse.jdt.ls.core.internal.preferences.ClientPreferences;
import org.eclipse.jdt.ls.core.internal.preferences.CodeGenerationTemplate;
import org.eclipse.jdt.ls.core.internal.preferences.IPreferencesChangeListener;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.preferences.ProblemSeverity;
import org.eclipse.text.templates.ContextTypeRegistry;
import org.eclipse.text.templates.TemplatePersistenceData;
import org.eclipse.text.templates.TemplateReaderWriter;
import org.eclipse.text.templates.TemplateStoreCore;

public class PreferenceManager {
    private Preferences preferences = new Preferences();
    private static final String M2E_APT_ID = "org.jboss.tools.maven.apt";
    private static final String CUSTOM_CODE_TEMPLATES = "org.eclipse.jdt.ls.core.custom_code_templates";
    private ClientPreferences clientPreferences;
    private IMavenConfiguration mavenConfig;
    private ListenerList<IPreferencesChangeListener> preferencesChangeListeners = new ListenerList();
    private IEclipsePreferences eclipsePrefs = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");

    public PreferenceManager() {
        PreferenceManager.initialize();
    }

    public static void initialize() {
        Hashtable javaCoreOptions = JavaCore.getOptions();
        javaCoreOptions.put("org.eclipse.jdt.core.codeComplete.visibilityCheck", "enabled");
        javaCoreOptions.put("org.eclipse.jdt.core.compiler.release", "enabled");
        javaCoreOptions.put("org.eclipse.jdt.core.formatter.use_on_off_tags", "true");
        JavaCore.setOptions((Hashtable)javaCoreOptions);
        IEclipsePreferences defEclipsePrefs = DefaultScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");
        defEclipsePrefs.put("org.eclipse.jdt.ui.typefilter.enabled", "");
        defEclipsePrefs.put("org.eclipse.jdt.ui.importorder", String.join((CharSequence)";", Preferences.JAVA_IMPORT_ORDER_DEFAULT));
        defEclipsePrefs.put("org.eclipse.jdt.ui.ondemandthreshold", "99");
        defEclipsePrefs.put("org.eclipse.jdt.ui.staticondemandthreshold", "99");
        defEclipsePrefs.put("outlinesortoption", "T,SF,SI,SM,F,I,C,M");
        defEclipsePrefs.put("org.eclipse.jdt.ui.keywordthis", Boolean.FALSE.toString());
        defEclipsePrefs.put("org.eclipse.jdt.ui.gettersetter.use.is", Boolean.TRUE.toString());
        defEclipsePrefs.put("org.eclipse.jdt.ui.exception.name", "e");
        defEclipsePrefs.put("org.eclipse.jdt.ui.javadoc", Boolean.FALSE.toString());
        IEclipsePreferences m2eAptPrefs = DefaultScope.INSTANCE.getNode(M2E_APT_ID);
        if (m2eAptPrefs != null) {
            m2eAptPrefs.put("org.jboss.tools.maven.apt.mode", "jdt_apt");
        }
        PreferenceManager.initializeMavenPreferences();
        Template[] templates = new Template[]{CodeGenerationTemplate.FIELDCOMMENT.createTemplate(null), CodeGenerationTemplate.METHODCOMMENT.createTemplate(null), CodeGenerationTemplate.CONSTRUCTORCOMMENT.createTemplate(null), CodeGenerationTemplate.CONSTRUCTORBODY.createTemplate(null), CodeGenerationTemplate.DELEGATECOMMENT.createTemplate(null), CodeGenerationTemplate.OVERRIDECOMMENT.createTemplate(null), CodeGenerationTemplate.TYPECOMMENT.createTemplate(null), CodeGenerationTemplate.GETTERCOMMENT.createTemplate(null), CodeGenerationTemplate.SETTERCOMMENT.createTemplate(null), CodeGenerationTemplate.GETTERBODY.createTemplate(null), CodeGenerationTemplate.SETTERBOY.createTemplate(null), CodeGenerationTemplate.CATCHBODY.createTemplate(null), CodeGenerationTemplate.METHODBODY.createTemplate(null)};
        TemplatePersistenceData[] templateData = Arrays.asList(templates).stream().map(t -> new TemplatePersistenceData(t, true, t.getDescription())).collect(Collectors.toList()).toArray(new TemplatePersistenceData[0]);
        TemplateReaderWriter trw = new TemplateReaderWriter();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (StringWriter wrt = new StringWriter();){
                trw.save(templateData, (Writer)wrt);
                defEclipsePrefs.put(CUSTOM_CODE_TEMPLATES, ((Object)wrt).toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ContextTypeRegistry registry = new ContextTypeRegistry();
        CodeTemplateContextType.registerContextTypes((ContextTypeRegistry)registry);
        registry.addContextType((TemplateContextType)new CodeTemplateContextType("classsnippet_context"));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType("interfacesnippet_context"));
        TemplateStoreCore tscore = new TemplateStoreCore(defEclipsePrefs, CUSTOM_CODE_TEMPLATES);
        try {
            tscore.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JavaManipulation.setCodeTemplateStore((TemplateStoreCore)tscore);
        JavaManipulation.setCodeTemplateContextRegistry((ContextTypeRegistry)registry);
    }

    private static void initializeMavenPreferences() {
        IEclipsePreferences store = InstanceScope.INSTANCE.getNode("org.eclipse.m2e.core");
        store.put("eclipse.m2.problem.outofdateProjectConfig", ProblemSeverity.warning.toString());
    }

    public void update(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Preferences can not be null");
        }
        this.preferencesChanged(this.preferences, preferences);
        this.preferences = preferences;
        String newMavenSettings = preferences.getMavenUserSettings();
        String oldMavenSettings = this.getMavenConfiguration().getUserSettingsFile();
        if (!Objects.equals(newMavenSettings, oldMavenSettings)) {
            try {
                this.getMavenConfiguration().setUserSettingsFile(newMavenSettings);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("failed to set Maven settings", e);
                preferences.setMavenUserSettings(oldMavenSettings);
            }
        }
        this.updateParallelBuild(this.preferences.getMaxConcurrentBuilds());
    }

    private void preferencesChanged(final Preferences oldPreferences, final Preferences newPreferences) {
        for (final IPreferencesChangeListener listener : this.preferencesChangeListeners) {
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable e) {
                    JavaLanguageServerPlugin.log(new CoreException(StatusFactory.newErrorStatus(e.getMessage(), e)));
                }

                public void run() throws Exception {
                    listener.preferencesChange(oldPreferences, newPreferences);
                }
            };
            SafeRunner.run((ISafeRunnable)job);
        }
    }

    private void updateParallelBuild(int maxConcurrentBuilds) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        if (description.getMaxConcurrentBuilds() == maxConcurrentBuilds) {
            return;
        }
        description.setMaxConcurrentBuilds(maxConcurrentBuilds);
        try {
            workspace.setDescription(description);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problems setting maxConcurrentBuilds from workspace.", e);
        }
        String stringValue = maxConcurrentBuilds != 1 ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("org.eclipse.m2e.core");
        pref.put("builderUsesNullSchedulingRule", stringValue);
        pref = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.core");
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public Preferences getPreferences(IResource resource) {
        return this.preferences;
    }

    public ClientPreferences getClientPreferences() {
        return this.clientPreferences;
    }

    public void updateClientPrefences(ClientCapabilities clientCapabilities, Map<String, Object> extendedClientCapabilities) {
        this.clientPreferences = new ClientPreferences(clientCapabilities, extendedClientCapabilities);
    }

    public IMavenConfiguration getMavenConfiguration() {
        if (this.mavenConfig == null) {
            this.mavenConfig = MavenPlugin.getMavenConfiguration();
        }
        return this.mavenConfig;
    }

    public void setMavenConfiguration(IMavenConfiguration mavenConfig) {
        this.mavenConfig = mavenConfig;
    }

    public static Preferences getPrefs(IResource resource) {
        return JavaLanguageServerPlugin.getPreferencesManager().getPreferences(resource);
    }

    public static CodeGenerationSettings getCodeGenerationSettings(IResource resource) {
        IJavaProject project = JavaCore.create((IProject)resource.getProject());
        CodeGenerationSettings res = new CodeGenerationSettings();
        res.overrideAnnotation = true;
        res.createComments = false;
        res.tabWidth = CodeFormatterUtil.getTabWidth((IJavaProject)project);
        res.indentWidth = CodeFormatterUtil.getIndentWidth((IJavaProject)project);
        return res;
    }

    public void addPreferencesChangeListener(IPreferencesChangeListener listener) {
        this.preferencesChangeListeners.add((Object)listener);
    }

    public void removePreferencesChangeListener(IPreferencesChangeListener listener) {
        this.preferencesChangeListeners.remove((Object)listener);
    }

    public IEclipsePreferences getEclipsePreferences() {
        return this.eclipsePrefs;
    }

    public boolean isClientSupportsClassFileContent() {
        return this.getClientPreferences() != null && this.getClientPreferences().isClassFileContentSupported();
    }

    public boolean isClientSupportsCompletionDocumentationMarkDown() {
        return this.getClientPreferences() != null && this.getClientPreferences().isSupportsCompletionDocumentationMarkdown();
    }
}

