/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.DigestStore;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.project.ProjectConfigurationManager;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.jdt.IClasspathManager;
import org.eclipse.m2e.jdt.MavenJdtPlugin;

public class MavenBuildSupport
implements IBuildSupport {
    private static final int MAX_TIME_MILLIS = 3000;
    private static Cache<String, Boolean> downloadRequestsCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.HOURS).build();
    private IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
    private ProjectRegistryManager projectManager = MavenPluginActivator.getDefault().getMavenProjectManagerImpl();
    private DigestStore digestStore = JavaLanguageServerPlugin.getDigestStore();
    private IMavenProjectRegistry registry = MavenPlugin.getMavenProjectRegistry();
    private boolean shouldCollectProjects = true;

    @Override
    public boolean applies(IProject project) {
        return ProjectUtils.isMavenProject(project);
    }

    @Override
    public void update(IProject project, boolean force, IProgressMonitor monitor) throws CoreException {
        if (!this.applies(project)) {
            return;
        }
        Path pomPath = project.getFile("pom.xml").getLocation().toFile().toPath();
        if (this.digestStore.updateDigest(pomPath) || force) {
            JavaLanguageServerPlugin.logInfo("Starting Maven update for " + project.getName());
            if (this.shouldCollectProjects()) {
                LinkedHashSet<IProject> projectSet = new LinkedHashSet<IProject>();
                this.collectProjects(projectSet, project, monitor);
                IProject[] projects = projectSet.toArray(new IProject[0]);
                MavenUpdateRequest request = new MavenUpdateRequest(projects, MavenPlugin.getMavenConfiguration().isOffline(), true);
                ((ProjectConfigurationManager)this.configurationManager).updateProjectConfiguration(request, true, true, monitor);
            } else {
                MavenUpdateRequest request = new MavenUpdateRequest(project, MavenPlugin.getMavenConfiguration().isOffline(), true);
                this.configurationManager.updateProjectConfiguration(request, monitor);
            }
        }
    }

    public void collectProjects(Collection<IProject> projects, IProject project, IProgressMonitor monitor) {
        if (!project.isOpen() || !ProjectUtils.isMavenProject(project)) {
            return;
        }
        projects.add(project);
        IMavenProjectFacade projectFacade = this.registry.create(project, monitor);
        if (projectFacade != null && "pom".equals(projectFacade.getPackaging())) {
            List modules = projectFacade.getMavenProjectModules();
            for (String module : modules) {
                IProject p;
                IPath pomPath = ResourcesPlugin.getWorkspace().getRoot().getFullPath().append(module).append("pom.xml");
                IFile pom = ResourcesPlugin.getWorkspace().getRoot().getFile(pomPath);
                if (!pom.exists() || !(p = pom.getProject()).isOpen()) continue;
                this.collectProjects(projects, p, monitor);
            }
        }
    }

    @Override
    public boolean isBuildFile(IResource resource) {
        return resource != null && resource.getProject() != null && resource.getType() == 1 && resource.getName().equals("pom.xml") && resource.getProject().equals((Object)resource.getParent());
    }

    public boolean shouldCollectProjects() {
        return this.shouldCollectProjects;
    }

    public void setShouldCollectProjects(boolean shouldCollectProjects) {
        this.shouldCollectProjects = shouldCollectProjects;
    }

    @Override
    public boolean fileChanged(IResource resource, ProjectsManager.CHANGE_TYPE changeType, IProgressMonitor monitor) throws CoreException {
        if (resource == null || !this.applies(resource.getProject())) {
            return false;
        }
        return IBuildSupport.super.fileChanged(resource, changeType, monitor) || this.isBuildFile(resource);
    }

    @Override
    public void discoverSource(IClassFile classFile, IProgressMonitor monitor) throws CoreException {
        if (classFile == null) {
            return;
        }
        IClassFile element = classFile;
        while (element.getParent() != null) {
            if (!((element = element.getParent()) instanceof IPackageFragmentRoot)) continue;
            IPackageFragmentRoot fragment = (IPackageFragmentRoot)element;
            IPath attachmentPath = fragment.getSourceAttachmentPath();
            if (attachmentPath != null && !attachmentPath.isEmpty() && attachmentPath.toFile().exists()) break;
            if (!fragment.isArchive()) continue;
            IPath path = fragment.getPath();
            Boolean downloaded = (Boolean)downloadRequestsCache.getIfPresent((Object)path.toString());
            if (downloaded != null) break;
            downloadRequestsCache.put((Object)path.toString(), (Object)true);
            IClasspathManager buildpathManager = MavenJdtPlugin.getDefault().getBuildpathManager();
            buildpathManager.scheduleDownload(fragment, true, true);
            JobHelpers.waitForDownloadSourcesJobs(3000);
            break;
        }
    }
}

