/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FormatterManager {
    public static final String ENCODING = "UTF-8";
    protected static final String VERSION_KEY_SUFFIX = ".version";
    public static final String CODE_FORMATTER_PROFILE_KIND = "CodeFormatterProfile";
    private static final String FORMATTER_OPTION_PREFIX = "org.eclipse.jdt.core.formatter";
    private static final String XML_NODE_ROOT = "profiles";
    private static final String XML_NODE_PROFILE = "profile";
    private static final String XML_NODE_SETTING = "setting";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private static final String XML_ATTRIBUTE_PROFILE_KIND = "kind";
    private static final String XML_ATTRIBUTE_VALUE = "value";

    public Map<String, String> readSettingsFromFile(File file, String profileName) throws CoreException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream reader = new FileInputStream(file);){
                return FormatterManager.readSettingsFromStream(new InputSource(reader), profileName);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.jdt.ls.core", e.getMessage(), (Throwable)e));
        }
    }

    public static Map<String, String> readSettingsFromStream(InputSource inputSource, String profileName) throws CoreException {
        ProfileDefaultHandler handler = new ProfileDefaultHandler(profileName);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.jdt.ls.core", e.getMessage(), (Throwable)e));
        }
        return handler.getSettings();
    }

    public static void configureFormatter(PreferenceManager preferenceManager, ProjectsManager projectsManager) {
        String formatterUrl = preferenceManager.getPreferences().getFormatterUrl();
        Map<String, String> options = null;
        if (formatterUrl != null) {
            URL url = projectsManager.getUrl(formatterUrl);
            if (url != null) {
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (InputStream inputStream = url.openStream();){
                        InputSource inputSource = new InputSource(inputStream);
                        String profileName = preferenceManager.getPreferences().getFormatterProfileName();
                        options = FormatterManager.readSettingsFromStream(inputSource, profileName);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
            } else {
                JavaLanguageServerPlugin.logInfo("Invalid formatter:" + formatterUrl);
            }
        }
        if (options != null && !options.isEmpty()) {
            FormatterManager.setFormattingOptions(options);
        } else {
            Map defaultOptions = DefaultCodeFormatterOptions.getEclipseDefaultSettings().getMap();
            Hashtable javaOptions = JavaCore.getOptions();
            defaultOptions.forEach((k, v) -> javaOptions.put(k, v));
            JavaCore.setOptions((Hashtable)javaOptions);
            JavaLanguageServerPlugin.getPreferencesManager();
            PreferenceManager.initialize();
        }
    }

    private static void setFormattingOptions(Map<String, String> options) {
        Map defaultOptions = DefaultCodeFormatterOptions.getEclipseDefaultSettings().getMap();
        defaultOptions.putAll(options);
        Hashtable javaOptions = JavaCore.getOptions();
        defaultOptions.entrySet().stream().filter(p -> ((String)p.getKey()).startsWith(FORMATTER_OPTION_PREFIX)).forEach(p -> javaOptions.put((String)p.getKey(), (String)p.getValue()));
        JavaCore.setOptions((Hashtable)javaOptions);
    }

    private static final class ProfileDefaultHandler
    extends DefaultHandler {
        private String profileName;
        private String fName;
        private Map<String, String> fSettings;
        private String fKind;
        private boolean reading = false;

        private ProfileDefaultHandler(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(FormatterManager.XML_NODE_SETTING)) {
                if (this.reading) {
                    String key = attributes.getValue(FormatterManager.XML_ATTRIBUTE_ID);
                    String value = attributes.getValue(FormatterManager.XML_ATTRIBUTE_VALUE);
                    this.fSettings.put(key, value);
                }
            } else if (qName.equals(FormatterManager.XML_NODE_PROFILE)) {
                this.fName = attributes.getValue(FormatterManager.XML_ATTRIBUTE_NAME);
                if (this.profileName == null || this.profileName.equals(this.fName)) {
                    this.reading = true;
                    this.fKind = attributes.getValue(FormatterManager.XML_ATTRIBUTE_PROFILE_KIND);
                    if (this.fKind == null) {
                        this.fKind = FormatterManager.CODE_FORMATTER_PROFILE_KIND;
                    }
                    this.fSettings = new HashMap<String, String>(200);
                }
            } else {
                qName.equals(FormatterManager.XML_NODE_ROOT);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (qName.equals(FormatterManager.XML_NODE_PROFILE) && this.reading) {
                this.reading = false;
            }
        }

        private Map<String, String> getSettings() {
            return this.fSettings;
        }
    }
}

