/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.ls.core.internal.javadoc.html.SingleCharReader;

public class JavaDocCommentReader
extends SingleCharReader {
    private IBuffer fBuffer;
    private String fSource;
    private int fCurrPos;
    private int fStartPos;
    private int fEndPos;
    private boolean fWasNewLine;

    public JavaDocCommentReader(IBuffer buf, int start, int end) {
        this.fBuffer = buf;
        this.fStartPos = start + 3;
        this.fEndPos = end - 2;
        this.reset();
    }

    public JavaDocCommentReader(String source, int start, int end) {
        this.fSource = source;
        this.fStartPos = start + 3;
        this.fEndPos = end - 2;
        this.reset();
    }

    @Override
    public int read() {
        if (this.fCurrPos < this.fEndPos) {
            char ch = this.getChar(this.fCurrPos++);
            if (this.fWasNewLine && !IndentManipulation.isLineDelimiterChar((char)ch)) {
                while (this.fCurrPos < this.fEndPos && Character.isWhitespace(ch)) {
                    ch = this.getChar(this.fCurrPos++);
                }
                if (ch == '*') {
                    if (this.fCurrPos < this.fEndPos) {
                        while ((ch = this.getChar(this.fCurrPos++)) == '*') {
                        }
                    } else {
                        return -1;
                    }
                }
            }
            this.fWasNewLine = IndentManipulation.isLineDelimiterChar((char)ch);
            return ch;
        }
        return -1;
    }

    @Override
    public void close() {
        this.fSource = null;
        this.fBuffer = null;
    }

    @Override
    public void reset() {
        this.fCurrPos = this.fStartPos;
        this.fWasNewLine = true;
        if (this.fCurrPos < this.fEndPos && '\r' == this.getChar(this.fCurrPos)) {
            ++this.fCurrPos;
        }
        if (this.fCurrPos < this.fEndPos && '\n' == this.getChar(this.fCurrPos)) {
            ++this.fCurrPos;
        }
    }

    private char getChar(int pos) {
        if (this.fBuffer != null) {
            return this.fBuffer.getChar(this.fCurrPos);
        }
        return this.fSource.charAt(pos);
    }

    public int getOffset() {
        return this.fCurrPos;
    }
}

