/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.highlighting;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightingsCore;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticToken;
import org.eclipse.jdt.ls.core.internal.highlighting.SemanticHighlightingLS;

public class SemanticHighlightings
extends SemanticHighlightingsCore {
    private static final ImmutableListMultimap.Builder<String, String> SCOPES_BUILDER = ImmutableListMultimap.builder();
    public static final String STATIC_FINAL_FIELD = "staticFinalField";
    public static final String STATIC_FIELD = "staticField";
    public static final String FIELD = "field";
    public static final String METHOD_DECLARATION = "methodDeclarationName";
    public static final String STATIC_METHOD_INVOCATION = "staticMethodInvocation";
    public static final String INHERITED_METHOD_INVOCATION = "inheritedMethodInvocation";
    public static final String ANNOTATION_ELEMENT_REFERENCE = "annotationElementReference";
    public static final String ABSTRACT_METHOD_INVOCATION = "abstractMethodInvocation";
    public static final String LOCAL_VARIABLE_DECLARATION = "localVariableDeclaration";
    public static final String LOCAL_VARIABLE = "localVariable";
    public static final String PARAMETER_VARIABLE = "parameterVariable";
    public static final String DEPRECATED_MEMBER = "deprecatedMember";
    public static final String TYPE_VARIABLE = "typeParameter";
    public static final String METHOD = "method";
    public static final String AUTOBOXING = "autoboxing";
    public static final String CLASS = "class";
    public static final String ENUM = "enum";
    public static final String INTERFACE = "interface";
    public static final String ANNOTATION = "annotation";
    public static final String TYPE_ARGUMENT = "typeArgument";
    public static final String NUMBER = "number";
    public static final String ABSTRACT_CLASS = "abstractClass";
    public static final String INHERITED_FIELD = "inheritedField";
    public static final String VAR_KEYWORD = "varKeyword";
    private static final ListMultimap<String, String> SCOPES;
    private static SemanticHighlightingLS[] fgSemanticHighlightings;

    static {
        SCOPES_BUILDER.putAll((Object)STATIC_FINAL_FIELD, (Object[])new String[]{"storage.modifier.static.java", "storage.modifier.final.java", "variable.other.definition.java", "meta.definition.variable.java", "meta.class.body.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)STATIC_FIELD, (Object[])new String[]{"storage.modifier.static.java", "variable.other.definition.java", "meta.definition.variable.java", "meta.class.body.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)FIELD, (Object[])new String[]{"meta.definition.variable.java", "meta.class.body.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)METHOD_DECLARATION, (Object[])new String[]{"entity.name.function.java", "meta.method.identifier.java", "meta.method.java", "meta.class.body.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)STATIC_METHOD_INVOCATION, (Object[])new String[]{"storage.modifier.static.java", "entity.name.function.java", "meta.function-call.java", "meta.method.body.java", "meta.method.java", "meta.class.body.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)INHERITED_METHOD_INVOCATION, (Object[])new String[]{"entity.name.function.java", "meta.function-call.java", "meta.method.body.java", "meta.method.java", "meta.class.body.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)ANNOTATION_ELEMENT_REFERENCE, (Object[])new String[]{"constant.other.key.java", "meta.declaration.annotation.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)ABSTRACT_METHOD_INVOCATION, (Object[])new String[]{"storage.modifier.abstract.java", "entity.name.function.java", "meta.function-call.java", "meta.method.body.java", "meta.method.java", "meta.class.body.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)LOCAL_VARIABLE_DECLARATION, (Object[])new String[]{"variable.other.definition.java", "meta.definition.variable.java", "meta.method.body.java", "meta.method.java", "meta.class.body.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)LOCAL_VARIABLE, (Object[])new String[]{"meta.method.body.java", "meta.method.java", "meta.class.body.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)PARAMETER_VARIABLE, (Object[])new String[]{"variable.parameter.java", "meta.method.identifier.java", "meta.method.java", "meta.class.body.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)DEPRECATED_MEMBER, (Object[])new String[]{"invalid.deprecated.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)TYPE_VARIABLE, (Object[])new String[]{"storage.type.generic.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)METHOD, (Object[])new String[]{"entity.name.function.java", "meta.method.identifier.java", "meta.function-call.java", "meta.method.java", "meta.class.body.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)AUTOBOXING, (Object[])new String[]{"variable.other.autoboxing.java", "meta.method.body.java", "meta.method.java", "meta.class.body.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)CLASS, (Object[])new String[]{"entity.name.type.class.java", "meta.class.identifier.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)ENUM, (Object[])new String[]{"entity.name.type.enum.java", "meta.enum.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)INTERFACE, (Object[])new String[]{"entity.name.type.interface.java", "meta.class.identifier.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)ANNOTATION, (Object[])new String[]{"storage.type.annotation.java", "meta.declaration.annotation.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)TYPE_ARGUMENT, (Object[])new String[]{"storage.type.generic.java", "meta.definition.class.implemented.interfaces.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)NUMBER, (Object[])new String[]{"constant.numeric.decimal.java", "meta.definition.variable.java", "meta.method.body.java", "meta.method.java", "meta.class.body.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)ABSTRACT_CLASS, (Object[])new String[]{"storage.modifier.abstract.java", "entity.name.type.class.java", "meta.class.identifier.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)INHERITED_FIELD, (Object[])new String[]{"meta.function-call.java", "meta.method.body.java", "meta.method.java", "meta.class.body.java", "meta.class.java", "source.java"});
        SCOPES_BUILDER.putAll((Object)VAR_KEYWORD, (Object[])new String[]{"keyword.other.var.java", "meta.class.body.java", "meta.class.java", "source.java"});
        SCOPES = SCOPES_BUILDER.build();
    }

    public static SemanticHighlightingLS[] getSemanticHighlightings() {
        if (fgSemanticHighlightings == null) {
            fgSemanticHighlightings = new SemanticHighlightingLS[]{new DeprecatedMemberHighlighting(), new AutoboxHighlighting(), new StaticFinalFieldHighlighting(), new StaticFieldHighlighting(), new InheritedFieldHighlighting(), new FieldHighlighting(), new MethodDeclarationHighlighting(), new StaticMethodInvocationHighlighting(), new AbstractMethodInvocationHighlighting(), new AnnotationElementReferenceHighlighting(), new InheritedMethodInvocationHighlighting(), new ParameterVariableHighlighting(), new LocalVariableDeclarationHighlighting(), new LocalVariableHighlighting(), new TypeVariableHighlighting(), new MethodHighlighting(), new TypeArgumentHighlighting(), new AbstractClassHighlighting(), new ClassHighlighting(), new EnumHighlighting(), new AnnotationHighlighting(), new InterfaceHighlighting(), new NumberHighlighting(), new VarKeywordHighlighting()};
        }
        return fgSemanticHighlightings;
    }

    private static IBinding getBinding(SemanticToken token) {
        SimpleName node = token.getNode();
        ASTNode normalized = ASTNodes.getNormalizedNode((ASTNode)node);
        if (normalized.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY) {
            return ((ClassInstanceCreation)normalized.getParent()).resolveConstructorBinding();
        }
        return token.getBinding();
    }

    private SemanticHighlightings() {
    }

    private static final class AbstractClassHighlighting
    extends SemanticHighlightingLS {
        private AbstractClassHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.ABSTRACT_CLASS);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean consumes(SemanticToken token) {
            name = token.getNode();
            node = name.getParent();
            nodeType = node.getNodeType();
            if (nodeType == 43 || nodeType == 52 || nodeType == 75 || nodeType == 40 || nodeType == 55 || nodeType == 32) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                nodeType = (node = node.getParent()).getNodeType();
                if (nodeType != 26) continue;
                return false;
lbl9:
                // 2 sources

                ** while (nodeType == 40)
            }
lbl10:
            // 1 sources

            binding = token.getBinding();
            if (binding instanceof ITypeBinding) {
                typeBinding = (ITypeBinding)binding;
                return typeBinding.isClass() != false && (typeBinding.getModifiers() & 1024) != 0;
            }
            return false;
        }
    }

    private static final class AbstractMethodInvocationHighlighting
    extends SemanticHighlightingLS {
        private AbstractMethodInvocationHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.ABSTRACT_METHOD_INVOCATION);
        }

        @Override
        public boolean consumes(SemanticToken token) {
            ITypeBinding declaringType;
            boolean isAbstractMethod;
            SimpleName node = token.getNode();
            if (node.isDeclaration()) {
                return false;
            }
            IBinding binding = token.getBinding();
            boolean bl = isAbstractMethod = binding != null && binding.getKind() == 4 && (binding.getModifiers() & 0x400) == 1024;
            if (!isAbstractMethod) {
                return false;
            }
            return binding == null || !(declaringType = ((IMethodBinding)binding).getDeclaringClass()).isAnnotation();
        }
    }

    private static final class AnnotationElementReferenceHighlighting
    extends SemanticHighlightingLS {
        private AnnotationElementReferenceHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.ANNOTATION_ELEMENT_REFERENCE);
        }

        @Override
        public boolean consumes(SemanticToken token) {
            SimpleName node = token.getNode();
            if (node.getParent() instanceof MemberValuePair) {
                IBinding binding = token.getBinding();
                boolean isAnnotationElement = binding != null && binding.getKind() == 4;
                return isAnnotationElement;
            }
            return false;
        }
    }

    private static final class AnnotationHighlighting
    extends SemanticHighlightingLS {
        private AnnotationHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.ANNOTATION);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean consumes(SemanticToken token) {
            name = token.getNode();
            node = name.getParent();
            nodeType = node.getNodeType();
            if (nodeType == 43 || nodeType == 75 || nodeType == 40 || nodeType == 81 || nodeType == 78 || nodeType == 77 || nodeType == 79) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                nodeType = (node = node.getParent()).getNodeType();
                if (nodeType != 26) continue;
                return false;
lbl9:
                // 2 sources

                ** while (nodeType == 40)
            }
lbl10:
            // 1 sources

            binding = token.getBinding();
            return binding instanceof ITypeBinding != false && ((ITypeBinding)binding).isAnnotation() != false;
        }
    }

    private static final class AutoboxHighlighting
    extends SemanticHighlightingLS {
        private AutoboxHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.AUTOBOXING);
        }

        public boolean consumesLiteral(SemanticToken token) {
            return this.isAutoUnBoxing(token.getLiteral());
        }

        @Override
        public boolean consumes(SemanticToken token) {
            return this.isAutoUnBoxing((Expression)token.getNode());
        }

        private boolean isAutoUnBoxing(Expression node) {
            ASTNode parent;
            if (this.isAutoUnBoxingExpression(node)) {
                return true;
            }
            StructuralPropertyDescriptor desc = node.getLocationInParent();
            if ((desc == ArrayAccess.ARRAY_PROPERTY || desc == InfixExpression.LEFT_OPERAND_PROPERTY || desc == InfixExpression.RIGHT_OPERAND_PROPERTY || desc == ConditionalExpression.THEN_EXPRESSION_PROPERTY || desc == PrefixExpression.OPERAND_PROPERTY || desc == CastExpression.EXPRESSION_PROPERTY || desc == ConditionalExpression.ELSE_EXPRESSION_PROPERTY) && (parent = node.getParent()) instanceof Expression) {
                return this.isAutoUnBoxingExpression((Expression)parent);
            }
            if (desc == QualifiedName.NAME_PROPERTY) {
                node = (Expression)node.getParent();
                desc = node.getLocationInParent();
            }
            if ((desc == SimpleType.NAME_PROPERTY || desc == NameQualifiedType.NAME_PROPERTY) && (parent = node.getParent()) != null && parent.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY) {
                parent = parent.getParent();
                return this.isAutoUnBoxingExpression((Expression)((ClassInstanceCreation)parent));
            }
            return false;
        }

        private boolean isAutoUnBoxingExpression(Expression expression) {
            return expression.resolveBoxing() || expression.resolveUnboxing();
        }
    }

    private static final class ClassHighlighting
    extends SemanticHighlightingLS {
        private ClassHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.CLASS);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean consumes(SemanticToken token) {
            name = token.getNode();
            node = name.getParent();
            nodeType = node.getNodeType();
            if (nodeType == 43 || nodeType == 52 || nodeType == 75 || nodeType == 40 || nodeType == 55 || nodeType == 32) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                nodeType = (node = node.getParent()).getNodeType();
                if (nodeType != 26) continue;
                return false;
lbl9:
                // 2 sources

                ** while (nodeType == 40)
            }
lbl10:
            // 1 sources

            binding = token.getBinding();
            return binding instanceof ITypeBinding != false && ((ITypeBinding)binding).isClass() != false;
        }
    }

    static final class DeprecatedMemberHighlighting
    extends SemanticHighlightingLS {
        DeprecatedMemberHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.DEPRECATED_MEMBER);
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = SemanticHighlightings.getBinding(token);
            if (binding != null) {
                if (binding.isDeprecated()) {
                    return true;
                }
                if (binding instanceof IMethodBinding) {
                    IMethodBinding methodBinding = (IMethodBinding)binding;
                    ITypeBinding declaringClass = methodBinding.getDeclaringClass();
                    if (declaringClass == null) {
                        return false;
                    }
                    if (declaringClass.isAnonymous()) {
                        ITypeBinding[] interfaces = declaringClass.getInterfaces();
                        if (interfaces.length > 0) {
                            return interfaces[0].isDeprecated();
                        }
                        return declaringClass.getSuperclass().isDeprecated();
                    }
                    return declaringClass.isDeprecated() && !(token.getNode().getParent() instanceof MethodDeclaration);
                }
                if (binding instanceof IVariableBinding) {
                    IVariableBinding variableBinding = (IVariableBinding)binding;
                    ITypeBinding declaringClass = variableBinding.getDeclaringClass();
                    return declaringClass != null && declaringClass.isDeprecated() && !(token.getNode().getParent() instanceof VariableDeclaration);
                }
            }
            return false;
        }
    }

    private static final class EnumHighlighting
    extends SemanticHighlightingLS {
        private EnumHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.ENUM);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean consumes(SemanticToken token) {
            name = token.getNode();
            node = name.getParent();
            nodeType = node.getNodeType();
            if (nodeType == 32 || nodeType == 43 || nodeType == 75 || nodeType == 40 || nodeType == 40 || nodeType == 71) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                nodeType = (node = node.getParent()).getNodeType();
                if (nodeType != 26) continue;
                return false;
lbl9:
                // 2 sources

                ** while (nodeType == 40)
            }
lbl10:
            // 1 sources

            binding = token.getBinding();
            return binding instanceof ITypeBinding != false && ((ITypeBinding)binding).isEnum() != false;
        }
    }

    private static final class FieldHighlighting
    extends SemanticHighlightingLS {
        private FieldHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.FIELD);
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding != null && binding.getKind() == 3 && ((IVariableBinding)binding).isField();
        }
    }

    private static final class InheritedFieldHighlighting
    extends SemanticHighlightingLS {
        private InheritedFieldHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.INHERITED_FIELD);
        }

        @Override
        public boolean consumes(SemanticToken token) {
            SimpleName node = token.getNode();
            if (node.isDeclaration()) {
                return false;
            }
            IBinding binding = token.getBinding();
            if (binding == null || binding.getKind() != 3) {
                return false;
            }
            ITypeBinding currentType = Bindings.getBindingOfParentType((ASTNode)node);
            ITypeBinding declaringType = ((IVariableBinding)binding).getDeclaringClass();
            if (declaringType == null || currentType == declaringType) {
                return false;
            }
            return Bindings.isSuperType((ITypeBinding)declaringType, (ITypeBinding)currentType);
        }
    }

    private static final class InheritedMethodInvocationHighlighting
    extends SemanticHighlightingLS {
        private InheritedMethodInvocationHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.INHERITED_METHOD_INVOCATION);
        }

        @Override
        public boolean consumes(SemanticToken token) {
            ITypeBinding declaringType;
            SimpleName node = token.getNode();
            if (node.isDeclaration()) {
                return false;
            }
            IBinding binding = token.getBinding();
            if (binding == null || binding.getKind() != 4) {
                return false;
            }
            ITypeBinding currentType = Bindings.getBindingOfParentType((ASTNode)node);
            if (currentType == (declaringType = ((IMethodBinding)binding).getDeclaringClass()) || currentType == null) {
                return false;
            }
            return Bindings.isSuperType((ITypeBinding)declaringType, (ITypeBinding)currentType);
        }
    }

    private static final class InterfaceHighlighting
    extends SemanticHighlightingLS {
        private InterfaceHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.INTERFACE);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean consumes(SemanticToken token) {
            name = token.getNode();
            node = name.getParent();
            nodeType = node.getNodeType();
            if (nodeType == 43 || nodeType == 75 || nodeType == 40 || nodeType == 55) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                nodeType = (node = node.getParent()).getNodeType();
                if (nodeType != 26) continue;
                return false;
lbl9:
                // 2 sources

                ** while (nodeType == 40)
            }
lbl10:
            // 1 sources

            binding = token.getBinding();
            return binding instanceof ITypeBinding != false && ((ITypeBinding)binding).isInterface() != false;
        }
    }

    private static final class LocalVariableDeclarationHighlighting
    extends SemanticHighlightingLS {
        private LocalVariableDeclarationHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.LOCAL_VARIABLE_DECLARATION);
        }

        @Override
        public boolean consumes(SemanticToken token) {
            ASTNode parent;
            SimpleName node = token.getNode();
            StructuralPropertyDescriptor location = node.getLocationInParent();
            if ((location == VariableDeclarationFragment.NAME_PROPERTY || location == SingleVariableDeclaration.NAME_PROPERTY) && (parent = node.getParent()) instanceof VariableDeclaration) {
                return (parent = parent.getParent()) == null || !(parent instanceof FieldDeclaration);
            }
            return false;
        }
    }

    private static final class LocalVariableHighlighting
    extends SemanticHighlightingLS {
        private LocalVariableHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.LOCAL_VARIABLE);
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            if (binding != null && binding.getKind() == 3 && !((IVariableBinding)binding).isField()) {
                ASTNode decl = token.getRoot().findDeclaringNode(binding);
                return decl instanceof VariableDeclaration;
            }
            return false;
        }
    }

    private static final class MethodDeclarationHighlighting
    extends SemanticHighlightingLS {
        private MethodDeclarationHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.METHOD_DECLARATION);
        }

        @Override
        public boolean consumes(SemanticToken token) {
            StructuralPropertyDescriptor location = token.getNode().getLocationInParent();
            return location == MethodDeclaration.NAME_PROPERTY || location == AnnotationTypeMemberDeclaration.NAME_PROPERTY;
        }
    }

    private static final class MethodHighlighting
    extends SemanticHighlightingLS {
        private MethodHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.METHOD);
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = SemanticHighlightings.getBinding(token);
            return binding != null && binding.getKind() == 4;
        }
    }

    private static final class NumberHighlighting
    extends SemanticHighlightingLS {
        private NumberHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.NUMBER);
        }

        @Override
        public boolean consumes(SemanticToken token) {
            return false;
        }

        public boolean consumesLiteral(SemanticToken token) {
            Expression expr = token.getLiteral();
            return expr != null && expr.getNodeType() == 34;
        }
    }

    private static final class ParameterVariableHighlighting
    extends SemanticHighlightingLS {
        private ParameterVariableHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.PARAMETER_VARIABLE);
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            if (binding != null && binding.getKind() == 3 && !((IVariableBinding)binding).isField()) {
                ASTNode decl = token.getRoot().findDeclaringNode(binding);
                return decl != null && decl.getLocationInParent() == MethodDeclaration.PARAMETERS_PROPERTY;
            }
            return false;
        }
    }

    private static final class StaticFieldHighlighting
    extends SemanticHighlightingLS {
        private StaticFieldHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.STATIC_FIELD);
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding != null && binding.getKind() == 3 && ((IVariableBinding)binding).isField() && (binding.getModifiers() & 8) == 8;
        }
    }

    private static final class StaticFinalFieldHighlighting
    extends SemanticHighlightingLS {
        private StaticFinalFieldHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.STATIC_FINAL_FIELD);
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding != null && binding.getKind() == 3 && ((IVariableBinding)binding).isField() && (binding.getModifiers() & 0x18) == 24;
        }
    }

    private static final class StaticMethodInvocationHighlighting
    extends SemanticHighlightingLS {
        private StaticMethodInvocationHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.STATIC_METHOD_INVOCATION);
        }

        @Override
        public boolean consumes(SemanticToken token) {
            SimpleName node = token.getNode();
            if (node.isDeclaration()) {
                return false;
            }
            IBinding binding = token.getBinding();
            return binding != null && binding.getKind() == 4 && (binding.getModifiers() & 8) == 8;
        }
    }

    private static final class TypeArgumentHighlighting
    extends SemanticHighlightingLS {
        private TypeArgumentHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.TYPE_ARGUMENT);
        }

        @Override
        public boolean consumes(SemanticToken token) {
            SimpleName name = token.getNode();
            ASTNode node = name.getParent();
            int nodeType = node.getNodeType();
            if (nodeType != 43 && nodeType != 75) {
                return false;
            }
            StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
            return locationInParent == ParameterizedType.TYPE_ARGUMENTS_PROPERTY;
        }
    }

    private static final class TypeVariableHighlighting
    extends SemanticHighlightingLS {
        private TypeVariableHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.TYPE_VARIABLE);
        }

        @Override
        public boolean consumes(SemanticToken token) {
            SimpleName name = token.getNode();
            ASTNode node = name.getParent();
            if (node.getNodeType() != 43 && node.getNodeType() != 73) {
                return false;
            }
            IBinding binding = token.getBinding();
            return binding instanceof ITypeBinding && ((ITypeBinding)binding).isTypeVariable();
        }
    }

    static final class VarKeywordHighlighting
    extends SemanticHighlightingLS {
        VarKeywordHighlighting() {
        }

        @Override
        public List<String> getScopes() {
            return SCOPES.get((Object)SemanticHighlightings.VAR_KEYWORD);
        }

        @Override
        public boolean consumes(SemanticToken token) {
            return false;
        }
    }
}

