/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.highlighting;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.internal.ui.javaeditor.HighlightedPositionCore;
import org.eclipse.jdt.internal.ui.javaeditor.PositionCollectorCore;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightingCore;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightingPresenterCore;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticToken;
import org.eclipse.jdt.ls.core.internal.highlighting.SemanticHighlightingLS;
import org.eclipse.jdt.ls.core.internal.highlighting.SemanticHighlightings;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class SemanticHighlightingReconciler {
    private PositionCollector fCollector = new PositionCollector();
    private SemanticHighlightingPresenterCore fPresenter = new SemanticHighlightingPresenterCore();
    private SemanticHighlightingCore[] fSemanticHighlightings = SemanticHighlightings.getSemanticHighlightings();
    private List<List<String>> fHighlightings = FluentIterable.from(Arrays.asList(this.fSemanticHighlightings)).transform(highlighting -> ImmutableList.copyOf(((SemanticHighlightingLS)((Object)highlighting)).getScopes())).toList();
    private List<Position> fAddedPositions = new ArrayList<Position>();
    private List<Position> fRemovedPositions = new ArrayList<Position>();
    private int fNOfRemovedPositions;
    private final Object fReconcileLock = new Object();
    private boolean fIsReconciling = false;
    private SemanticHighlightingPresenterCore fJobPresenter = new SemanticHighlightingPresenterCore();
    private SemanticHighlightingCore[] fJobSemanticHighlightings;
    private List<List<String>> fJobHighlightings;
    private List<String> fJobDeprecatedMemberHighlighting;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HighlightedPositionCore> reconciled(IDocument document, ASTNode ast, boolean forced, IProgressMonitor progressMonitor) throws BadPositionCategoryException {
        Object object;
        ImmutableList immutableList;
        ASTNode[] subtrees;
        block26: {
            block25: {
                Object object2 = this.fReconcileLock;
                synchronized (object2) {
                    if (this.fIsReconciling) {
                        return Collections.emptyList();
                    }
                    this.fIsReconciling = true;
                }
                this.fJobPresenter = this.fPresenter;
                this.fJobSemanticHighlightings = this.fSemanticHighlightings;
                this.fJobHighlightings = this.fHighlightings;
                if (ast != null) break block25;
                List<HighlightedPositionCore> list = Collections.emptyList();
                this.fJobPresenter = null;
                this.fJobSemanticHighlightings = null;
                this.fJobHighlightings = null;
                this.fJobDeprecatedMemberHighlighting = null;
                Object object3 = this.fReconcileLock;
                synchronized (object3) {
                    this.fIsReconciling = false;
                }
                return list;
            }
            subtrees = this.getAffectedSubtrees(ast);
            if (subtrees.length != 0) break block26;
            List<HighlightedPositionCore> list = Collections.emptyList();
            this.fJobPresenter = null;
            this.fJobSemanticHighlightings = null;
            this.fJobHighlightings = null;
            this.fJobDeprecatedMemberHighlighting = null;
            Object object4 = this.fReconcileLock;
            synchronized (object4) {
                this.fIsReconciling = false;
            }
            return list;
        }
        try {
            Position[] positions;
            this.startReconcilingPositions();
            if (!this.fJobPresenter.isCanceled()) {
                this.fJobDeprecatedMemberHighlighting = null;
                int i = 0;
                int n = this.fJobSemanticHighlightings.length;
                while (i < n) {
                    SemanticHighlightingCore semanticHighlighting = this.fJobSemanticHighlightings[i];
                    if (semanticHighlighting instanceof SemanticHighlightings.DeprecatedMemberHighlighting) {
                        this.fJobDeprecatedMemberHighlighting = this.fJobHighlightings.get(i);
                        break;
                    }
                    ++i;
                }
                this.reconcilePositions(subtrees);
            }
            if (!document.containsPositionCategory(this.fPresenter.getPositionCategory())) {
                document.addPositionCategory(this.fPresenter.getPositionCategory());
            }
            this.updatePresentation(document, this.fAddedPositions, this.fRemovedPositions);
            this.stopReconcilingPositions();
            Position[] positionArray = positions = document.getPositions(this.fPresenter.getPositionCategory());
            int n = positions.length;
            int n2 = 0;
            while (n2 < n) {
                Position position = positionArray[n2];
                Preconditions.checkState((boolean)(position instanceof HighlightedPositionCore));
                ++n2;
            }
            immutableList = FluentIterable.from(Arrays.asList(positions)).filter(HighlightedPositionCore.class).toList();
            this.fJobPresenter = null;
            this.fJobSemanticHighlightings = null;
            this.fJobHighlightings = null;
            this.fJobDeprecatedMemberHighlighting = null;
            object = this.fReconcileLock;
        }
        catch (Throwable throwable) {
            this.fJobPresenter = null;
            this.fJobSemanticHighlightings = null;
            this.fJobHighlightings = null;
            this.fJobDeprecatedMemberHighlighting = null;
            Object object5 = this.fReconcileLock;
            synchronized (object5) {
                this.fIsReconciling = false;
            }
            throw throwable;
        }
        synchronized (object) {
            this.fIsReconciling = false;
        }
        return immutableList;
    }

    private ASTNode[] getAffectedSubtrees(ASTNode node) {
        return new ASTNode[]{node};
    }

    private void startReconcilingPositions() {
        this.fJobPresenter.addAllPositions(this.fRemovedPositions);
        this.fNOfRemovedPositions = this.fRemovedPositions.size();
    }

    private void reconcilePositions(ASTNode[] subtrees) {
        int i = 0;
        int n = subtrees.length;
        while (i < n) {
            subtrees[i].accept((ASTVisitor)this.fCollector);
            ++i;
        }
        List<Position> oldPositions = this.fRemovedPositions;
        ArrayList<Position> newPositions = new ArrayList<Position>(this.fNOfRemovedPositions);
        int i2 = 0;
        int n2 = oldPositions.size();
        while (i2 < n2) {
            Position current = oldPositions.get(i2);
            if (current != null) {
                newPositions.add(current);
            }
            ++i2;
        }
        this.fRemovedPositions = newPositions;
    }

    private void updatePresentation(IDocument document, List<Position> addedPositions, List<Position> removedPositions) {
        Runnable r = this.fJobPresenter.createUpdateRunnableCore(document, addedPositions, removedPositions);
        r.run();
    }

    private void stopReconcilingPositions() {
        this.fRemovedPositions.clear();
        this.fNOfRemovedPositions = 0;
        this.fAddedPositions.clear();
    }

    private class PositionCollector
    extends PositionCollectorCore {
        private SemanticToken fToken = new SemanticToken();

        private PositionCollector() {
        }

        protected boolean visitLiteral(Expression node) {
            this.fToken.update(node);
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fJobSemanticHighlightings.length;
            while (i < n) {
                SemanticHighlightingCore semanticHighlighting = SemanticHighlightingReconciler.this.fJobSemanticHighlightings[i];
                if (semanticHighlighting.consumesLiteral(this.fToken)) {
                    int offset = node.getStartPosition();
                    int length = node.getLength();
                    if (offset <= -1 || length <= 0) break;
                    this.addPosition(offset, length, (List)SemanticHighlightingReconciler.this.fJobHighlightings.get(i));
                    break;
                }
                ++i;
            }
            this.fToken.clear();
            return false;
        }

        public boolean visit(ConstructorInvocation node) {
            IMethodBinding constructorBinding;
            if (SemanticHighlightingReconciler.this.fJobDeprecatedMemberHighlighting != null && (constructorBinding = node.resolveConstructorBinding()) != null && constructorBinding.isDeprecated()) {
                int offset = node.getStartPosition();
                int length = 4;
                if (offset > -1 && length > 0) {
                    this.addPosition(offset, length, SemanticHighlightingReconciler.this.fJobDeprecatedMemberHighlighting);
                }
            }
            return true;
        }

        public boolean visit(SuperConstructorInvocation node) {
            IMethodBinding constructorBinding;
            if (SemanticHighlightingReconciler.this.fJobDeprecatedMemberHighlighting != null && (constructorBinding = node.resolveConstructorBinding()) != null && constructorBinding.isDeprecated()) {
                int offset = node.getStartPosition();
                int length = 5;
                if (offset > -1 && length > 0) {
                    this.addPosition(offset, length, SemanticHighlightingReconciler.this.fJobDeprecatedMemberHighlighting);
                }
            }
            return true;
        }

        public boolean visit(SimpleType node) {
            if (node.getAST().apiLevel() >= 10 && node.isVar()) {
                int offset = node.getStartPosition();
                int length = node.getLength();
                if (offset > -1 && length > 0) {
                    int i = 0;
                    while (i < SemanticHighlightingReconciler.this.fJobSemanticHighlightings.length) {
                        SemanticHighlightingCore semanticHighlighting = SemanticHighlightingReconciler.this.fJobSemanticHighlightings[i];
                        if (semanticHighlighting instanceof SemanticHighlightings.VarKeywordHighlighting) {
                            this.addPosition(offset, length, (List)SemanticHighlightingReconciler.this.fJobHighlightings.get(i));
                            return false;
                        }
                        ++i;
                    }
                }
            }
            return true;
        }

        public boolean visit(SimpleName node) {
            this.fToken.update(node);
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fJobSemanticHighlightings.length;
            while (i < n) {
                SemanticHighlightingCore semanticHighlighting = SemanticHighlightingReconciler.this.fJobSemanticHighlightings[i];
                if (semanticHighlighting.consumes(this.fToken)) {
                    int offset = node.getStartPosition();
                    int length = node.getLength();
                    if (offset <= -1 || length <= 0) break;
                    this.addPosition(offset, length, (List)SemanticHighlightingReconciler.this.fJobHighlightings.get(i));
                    break;
                }
                ++i;
            }
            this.fToken.clear();
            return false;
        }

        private void addPosition(int offset, int length, List<String> scopes) {
            boolean isExisting = false;
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fRemovedPositions.size();
            while (i < n) {
                HighlightedPositionCore position = (HighlightedPositionCore)SemanticHighlightingReconciler.this.fRemovedPositions.get(i);
                if (position != null && position.isEqual(offset, length, scopes)) {
                    isExisting = true;
                    SemanticHighlightingReconciler.this.fRemovedPositions.set(i, null);
                    SemanticHighlightingReconciler semanticHighlightingReconciler = SemanticHighlightingReconciler.this;
                    semanticHighlightingReconciler.fNOfRemovedPositions = semanticHighlightingReconciler.fNOfRemovedPositions - 1;
                    break;
                }
                ++i;
            }
            if (!isExisting) {
                HighlightedPositionCore position = SemanticHighlightingReconciler.this.fJobPresenter.createHighlightedPositionCore(offset, length, scopes);
                SemanticHighlightingReconciler.this.fAddedPositions.add(position);
            }
        }

        protected void retainPositions(int offset, int length) {
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fRemovedPositions.size();
            while (i < n) {
                HighlightedPositionCore position = (HighlightedPositionCore)SemanticHighlightingReconciler.this.fRemovedPositions.get(i);
                if (position != null && position.isContained(offset, length)) {
                    SemanticHighlightingReconciler.this.fRemovedPositions.set(i, null);
                    SemanticHighlightingReconciler semanticHighlightingReconciler = SemanticHighlightingReconciler.this;
                    semanticHighlightingReconciler.fNOfRemovedPositions = semanticHighlightingReconciler.fNOfRemovedPositions - 1;
                }
                ++i;
            }
        }
    }
}

