/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;

public class WorkspaceSymbolHandler {
    private PreferenceManager preferenceManager;

    public WorkspaceSymbolHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<SymbolInformation> search(String query, IProgressMonitor monitor) {
        if (query == null || query.trim().isEmpty()) {
            return Collections.emptyList();
        }
        try {
            final ArrayList<SymbolInformation> symbols = new ArrayList<SymbolInformation>();
            new SearchEngine().searchAllTypeNames(null, 2, query.toCharArray(), 128, 0, this.createSearchScope(), new TypeNameMatchRequestor(){

                public void acceptTypeNameMatch(TypeNameMatch match) {
                    Location location;
                    SymbolInformation symbolInformation = new SymbolInformation();
                    symbolInformation.setContainerName(match.getTypeContainerName());
                    symbolInformation.setName(match.getSimpleTypeName());
                    symbolInformation.setKind(this.mapKind(match));
                    try {
                        location = match.getType().isBinary() ? JDTUtils.toLocation((IClassFile)match.getType().getClassFile()) : JDTUtils.toLocation((IJavaElement)match.getType());
                    }
                    catch (Exception e) {
                        JavaLanguageServerPlugin.logException("Unable to determine location for " + match.getSimpleTypeName(), e);
                        return;
                    }
                    symbolInformation.setLocation(location);
                    symbols.add(symbolInformation);
                }

                private SymbolKind mapKind(TypeNameMatch match) {
                    int flags = match.getModifiers();
                    if (Flags.isInterface((int)flags)) {
                        return SymbolKind.Interface;
                    }
                    if (Flags.isAnnotation((int)flags)) {
                        return SymbolKind.Property;
                    }
                    if (Flags.isEnum((int)flags)) {
                        return SymbolKind.Enum;
                    }
                    return SymbolKind.Class;
                }
            }, 3, monitor);
            return symbols;
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException("Problem getting search for" + query, e);
            return Collections.emptyList();
        }
    }

    private IJavaSearchScope createSearchScope() throws JavaModelException {
        return JDTUtils.createSearchScope(null, this.preferenceManager);
    }
}

