/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ReferenceParams;

public final class ReferencesHandler {
    private final PreferenceManager preferenceManager;

    public ReferencesHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    private IJavaSearchScope createSearchScope() throws JavaModelException {
        IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        int scope = 1;
        if (this.preferenceManager.isClientSupportsClassFileContent()) {
            scope |= 2;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])projects, (int)scope);
    }

    public List<Location> findReferences(ReferenceParams param, IProgressMonitor monitor) {
        final ArrayList<Location> locations = new ArrayList<Location>();
        try {
            IJavaElement elementToSearch = JDTUtils.findElementAtSelection(JDTUtils.resolveTypeRoot(param.getTextDocument().getUri()), param.getPosition().getLine(), param.getPosition().getCharacter(), this.preferenceManager, monitor);
            if (elementToSearch == null) {
                return locations;
            }
            final boolean includeClassFiles = this.preferenceManager.isClientSupportsClassFileContent();
            SearchEngine engine = new SearchEngine();
            SearchPattern pattern = SearchPattern.createPattern((IJavaElement)elementToSearch, (int)2);
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.createSearchScope(), new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    Object o = match.getElement();
                    if (o instanceof IJavaElement) {
                        IClassFile cf;
                        IJavaElement element = (IJavaElement)o;
                        ICompilationUnit compilationUnit = (ICompilationUnit)element.getAncestor(5);
                        Location location = null;
                        if (compilationUnit != null) {
                            location = JDTUtils.toLocation(compilationUnit, match.getOffset(), match.getLength());
                        } else if (includeClassFiles && (cf = (IClassFile)element.getAncestor(6)) != null && cf.getSourceRange() != null) {
                            location = JDTUtils.toLocation(cf, match.getOffset(), match.getLength());
                        }
                        if (location != null) {
                            locations.add(location);
                        }
                    }
                }
            }, monitor);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Find references failure ", e);
        }
        return locations;
    }
}

