/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.core.manipulation.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.core.manipulation.search.OccurrencesFinder;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corrections.InnovationContext;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;

public class PrepareRenameHandler {
    public Either<Range, PrepareRenameResult> prepareRename(TextDocumentPositionParams params, IProgressMonitor monitor) {
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (unit != null) {
            try {
                IOccurrencesFinder.OccurrenceLocation[] occurrences;
                int offset;
                String error;
                OccurrencesFinder finder = new OccurrencesFinder();
                CompilationUnit ast = CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, monitor);
                if (ast != null && (error = finder.initialize(ast, offset = JsonRpcHelpers.toOffset(unit.getBuffer(), params.getPosition().getLine(), params.getPosition().getCharacter()), 0)) == null && (occurrences = finder.getOccurrences()) != null) {
                    IOccurrencesFinder.OccurrenceLocation[] occurrenceLocationArray = occurrences;
                    int n = occurrences.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IOccurrencesFinder.OccurrenceLocation loc = occurrenceLocationArray[n2];
                        if (monitor.isCanceled()) {
                            return Either.forLeft((Object)new Range());
                        }
                        if (loc.getOffset() <= offset && loc.getOffset() + loc.getLength() >= offset) {
                            InnovationContext context = new InnovationContext(unit, loc.getOffset(), loc.getLength());
                            context.setASTRoot(ast);
                            ASTNode node = context.getCoveredNode();
                            if (!this.isPackageDeclaration(node) && !this.isClassFile(node)) {
                                return Either.forLeft((Object)JDTUtils.toRange((IOpenable)unit, loc.getOffset(), loc.getLength()));
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Problem computing occurrences for" + unit.getElementName() + " in prepareRename", e);
            }
        }
        throw new ResponseErrorException(new ResponseError(ResponseErrorCode.InvalidRequest, "Renaming this element is not supported.", null));
    }

    private boolean isClassFile(ASTNode node) {
        ITypeBinding typeBinding;
        IBinding resolvedBinding;
        if (node instanceof Name && (resolvedBinding = ((Name)node).resolveBinding()) instanceof ITypeBinding && (typeBinding = (ITypeBinding)resolvedBinding).getJavaElement() != null) {
            IJavaElement element = typeBinding.getJavaElement();
            return element.getAncestor(6) != null;
        }
        return false;
    }

    private boolean isPackageDeclaration(ASTNode node) {
        if (node instanceof PackageDeclaration) {
            return true;
        }
        if (node instanceof Name) {
            return this.isPackageDeclaration(node.getParent());
        }
        return false;
    }
}

