/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.OrganizeImportsOperation;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.text.correction.SourceAssistProcessor;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.text.edits.TextEdit;

public final class OrganizeImportsHandler {
    public static final String CLIENT_COMMAND_ID_CHOOSEIMPORTS = "java.action.organizeImports.chooseImports";

    public static TextEdit organizeImports(ICompilationUnit unit, Function<ImportSelection[], ImportCandidate[]> chooseImports) {
        if (unit == null) {
            return null;
        }
        RefactoringASTParser astParser = new RefactoringASTParser(12);
        CompilationUnit astRoot = astParser.parse((ITypeRoot)unit, true);
        OrganizeImportsOperation op = new OrganizeImportsOperation(unit, astRoot, true, false, true, (openChoices, ranges) -> {
            ArrayList<ImportSelection> selections = new ArrayList<ImportSelection>();
            int i = 0;
            while (i < openChoices.length) {
                ImportCandidate[] candidates = (ImportCandidate[])Stream.of(openChoices[i]).map(choice -> new ImportCandidate((TypeNameMatch)choice)).toArray(ImportCandidate[]::new);
                Range range = null;
                try {
                    range = JDTUtils.toRange((IOpenable)unit, ranges[i].getOffset(), ranges[i].getLength());
                }
                catch (JavaModelException e) {
                    range = JDTUtils.newRange();
                }
                selections.add(new ImportSelection(candidates, range));
                ++i;
            }
            ImportCandidate[] chosens = (ImportCandidate[])chooseImports.apply(selections.toArray(new ImportSelection[0]));
            if (chosens == null) {
                return null;
            }
            HashMap typeMaps = new HashMap();
            Stream.of(openChoices).flatMap(x -> Arrays.stream(x)).forEach(x -> typeMaps.put(String.valueOf(x.getFullyQualifiedName()) + "@" + x.hashCode(), x));
            return (TypeNameMatch[])Stream.of(chosens).filter(chosen -> chosen != null && typeMaps.containsKey(chosen.id)).map(chosen -> (TypeNameMatch)typeMaps.get(chosen.id)).toArray(TypeNameMatch[]::new);
        });
        try {
            return op.createTextEdit(null);
        }
        catch (CoreException | OperationCanceledException e) {
            JavaLanguageServerPlugin.logException("Failed to resolve organize imports source action", e);
            return null;
        }
    }

    public static WorkspaceEdit organizeImports(JavaClientConnection connection, CodeActionParams params) {
        String uri = params.getTextDocument().getUri();
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (unit == null) {
            return null;
        }
        TextEdit edit = OrganizeImportsHandler.organizeImports(unit, (ImportSelection[] selections) -> {
            Object commandResult = connection.executeClientCommand(CLIENT_COMMAND_ID_CHOOSEIMPORTS, uri, selections);
            String json = commandResult == null ? null : new Gson().toJson(commandResult);
            return JSONUtility.toModel(json, ImportCandidate[].class);
        });
        return SourceAssistProcessor.convertToWorkspaceEdit(unit, edit);
    }

    public static class ImportCandidate {
        public String fullyQualifiedName;
        public String id;

        public ImportCandidate() {
        }

        public ImportCandidate(TypeNameMatch typeMatch) {
            this.fullyQualifiedName = typeMatch.getFullyQualifiedName();
            this.id = String.valueOf(typeMatch.getFullyQualifiedName()) + "@" + typeMatch.hashCode();
        }
    }

    public static class ImportSelection {
        public ImportCandidate[] candidates;
        public Range range;

        public ImportSelection(ImportCandidate[] candidates, Range range) {
            this.candidates = candidates;
            this.range = range;
        }
    }
}

