/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.ImplementationCollector;
import org.eclipse.jdt.ls.core.internal.handlers.ImplementationToLocationMapper;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class ImplementationsHandler {
    private PreferenceManager preferenceManager;

    public ImplementationsHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<? extends Location> findImplementations(TextDocumentPositionParams param, IProgressMonitor monitor) {
        List<Location> locations = null;
        IJavaElement elementToSearch = null;
        try {
            ITypeRoot typeRoot = JDTUtils.resolveTypeRoot(param.getTextDocument().getUri());
            if (typeRoot != null) {
                elementToSearch = JDTUtils.findElementAtSelection(typeRoot, param.getPosition().getLine(), param.getPosition().getCharacter(), this.preferenceManager, monitor);
            }
            if (!(elementToSearch instanceof IType) && !(elementToSearch instanceof IMethod)) {
                return Collections.emptyList();
            }
            int offset = this.getOffset(param, typeRoot);
            Region region = new Region(offset, 0);
            IType primaryType = typeRoot.findPrimaryType();
            boolean useDefaultLocation = primaryType == null ? false : "java.lang.Object".equals(primaryType.getFullyQualifiedName());
            ImplementationToLocationMapper mapper = new ImplementationToLocationMapper(this.preferenceManager.isClientSupportsClassFileContent(), useDefaultLocation);
            ImplementationCollector<Location> collector = new ImplementationCollector<Location>((IRegion)region, elementToSearch, mapper);
            locations = collector.findImplementations(monitor);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Find implementations failure ", e);
        }
        return locations;
    }

    private int getOffset(TextDocumentPositionParams param, ITypeRoot typeRoot) {
        int offset = 0;
        try {
            IDocument document = JsonRpcHelpers.toDocument(typeRoot.getBuffer());
            offset = document.getLineOffset(param.getPosition().getLine()) + param.getPosition().getCharacter();
        }
        catch (JavaModelException | BadLocationException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        return offset;
    }
}

