/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.ImplementationCollector;
import org.eclipse.lsp4j.Location;

public class ImplementationToLocationMapper
implements ImplementationCollector.ResultMapper<Location> {
    private boolean includeClassFiles;
    private boolean useDefaultPosition;

    public ImplementationToLocationMapper(boolean includeClassFiles, boolean useDefaultPosition) {
        this.includeClassFiles = includeClassFiles;
        this.useDefaultPosition = useDefaultPosition;
    }

    @Override
    public Location convert(IJavaElement element, int offset, int position) {
        ICompilationUnit compilationUnit = (ICompilationUnit)element.getAncestor(5);
        Location location = null;
        try {
            IClassFile cf;
            if (compilationUnit != null) {
                location = this.useDefaultPosition || offset > 0 && position > 0 ? JDTUtils.toLocation(compilationUnit, offset, position) : JDTUtils.toLocation(element);
            } else if (this.includeClassFiles && (cf = (IClassFile)element.getAncestor(6)) != null) {
                if (this.useDefaultPosition || offset > 0 && position > 0) {
                    location = JDTUtils.toLocation(cf, offset, position);
                } else {
                    location = JDTUtils.toLocation(element);
                    if (location == null) {
                        location = JDTUtils.toLocation(cf, 0, 0);
                    }
                }
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Failed to convert " + element, e);
        }
        return location;
    }
}

