/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;

public final class BundleUtils {
    private static final String REFERENCE_PREFIX = "reference:";

    private BundleUtils() {
    }

    public static void loadBundles(Collection<String> bundleLocations) throws CoreException {
        if (bundleLocations == null || bundleLocations.isEmpty()) {
            return;
        }
        BundleContext context = JavaLanguageServerPlugin.getBundleContext();
        MultiStatus status = new MultiStatus(context.getBundle().getSymbolicName(), 0, "Load bundle list", null);
        ArrayList<Bundle> bundlesToStart = new ArrayList<Bundle>();
        for (String bundleLocation : bundleLocations) {
            try {
                if (StringUtils.isEmpty((CharSequence)bundleLocation)) {
                    JavaLanguageServerPlugin.logError("Empty bundle location");
                    continue;
                }
                String location = BundleUtils.getBundleLocation(bundleLocation, true);
                BundleInfo bundleInfo = BundleUtils.getBundleInfo(bundleLocation);
                if (bundleInfo == null) {
                    status.add((IStatus)new Status(4, context.getBundle().getSymbolicName(), "Failed to get bundleInfo for bundle from " + bundleLocation, null));
                    continue;
                }
                Bundle bundle = Platform.getBundle((String)bundleInfo.getSymbolicName());
                if (bundle != null) {
                    if (bundle.getLocation().equals(location) && bundle.getVersion().equals((Object)Version.parseVersion((String)bundleInfo.getVersion()))) continue;
                    bundle.uninstall();
                }
                bundle = context.installBundle(location);
                JavaLanguageServerPlugin.logInfo("Installed " + bundle.getLocation());
                bundlesToStart.add(bundle);
            }
            catch (BundleException e) {
                status.add((IStatus)new Status(4, context.getBundle().getSymbolicName(), "Install bundle failure " + bundleLocation, (Throwable)e));
            }
            catch (MalformedURLException ex) {
                status.add((IStatus)new Status(4, context.getBundle().getSymbolicName(), "Bundle location format is not correct " + bundleLocation, (Throwable)ex));
            }
            catch (IOException e) {
                status.add((IStatus)new Status(4, context.getBundle().getSymbolicName(), "Cannot extract bundle symbolicName or version " + bundleLocation, (Throwable)e));
            }
        }
        status.addAll(BundleUtils.startBundles(bundlesToStart));
        if (status.getChildren().length > 0) {
            throw new CoreException((IStatus)status);
        }
    }

    private static IStatus startBundles(Collection<Bundle> bundles) {
        BundleContext context = JavaLanguageServerPlugin.getBundleContext();
        MultiStatus status = new MultiStatus(context.getBundle().getSymbolicName(), 0, "Starting added bundles", null);
        for (Bundle bundle : bundles) {
            if (bundle.getState() == 1) {
                status.add((IStatus)new Status(4, context.getBundle().getSymbolicName(), "Could not start: " + bundle.getSymbolicName() + '(' + bundle.getLocation() + ':' + bundle.getBundleId() + ')' + ". It's state is uninstalled."));
                continue;
            }
            if (bundle.getState() == 8 || bundle.getBundleId() == 0L) continue;
            try {
                ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).setStartLevel(4);
                bundle.start(2);
                JavaLanguageServerPlugin.logInfo("Started " + bundle.getLocation());
            }
            catch (BundleException e) {
                status.add((IStatus)new Status(4, context.getBundle().getSymbolicName(), "Bundle startup failed " + bundle.getLocation(), (Throwable)e));
            }
        }
        return status;
    }

    private static String getBundleLocation(String location, boolean useReference) throws MalformedURLException {
        File f = new File(location);
        String bundleLocation = f.toURI().toString();
        if (useReference) {
            bundleLocation = REFERENCE_PREFIX + bundleLocation;
        }
        return bundleLocation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BundleInfo getBundleInfo(String bundleLocation) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (JarFile jarFile = new JarFile(bundleLocation);){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) return null;
            Attributes mainAttributes = manifest.getMainAttributes();
            if (mainAttributes == null) return null;
            String bundleVersion = mainAttributes.getValue("Bundle-Version");
            if (StringUtils.isBlank((CharSequence)bundleVersion)) {
                return null;
            }
            String symbolicName = mainAttributes.getValue("Bundle-SymbolicName");
            if (!StringUtils.isNotBlank((CharSequence)symbolicName)) return new BundleInfo(bundleVersion, symbolicName);
            if (symbolicName.indexOf(59) < 0) return new BundleInfo(bundleVersion, symbolicName);
            symbolicName = symbolicName.substring(0, symbolicName.indexOf(59));
            return new BundleInfo(bundleVersion, symbolicName);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private static final class BundleInfo {
        private String version;
        private String symbolicName;

        private BundleInfo(String bundleVersion, String symbolicName) {
            this.version = bundleVersion;
            this.symbolicName = symbolicName;
        }

        private String getVersion() {
            return this.version;
        }

        private String getSymbolicName() {
            return this.symbolicName;
        }
    }
}

