/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.fix;

import java.util.Map;
import org.eclipse.core.runtime.Assert;

public final class CleanUpRequirements {
    private final boolean fRequiresAST;
    private final Map<String, String> fCompilerOptions;
    private final boolean fRequiresFreshAST;
    private final boolean fRequiresChangedRegions;

    public CleanUpRequirements(boolean requiresAST, boolean requiresFreshAST, boolean requiresChangedRegions, Map<String, String> compilerOptions) {
        Assert.isLegal((!requiresFreshAST || requiresAST ? 1 : 0) != 0, (String)"Must not request fresh AST if no AST is required");
        Assert.isLegal((compilerOptions == null || requiresAST ? 1 : 0) != 0, (String)"Must not provide options if no AST is required");
        this.fRequiresAST = requiresAST;
        this.fRequiresFreshAST = requiresFreshAST;
        this.fRequiresChangedRegions = requiresChangedRegions;
        this.fCompilerOptions = compilerOptions;
        if (this.fCompilerOptions != null) {
            this.fCompilerOptions.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", "disabled");
        }
    }

    public boolean requiresAST() {
        return this.fRequiresAST;
    }

    public boolean requiresFreshAST() {
        return this.fRequiresFreshAST;
    }

    public Map<String, String> getCompilerOptions() {
        return this.fCompilerOptions;
    }

    public boolean requiresChangedRegions() {
        return this.fRequiresChangedRegions;
    }
}

