/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalDescriptionProvider;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponse;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponses;
import org.eclipse.jdt.ls.core.internal.javadoc.JavadocContentAccess;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureInformation;

public final class SignatureHelpRequestor
extends CompletionRequestor {
    private List<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
    private final ICompilationUnit unit;
    private CompletionProposalDescriptionProvider descriptionProvider;
    private CompletionResponse response;
    private Map<SignatureInformation, CompletionProposal> infoProposals;

    public SignatureHelpRequestor(ICompilationUnit aUnit, int offset) {
        this.unit = aUnit;
        this.response = new CompletionResponse();
        this.response.setOffset(offset);
        this.setRequireExtendedContext(true);
        this.infoProposals = new HashMap<SignatureInformation, CompletionProposal>();
    }

    public SignatureHelp getSignatureHelp(IProgressMonitor monitor) {
        SignatureHelp signatureHelp = new SignatureHelp();
        this.response.setProposals(this.proposals);
        CompletionResponses.store(this.response);
        ArrayList<SignatureInformation> infos = new ArrayList<SignatureInformation>();
        int i = 0;
        while (i < this.proposals.size()) {
            if (monitor.isCanceled()) {
                return signatureHelp;
            }
            CompletionProposal proposal = this.proposals.get(i);
            SignatureInformation signatureInformation = this.toSignatureInformation(proposal);
            this.infoProposals.put(signatureInformation, proposal);
            infos.add(signatureInformation);
            ++i;
        }
        infos.sort((a, b) -> a.getParameters().size() - b.getParameters().size());
        signatureHelp.getSignatures().addAll(infos);
        return signatureHelp;
    }

    public boolean isIgnored(int completionProposalKind) {
        return completionProposalKind != 6;
    }

    public void accept(CompletionProposal proposal) {
        if (!this.isIgnored(proposal.getKind())) {
            if (proposal.getKind() == 8 && this.unit.getParent() != null && String.valueOf(proposal.getCompletion()).equals(this.unit.getParent().getElementName())) {
                proposal.setRelevance(proposal.getRelevance() + 1);
            }
            this.proposals.add(proposal);
        }
    }

    public void acceptContext(CompletionContext context) {
        super.acceptContext(context);
        this.response.setContext(context);
        this.descriptionProvider = new CompletionProposalDescriptionProvider(context);
    }

    public SignatureInformation toSignatureInformation(CompletionProposal methodProposal) {
        SignatureInformation $ = new SignatureInformation();
        StringBuilder desription = this.descriptionProvider.createMethodProposalDescription(methodProposal);
        $.setLabel(desription.toString());
        $.setDocumentation(this.computeJavaDoc(methodProposal));
        char[] signature = SignatureUtil.fix83600((char[])methodProposal.getSignature());
        char[][] parameterNames = methodProposal.findParameterNames(null);
        char[][] parameterTypes = Signature.getParameterTypes((char[])signature);
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = Signature.getSimpleName((char[])Signature.toCharArray((char[])SignatureUtil.getLowerBound((char[])parameterTypes[i])));
            ++i;
        }
        if (Flags.isVarargs((int)methodProposal.getFlags())) {
            int index = parameterTypes.length - 1;
            parameterTypes[index] = this.convertToVararg(parameterTypes[index]);
        }
        LinkedList<ParameterInformation> parameterInfos = new LinkedList<ParameterInformation>();
        int i2 = 0;
        while (i2 < parameterTypes.length) {
            StringBuilder builder = new StringBuilder();
            builder.append(parameterTypes[i2]);
            builder.append(' ');
            builder.append(parameterNames[i2]);
            parameterInfos.add(new ParameterInformation(builder.toString()));
            ++i2;
        }
        $.setParameters(parameterInfos);
        return $;
    }

    private char[] convertToVararg(char[] typeName) {
        if (typeName == null) {
            return typeName;
        }
        int len = typeName.length;
        if (len < 2) {
            return typeName;
        }
        if (typeName[len - 1] != ']') {
            return typeName;
        }
        if (typeName[len - 2] != '[') {
            return typeName;
        }
        char[] vararg = new char[len + 1];
        System.arraycopy(typeName, 0, vararg, 0, len - 2);
        vararg[len - 2] = 46;
        vararg[len - 1] = 46;
        vararg[len] = 46;
        return vararg;
    }

    public String computeJavaDoc(CompletionProposal proposal) {
        block7: {
            try {
                IType type = this.unit.getJavaProject().findType(SignatureUtil.stripSignatureToFQN((String)String.valueOf(proposal.getDeclarationSignature())));
                if (type == null) break block7;
                String[] parameters = Signature.getParameterTypes((String)String.valueOf(SignatureUtil.fix83600((char[])proposal.getSignature())));
                int i = 0;
                while (i < parameters.length) {
                    parameters[i] = SignatureUtil.getLowerBound((String)parameters[i]);
                    ++i;
                }
                IMethod method = JavaModelUtil.findMethod((String)String.valueOf(proposal.getName()), (String[])parameters, (boolean)proposal.isConstructor(), (IType)type);
                if (method == null || !method.exists()) break block7;
                ICompilationUnit unit = type.getCompilationUnit();
                if (unit != null) {
                    unit.reconcile(0, false, null, null);
                }
                String javadoc = null;
                try {
                    javadoc = (String)new SimpleTimeLimiter().callWithTimeout(() -> {
                        Reader reader = JavadocContentAccess.getPlainTextContentReader((IMember)method);
                        return reader == null ? null : CharStreams.toString((Readable)reader);
                    }, 500L, TimeUnit.MILLISECONDS, true);
                }
                catch (UncheckedTimeoutException uncheckedTimeoutException) {
                }
                catch (Exception e) {
                    JavaLanguageServerPlugin.logException("Unable to read documentation", e);
                }
                return javadoc;
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException("Unable to resolve signaturehelp javadoc", e);
            }
        }
        return null;
    }

    private static String getString(Reader reader) {
        try {
            return CharStreams.toString((Readable)reader);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Map<SignatureInformation, CompletionProposal> getInfoProposals() {
        return this.infoProposals;
    }
}

