/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.ls.core.internal.StatusFactory;

public final class ResourceUtils {
    public static final String FILE_UNC_PREFIX = "file:////";

    private ResourceUtils() {
    }

    public static List<IMarker> findMarkers(IResource resource, Integer ... severities) throws CoreException {
        if (resource == null) {
            return null;
        }
        HashSet<Integer> targetSeverities = severities == null ? Collections.emptySet() : new HashSet<Integer>(Arrays.asList(severities));
        IMarker[] allmarkers = resource.findMarkers(null, true, 2);
        List<IMarker> markers = Stream.of(allmarkers).filter(m -> targetSeverities.isEmpty() || targetSeverities.contains(m.getAttribute("severity", 0))).collect(Collectors.toList());
        return markers;
    }

    public static List<IMarker> getErrorMarkers(IResource resource) throws CoreException {
        return ResourceUtils.findMarkers(resource, 2);
    }

    public static List<IMarker> getWarningMarkers(IResource resource) throws CoreException {
        return ResourceUtils.findMarkers(resource, 1);
    }

    public static String toString(List<IMarker> markers) {
        if (markers == null || markers.isEmpty()) {
            return "";
        }
        String s = markers.stream().map(m -> ResourceUtils.toString(m)).collect(Collectors.joining(", "));
        return s;
    }

    public static String getMessage(IMarker marker) {
        if (marker == null) {
            return null;
        }
        return marker.getAttribute("message", null);
    }

    public static String toString(IMarker marker) {
        if (marker == null) {
            return null;
        }
        try {
            StringBuilder sb = new StringBuilder("Type=").append(marker.getType()).append(":Message=").append(marker.getAttribute("message")).append(":LineNumber=").append(marker.getAttribute("lineNumber"));
            return sb.toString();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return "Unknown marker";
        }
    }

    public static String getContent(URI fileURI) throws CoreException {
        String content;
        if (fileURI == null) {
            return null;
        }
        try {
            content = Files.toString((File)ResourceUtils.toFile(fileURI), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new CoreException(StatusFactory.newErrorStatus("Can not get " + fileURI + " content", e));
        }
        return content;
    }

    public static void setContent(URI fileURI, String content) throws CoreException {
        if (content == null) {
            content = "";
        }
        try {
            Files.write((CharSequence)content, (File)ResourceUtils.toFile(fileURI), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new CoreException(StatusFactory.newErrorStatus("Can not write to " + fileURI, e));
        }
    }

    public static String getContent(IFile file) throws CoreException {
        String content;
        if (file == null) {
            return null;
        }
        try {
            content = IOUtil.toString((InputStream)file.getContents());
        }
        catch (IOException e) {
            throw new CoreException(StatusFactory.newErrorStatus("Can not get " + file.getRawLocation() + " content", e));
        }
        return content;
    }

    public static void setContent(IFile file, String content) throws CoreException {
        Assert.isNotNull((Object)file, (String)"file can not be null");
        if (content == null) {
            content = "";
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayInputStream newContent = new ByteArrayInputStream(content.getBytes());){
                file.setContents((InputStream)newContent, 1, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(StatusFactory.newErrorStatus("Can not write to " + file.getRawLocation(), e));
        }
    }

    public static String fixURI(URI uri) {
        if ("win32".equals(Platform.getOS()) && URIUtil.isFileURI((URI)uri)) {
            uri = URIUtil.toFile((URI)uri).toURI();
        }
        String uriString = uri.toString();
        return uriString.replaceFirst("file:/([^/])", "file:///$1");
    }

    public static File toFile(URI uri) {
        if ("win32".equals(Platform.getOS())) {
            return URIUtil.toFile((URI)uri);
        }
        return new File(uri);
    }

    public static String toClientUri(String uri) {
        if (uri != null && "win32".equals(Platform.getOS()) && uri.startsWith(FILE_UNC_PREFIX)) {
            uri = uri.replace(FILE_UNC_PREFIX, "file://");
        }
        return uri;
    }

    public static IPath filePathFromURI(String uriStr) {
        URI uri = URI.create(uriStr);
        if ("file".equals(uri.getScheme())) {
            return Path.fromOSString((String)Paths.get(uri).toString());
        }
        return null;
    }

    public static IPath canonicalFilePathFromURI(String uriStr) {
        URI uri = URI.create(uriStr);
        if ("file".equals(uri.getScheme())) {
            return FileUtil.canonicalPath((IPath)Path.fromOSString((String)Paths.get(uri).toString()));
        }
        return null;
    }

    public static boolean isContainedIn(IPath location, Collection<IPath> paths) {
        if (location == null || paths == null || paths.isEmpty()) {
            return false;
        }
        for (IPath path : paths) {
            if (!path.isPrefixOf(location)) continue;
            return true;
        }
        return false;
    }

    public static String expandPath(String path) {
        if (path != null && path.startsWith("~" + File.separator)) {
            return String.valueOf(System.getProperty("user.home")) + path.substring(1);
        }
        return path;
    }

    public static String toGlobPattern(IPath path) {
        if (path == null) {
            return null;
        }
        String globPattern = path.toPortableString();
        if (path.getDevice() != null) {
            globPattern = globPattern.replace(path.getDevice(), "**");
        }
        if (!globPattern.endsWith(".jar") && !globPattern.endsWith(".zip")) {
            if (!globPattern.endsWith("/")) {
                globPattern = String.valueOf(globPattern) + "/";
            }
            globPattern = String.valueOf(globPattern) + "**";
        }
        return globPattern;
    }
}

