/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;

public class JVMConfigurator
implements IVMInstallChangedListener {
    public static boolean configureDefaultVM(Preferences preferences) throws CoreException {
        IVMInstall defaultVM;
        File location;
        File jvmHome;
        if (preferences == null) {
            return false;
        }
        String javaHome = preferences.getJavaHome();
        if (javaHome != null && (jvmHome = new File(javaHome)).isDirectory() && !(location = (defaultVM = JavaRuntime.getDefaultVMInstall()).getInstallLocation()).equals(jvmHome)) {
            IVMInstall vm = JVMConfigurator.findVM(jvmHome);
            if (vm == null) {
                IVMInstallType installType = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
                long unique = System.currentTimeMillis();
                while (installType.findVMInstall(String.valueOf(unique)) != null) {
                    ++unique;
                }
                String vmId = String.valueOf(unique);
                VMStandin vmStandin = new VMStandin(installType, vmId);
                String name = (String)StringUtils.defaultIfBlank((CharSequence)jvmHome.getName(), (CharSequence)"JRE");
                vmStandin.setName(name);
                vmStandin.setInstallLocation(jvmHome);
                vm = vmStandin.convertToRealVM();
            }
            JavaRuntime.setDefaultVMInstall((IVMInstall)vm, (IProgressMonitor)new NullProgressMonitor());
            JDTUtils.setCompatibleVMs(vm.getId());
            return true;
        }
        return false;
    }

    private static IVMInstall findVM(File jvmHome) {
        IVMInstallType[] types;
        IVMInstallType[] iVMInstallTypeArray = types = JavaRuntime.getVMInstallTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstall[] installs;
            IVMInstallType type = iVMInstallTypeArray[n2];
            IVMInstall[] iVMInstallArray = installs = type.getVMInstalls();
            int n3 = installs.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall install = iVMInstallArray[n4];
                if (jvmHome.equals(install.getInstallLocation())) {
                    return install;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
        IProject[] projects;
        if (Objects.equals(previous, current)) {
            return;
        }
        Hashtable options = JavaCore.getOptions();
        AbstractVMInstall jvm = (AbstractVMInstall)current;
        long jdkLevel = CompilerOptions.versionToJdkLevel((String)jvm.getJavaVersion());
        String compliance = CompilerOptions.versionFromJdkLevel((long)jdkLevel);
        JavaCore.setComplianceOptions((String)compliance, (Map)options);
        JavaCore.setOptions((Hashtable)options);
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!ProjectUtils.isVisibleProject(project) && ProjectUtils.isJavaProject(project)) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                JVMConfigurator.configureJVMSettings(javaProject, current);
            }
            ++n2;
        }
    }

    public void vmChanged(PropertyChangeEvent event) {
    }

    public void vmAdded(IVMInstall vm) {
    }

    public void vmRemoved(IVMInstall vm) {
    }

    public static void configureJVMSettings(IJavaProject javaProject) {
        JVMConfigurator.configureJVMSettings(javaProject, JavaRuntime.getDefaultVMInstall());
    }

    public static void configureJVMSettings(IJavaProject javaProject, IVMInstall vmInstall) {
        if (javaProject == null) {
            return;
        }
        long jdkLevel = 0L;
        if (vmInstall instanceof AbstractVMInstall) {
            AbstractVMInstall jvm = (AbstractVMInstall)vmInstall;
            jdkLevel = CompilerOptions.versionToJdkLevel((String)jvm.getJavaVersion());
            String compliance = CompilerOptions.versionFromJdkLevel((long)jdkLevel);
            Map options = javaProject.getOptions(false);
            JavaCore.setComplianceOptions((String)compliance, (Map)options);
        }
        if (jdkLevel > 0x370000L) {
            javaProject.setOption("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
            javaProject.setOption("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "ignore");
        } else {
            javaProject.setOption("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "disabled");
        }
    }
}

