/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ls.core.internal.IDelegateCommandHandler;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.commands.BuildPathCommand;
import org.eclipse.jdt.ls.core.internal.commands.OrganizeImportsCommand;
import org.eclipse.jdt.ls.core.internal.commands.SourceAttachmentCommand;
import org.eclipse.lsp4j.WorkspaceEdit;

public class JDTDelegateCommandHandler
implements IDelegateCommandHandler {
    @Override
    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor monitor) throws Exception {
        block23: {
            if (StringUtils.isBlank((CharSequence)commandId)) break block23;
            switch (commandId) {
                case "java.edit.organizeImports": {
                    OrganizeImportsCommand c = new OrganizeImportsCommand();
                    Object result = c.organizeImports(arguments);
                    boolean applyNow = JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isWorkspaceApplyEditSupported();
                    if (applyNow) {
                        JavaLanguageServerPlugin.getInstance().getClientConnection().applyWorkspaceEdit((WorkspaceEdit)result);
                        return new Object();
                    }
                    return result;
                }
                case "java.project.resolveSourceAttachment": {
                    return SourceAttachmentCommand.resolveSourceAttachment(arguments, monitor);
                }
                case "java.project.updateSourceAttachment": {
                    return SourceAttachmentCommand.updateSourceAttachment(arguments, monitor);
                }
                case "java.project.addToSourcePath": {
                    String sourceFolder = (String)arguments.get(0);
                    return BuildPathCommand.addToSourcePath(sourceFolder);
                }
                case "java.project.removeFromSourcePath": {
                    String sourceFolder1 = (String)arguments.get(0);
                    return BuildPathCommand.removeFromSourcePath(sourceFolder1);
                }
                case "java.project.listSourcePaths": {
                    return BuildPathCommand.listSourcePaths();
                }
            }
        }
        throw new UnsupportedOperationException(String.format("Java language server doesn't support the command '%s'.", commandId));
    }
}

