/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.hover.JavaElementLabels;

public class BindingLabelProvider {
    public static final long DEFAULT_TEXTFLAGS = JavaElementLabels.ALL_DEFAULT;

    private static void getFieldLabel(IVariableBinding binding, long flags, StringBuffer buffer) {
        ITypeBinding declaringClass;
        if ((flags & 0x8000L) != 0L && !binding.isEnumConstant()) {
            BindingLabelProvider.getTypeLabel(binding.getType(), flags & 0x200000L, buffer);
            buffer.append(' ');
        }
        if ((flags & 0x10000L) != 0L && (declaringClass = binding.getDeclaringClass()) != null) {
            BindingLabelProvider.getTypeLabel(declaringClass, 0x40000L | flags & 0x2000000000L, buffer);
            buffer.append('.');
        }
        buffer.append(binding.getName());
        if ((flags & 0x4000L) != 0L && !binding.isEnumConstant()) {
            buffer.append(" : ");
            BindingLabelProvider.getTypeLabel(binding.getType(), flags & 0x200000L, buffer);
        }
        if ((flags & 0x20000L) != 0L && (declaringClass = binding.getDeclaringClass()) != null) {
            buffer.append(" - ");
            BindingLabelProvider.getTypeLabel(declaringClass, 0x40000L | flags & 0x2000000000L, buffer);
        }
    }

    private static void getLocalVariableLabel(IVariableBinding binding, long flags, StringBuffer buffer) {
        IMethodBinding declaringMethod;
        if ((flags & 0x8000L) != 0L) {
            BindingLabelProvider.getTypeLabel(binding.getType(), flags & 0x200000L, buffer);
            buffer.append(' ');
        }
        if ((flags & 0x10000L) != 0L && (declaringMethod = binding.getDeclaringMethod()) != null) {
            BindingLabelProvider.getMethodLabel(declaringMethod, flags, buffer);
            buffer.append('.');
        }
        buffer.append(binding.getName());
        if ((flags & 0x4000L) != 0L) {
            buffer.append(" : ");
            BindingLabelProvider.getTypeLabel(binding.getType(), flags & 0x200000L, buffer);
        }
    }

    private static void appendDimensions(int dim, StringBuffer buffer) {
        int i = 0;
        while (i < dim) {
            buffer.append('[').append(']');
            ++i;
        }
    }

    private static void getMethodLabel(IMethodBinding binding, long flags, StringBuffer buffer) {
        ITypeBinding[] exceptions;
        int index;
        ITypeBinding[] typeArguments;
        ITypeBinding[] typeParameters;
        if ((flags & 4L) != 0L && binding.isGenericMethod() && (typeParameters = binding.getTypeParameters()).length > 0) {
            BindingLabelProvider.getTypeParametersLabel(typeParameters, buffer);
            buffer.append(' ');
        }
        if ((flags & 0x40L) != 0L && !binding.isConstructor()) {
            BindingLabelProvider.getTypeLabel(binding.getReturnType(), flags & 0x200000L, buffer);
            buffer.append(' ');
        }
        if ((flags & 0x80L) != 0L) {
            BindingLabelProvider.getTypeLabel(binding.getDeclaringClass(), 0x40000L | flags & 0x2000000000L, buffer);
            buffer.append('.');
        }
        buffer.append(binding.getName());
        if ((flags & 8L) != 0L && binding.isParameterizedMethod() && (typeArguments = binding.getTypeArguments()).length > 0) {
            buffer.append(' ');
            BindingLabelProvider.getTypeArgumentsLabel(typeArguments, flags & 0x200000L, buffer);
        }
        buffer.append('(');
        if ((flags & 1L | 2L) != 0L) {
            ITypeBinding[] parameters;
            ITypeBinding[] iTypeBindingArray = parameters = (flags & 1L) != 0L ? binding.getParameterTypes() : null;
            if (parameters != null) {
                index = 0;
                while (index < parameters.length) {
                    if (index > 0) {
                        buffer.append(", ");
                    }
                    ITypeBinding paramType = parameters[index];
                    if (binding.isVarargs() && index == parameters.length - 1) {
                        BindingLabelProvider.getTypeLabel(paramType.getElementType(), flags & 0x200000L, buffer);
                        BindingLabelProvider.appendDimensions(paramType.getDimensions() - 1, buffer);
                        buffer.append("...");
                    } else {
                        BindingLabelProvider.getTypeLabel(paramType, flags & 0x200000L, buffer);
                    }
                    ++index;
                }
            }
        } else if (binding.getParameterTypes().length > 0) {
            buffer.append("...");
        }
        buffer.append(')');
        if ((flags & 0x10L) != 0L && (exceptions = binding.getExceptionTypes()).length > 0) {
            buffer.append(" throws ");
            index = 0;
            while (index < exceptions.length) {
                if (index > 0) {
                    buffer.append(", ");
                }
                BindingLabelProvider.getTypeLabel(exceptions[index], flags & 0x200000L, buffer);
                ++index;
            }
        }
        if ((flags & 8L) != 0L && binding.isGenericMethod() && (typeParameters = binding.getTypeParameters()).length > 0) {
            buffer.append(' ');
            BindingLabelProvider.getTypeParametersLabel(typeParameters, buffer);
        }
        if ((flags & 0x20L) != 0L && !binding.isConstructor()) {
            buffer.append(" : ");
            BindingLabelProvider.getTypeLabel(binding.getReturnType(), flags & 0x200000L, buffer);
        }
        if ((flags & 0x100L) != 0L) {
            buffer.append(" - ");
            BindingLabelProvider.getTypeLabel(binding.getDeclaringClass(), 0x40000L | flags & 0x2000000000L, buffer);
        }
    }

    private static void getTypeLabel(ITypeBinding binding, long flags, StringBuffer buffer) {
        IPackageBinding pack;
        if ((flags & 0x40000L) != 0L && (pack = binding.getPackage()) != null && !pack.isUnnamed()) {
            buffer.append(pack.getName());
            buffer.append('.');
        }
        if ((flags & 0xC0000L) != 0L) {
            IMethodBinding declaringMethod;
            ITypeBinding declaring = binding.getDeclaringClass();
            if (declaring != null) {
                BindingLabelProvider.getTypeLabel(declaring, 0x80000L | flags & 0x2000000000L, buffer);
                buffer.append('.');
            }
            if ((declaringMethod = binding.getDeclaringMethod()) != null) {
                BindingLabelProvider.getMethodLabel(declaringMethod, 0L, buffer);
                buffer.append('.');
            }
        }
        if (binding.isCapture()) {
            BindingLabelProvider.getTypeLabel(binding.getWildcard(), flags & 0x200000L, buffer);
        } else if (binding.isWildcardType()) {
            buffer.append('?');
            ITypeBinding bound = binding.getBound();
            if (bound != null) {
                if (binding.isUpperbound()) {
                    buffer.append(" extends ");
                } else {
                    buffer.append(" super ");
                }
                BindingLabelProvider.getTypeLabel(bound, flags & 0x200000L, buffer);
            }
        } else if (binding.isArray()) {
            BindingLabelProvider.getTypeLabel(binding.getElementType(), flags & 0x200000L, buffer);
            BindingLabelProvider.appendDimensions(binding.getDimensions(), buffer);
        } else {
            String name = binding.getTypeDeclaration().getName();
            if (name.length() == 0) {
                if (binding.isEnum()) {
                    buffer.append("{...}");
                } else if (binding.isAnonymous()) {
                    ITypeBinding[] superInterfaces = binding.getInterfaces();
                    ITypeBinding baseType = superInterfaces.length > 0 ? superInterfaces[0] : binding.getSuperclass();
                    if (baseType != null) {
                        StringBuffer anonymBaseType = new StringBuffer();
                        BindingLabelProvider.getTypeLabel(baseType, flags & 0x200000L, anonymBaseType);
                        buffer.append(Messages.format("new {0}() '{'...}", anonymBaseType.toString()));
                    } else {
                        buffer.append("new Anonymous");
                    }
                } else {
                    buffer.append("UNKNOWN");
                }
            } else {
                buffer.append(name);
            }
            if ((flags & 0x200000L) != 0L) {
                if (binding.isGenericType()) {
                    BindingLabelProvider.getTypeParametersLabel(binding.getTypeParameters(), buffer);
                } else if (binding.isParameterizedType()) {
                    BindingLabelProvider.getTypeArgumentsLabel(binding.getTypeArguments(), flags, buffer);
                }
            }
        }
        if ((flags & 0x100000L) != 0L) {
            IMethodBinding declaringMethod = binding.getDeclaringMethod();
            ITypeBinding declaringType = binding.getDeclaringClass();
            if (declaringMethod != null) {
                buffer.append(" - ");
                BindingLabelProvider.getMethodLabel(declaringMethod, 0x40000L | flags & 0x2000000000L, buffer);
            } else if (declaringType != null) {
                buffer.append(" - ");
                BindingLabelProvider.getTypeLabel(declaringType, 0x40000L | flags & 0x2000000000L, buffer);
            } else {
                IPackageBinding pack2 = binding.getPackage();
                if (pack2 != null && !pack2.isUnnamed()) {
                    buffer.append(" - ");
                    buffer.append(pack2.getName());
                }
            }
        }
    }

    private static void getTypeArgumentsLabel(ITypeBinding[] typeArgs, long flags, StringBuffer buf) {
        if (typeArgs.length > 0) {
            buf.append('<');
            int i = 0;
            while (i < typeArgs.length) {
                if (i > 0) {
                    buf.append(", ");
                }
                BindingLabelProvider.getTypeLabel(typeArgs[i], flags & 0x200000L, buf);
                ++i;
            }
            buf.append('>');
        }
    }

    private static void getTypeParametersLabel(ITypeBinding[] typeParameters, StringBuffer buffer) {
        if (typeParameters.length > 0) {
            buffer.append('<');
            int index = 0;
            while (index < typeParameters.length) {
                if (index > 0) {
                    buffer.append(", ");
                }
                buffer.append(typeParameters[index].getName());
                ++index;
            }
            buffer.append('>');
        }
    }

    public static String getBindingLabel(IBinding binding, long flags) {
        StringBuffer buffer = new StringBuffer(60);
        if (binding instanceof ITypeBinding) {
            BindingLabelProvider.getTypeLabel((ITypeBinding)binding, flags, buffer);
        } else if (binding instanceof IMethodBinding) {
            BindingLabelProvider.getMethodLabel((IMethodBinding)binding, flags, buffer);
        } else if (binding instanceof IVariableBinding) {
            IVariableBinding variable = (IVariableBinding)binding;
            if (variable.isField()) {
                BindingLabelProvider.getFieldLabel(variable, flags, buffer);
            } else {
                BindingLabelProvider.getLocalVariableLabel(variable, flags, buffer);
            }
        }
        return Strings.markLTR((String)buffer.toString());
    }
}

