/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.vector;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.query.UnsupportedSpatialOperation;
import org.apache.lucene.spatial.vector.DistanceValueSource;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;

public class PointVectorStrategy
extends SpatialStrategy {
    public static FieldType DEFAULT_FIELDTYPE;
    public static final String SUFFIX_X = "__x";
    public static final String SUFFIX_Y = "__y";
    private final String fieldNameX;
    private final String fieldNameY;
    private final int fieldsLen;
    private final boolean hasStored;
    private final boolean hasDocVals;
    private final boolean hasPointVals;

    public static PointVectorStrategy newInstance(SpatialContext ctx, String fieldNamePrefix) {
        return new PointVectorStrategy(ctx, fieldNamePrefix, DEFAULT_FIELDTYPE);
    }

    public PointVectorStrategy(SpatialContext ctx, String fieldNamePrefix, FieldType fieldType) {
        super(ctx, fieldNamePrefix);
        this.fieldNameX = fieldNamePrefix + SUFFIX_X;
        this.fieldNameY = fieldNamePrefix + SUFFIX_Y;
        int numPairs = 0;
        this.hasStored = fieldType.stored();
        if (this.hasStored) {
            ++numPairs;
        }
        if (this.hasDocVals = fieldType.docValuesType() != DocValuesType.NONE) {
            ++numPairs;
        }
        if (this.hasPointVals = fieldType.pointDataDimensionCount() > 0) {
            ++numPairs;
        }
        this.fieldsLen = numPairs * 2;
    }

    String getFieldNameX() {
        return this.fieldNameX;
    }

    String getFieldNameY() {
        return this.fieldNameY;
    }

    @Override
    public Field[] createIndexableFields(Shape shape) {
        if (shape instanceof Point) {
            return this.createIndexableFields((Point)shape);
        }
        throw new UnsupportedOperationException("Can only index Point, not " + shape);
    }

    public Field[] createIndexableFields(Point point) {
        Field[] fields = new Field[this.fieldsLen];
        int idx = -1;
        if (this.hasStored) {
            fields[++idx] = new StoredField(this.fieldNameX, point.getX());
            fields[++idx] = new StoredField(this.fieldNameY, point.getY());
        }
        if (this.hasDocVals) {
            fields[++idx] = new DoubleDocValuesField(this.fieldNameX, point.getX());
            fields[++idx] = new DoubleDocValuesField(this.fieldNameY, point.getY());
        }
        if (this.hasPointVals) {
            fields[++idx] = new DoublePoint(this.fieldNameX, new double[]{point.getX()});
            fields[++idx] = new DoublePoint(this.fieldNameY, new double[]{point.getY()});
        }
        assert (idx == fields.length - 1);
        return fields;
    }

    @Override
    public DoubleValuesSource makeDistanceValueSource(Point queryPoint, double multiplier) {
        return new DistanceValueSource(this, queryPoint, multiplier);
    }

    @Override
    public Query makeQuery(SpatialArgs args) {
        if (!SpatialOperation.is(args.getOperation(), SpatialOperation.Intersects, SpatialOperation.IsWithin)) {
            throw new UnsupportedSpatialOperation(args.getOperation());
        }
        Shape shape = args.getShape();
        if (shape instanceof Rectangle) {
            Rectangle bbox = (Rectangle)shape;
            return new ConstantScoreQuery(this.makeWithin(bbox));
        }
        if (shape instanceof Circle) {
            Circle circle = (Circle)shape;
            Rectangle bbox = circle.getBoundingBox();
            return new DistanceRangeQuery(this.makeWithin(bbox), this.makeDistanceValueSource(circle.getCenter()), circle.getRadius());
        }
        throw new UnsupportedOperationException("Only Rectangles and Circles are currently supported, found [" + shape.getClass() + "]");
    }

    private Query makeWithin(Rectangle bbox) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        BooleanClause.Occur MUST = BooleanClause.Occur.MUST;
        if (bbox.getCrossesDateLine()) {
            bq.add(this.rangeQuery(this.fieldNameX, null, bbox.getMaxX()), BooleanClause.Occur.SHOULD);
            bq.add(this.rangeQuery(this.fieldNameX, bbox.getMinX(), null), BooleanClause.Occur.SHOULD);
            bq.setMinimumNumberShouldMatch(1);
        } else {
            bq.add(this.rangeQuery(this.fieldNameX, bbox.getMinX(), bbox.getMaxX()), MUST);
        }
        bq.add(this.rangeQuery(this.fieldNameY, bbox.getMinY(), bbox.getMaxY()), MUST);
        return bq.build();
    }

    private Query rangeQuery(String fieldName, Double min, Double max) {
        if (this.hasPointVals) {
            if (min == null) {
                min = Double.NEGATIVE_INFINITY;
            }
            if (max == null) {
                max = Double.POSITIVE_INFINITY;
            }
            return DoublePoint.newRangeQuery((String)fieldName, (double)min, (double)max);
        }
        throw new UnsupportedOperationException("An index is required for this operation.");
    }

    static {
        FieldType type = new FieldType();
        type.setDimensions(1, 8);
        type.setDocValuesType(DocValuesType.NUMERIC);
        type.setStored(false);
        type.freeze();
        DEFAULT_FIELDTYPE = type;
    }

    private static class DistanceRangeQuery
    extends Query {
        final Query inner;
        final DoubleValuesSource distanceSource;
        final double limit;

        private DistanceRangeQuery(Query inner, DoubleValuesSource distanceSource, double limit) {
            this.inner = inner;
            this.distanceSource = distanceSource;
            this.limit = limit;
        }

        public Query rewrite(IndexReader reader) throws IOException {
            Query rewritten = this.inner.rewrite(reader);
            if (rewritten == this.inner) {
                return this;
            }
            return new DistanceRangeQuery(rewritten, this.distanceSource, this.limit);
        }

        public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
            final Weight w = this.inner.createWeight(searcher, scoreMode, 1.0f);
            return new ConstantScoreWeight(this, boost){

                public Scorer scorer(LeafReaderContext context) throws IOException {
                    Scorer in = w.scorer(context);
                    if (in == null) {
                        return null;
                    }
                    final DoubleValues v = distanceSource.getValues(context, DoubleValuesSource.fromScorer((Scorable)in));
                    DocIdSetIterator approximation = in.iterator();
                    TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                        public boolean matches() throws IOException {
                            return v.advanceExact(this.approximation.docID()) && v.doubleValue() <= limit;
                        }

                        public float matchCost() {
                            return 100.0f;
                        }
                    };
                    return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, twoPhase);
                }

                public boolean isCacheable(LeafReaderContext ctx) {
                    return distanceSource.isCacheable(ctx);
                }
            };
        }

        public String toString(String field) {
            return "DistanceRangeQuery(" + this.inner.toString(field) + "; " + this.distanceSource.toString() + " < " + this.limit + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            DistanceRangeQuery that = (DistanceRangeQuery)((Object)o);
            return Objects.equals(this.inner, that.inner) && Objects.equals(this.distanceSource, that.distanceSource) && this.limit == that.limit;
        }

        public int hashCode() {
            return Objects.hash(this.inner, this.distanceSource, this.limit);
        }
    }
}

