/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.Map;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.reindex.AbstractAsyncBulkByScrollAction;
import org.elasticsearch.index.reindex.BulkByScrollParallelizationHelper;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.index.reindex.UpdateByQueryAction;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.index.reindex.WorkerBulkByScrollTaskState;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateByQueryAction
extends HandledTransportAction<UpdateByQueryRequest, BulkByScrollResponse> {
    private final ThreadPool threadPool;
    private final Client client;
    private final ScriptService scriptService;
    private final ClusterService clusterService;

    @Inject
    public TransportUpdateByQueryAction(ThreadPool threadPool, ActionFilters actionFilters, Client client, TransportService transportService, ScriptService scriptService, ClusterService clusterService) {
        super("indices:data/write/update/byquery", transportService, actionFilters, UpdateByQueryRequest::new);
        this.threadPool = threadPool;
        this.client = client;
        this.scriptService = scriptService;
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, UpdateByQueryRequest request, ActionListener<BulkByScrollResponse> listener) {
        BulkByScrollTask bulkByScrollTask = (BulkByScrollTask)task;
        BulkByScrollParallelizationHelper.startSlicedAction(request, bulkByScrollTask, (Action<BulkByScrollResponse>)UpdateByQueryAction.INSTANCE, listener, this.client, this.clusterService.localNode(), () -> {
            ClusterState state = this.clusterService.state();
            ParentTaskAssigningClient assigningClient = new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), (Task)bulkByScrollTask);
            new AsyncIndexBySearchAction(bulkByScrollTask, this.logger, assigningClient, this.threadPool, request, this.scriptService, state, listener).start();
        });
    }

    static class AsyncIndexBySearchAction
    extends AbstractAsyncBulkByScrollAction<UpdateByQueryRequest> {
        AsyncIndexBySearchAction(BulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, UpdateByQueryRequest request, ScriptService scriptService, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener) {
            super(task, logger, client, threadPool, request, scriptService, clusterState, listener);
        }

        @Override
        protected boolean needsSourceDocumentVersions() {
            return true;
        }

        @Override
        public BiFunction<AbstractAsyncBulkByScrollAction.RequestWrapper<?>, ScrollableHitSource.Hit, AbstractAsyncBulkByScrollAction.RequestWrapper<?>> buildScriptApplier() {
            Script script = ((UpdateByQueryRequest)this.mainRequest).getScript();
            if (script != null) {
                return new UpdateByQueryScriptApplier(this.worker, this.scriptService, script, script.getParams());
            }
            return super.buildScriptApplier();
        }

        @Override
        protected AbstractAsyncBulkByScrollAction.RequestWrapper<IndexRequest> buildRequest(ScrollableHitSource.Hit doc) {
            IndexRequest index = new IndexRequest();
            index.index(doc.getIndex());
            index.type(doc.getType());
            index.id(doc.getId());
            index.source(doc.getSource(), doc.getXContentType());
            index.versionType(VersionType.INTERNAL);
            index.version(doc.getVersion());
            index.setPipeline(((UpdateByQueryRequest)this.mainRequest).getPipeline());
            return AsyncIndexBySearchAction.wrap(index);
        }

        class UpdateByQueryScriptApplier
        extends AbstractAsyncBulkByScrollAction.ScriptApplier {
            UpdateByQueryScriptApplier(WorkerBulkByScrollTaskState taskWorker, ScriptService scriptService, Script script, Map<String, Object> params) {
                super(taskWorker, scriptService, script, params);
            }

            @Override
            protected void scriptChangedIndex(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_index] not allowed");
            }

            @Override
            protected void scriptChangedType(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_type] not allowed");
            }

            @Override
            protected void scriptChangedId(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_id] not allowed");
            }

            @Override
            protected void scriptChangedVersion(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_version] not allowed");
            }

            @Override
            protected void scriptChangedRouting(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_routing] not allowed");
            }
        }
    }
}

