/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.time.ZoneId;
import java.util.Random;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.script.JodaCompatibleZonedDateTime;

public final class ScoreScriptUtils {
    private static final ZoneId defaultZoneId = ZoneId.of("UTC");
    private static final DateMathParser dateParser = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.toDateMathParser();

    public static double rational(double value, double k) {
        return value / (k + value);
    }

    public static double sigmoid(double value, double k, double a) {
        return Math.pow(value, a) / (Math.pow(k, a) + Math.pow(value, a));
    }

    public static double randomReproducible(String seedValue, int seed) {
        int hash = StringHelper.murmurhash3_x86_32((BytesRef)new BytesRef((CharSequence)seedValue), (int)seed);
        return (float)(hash & 0xFFFFFF) / 1.6777216E7f;
    }

    public static final class DecayDateGauss {
        long origin;
        long offset;
        double scaling;

        public DecayDateGauss(String originStr, String scaleStr, String offsetStr, double decay) {
            this.origin = dateParser.parse(originStr, null, false, defaultZoneId);
            long scale = TimeValue.parseTimeValue((String)scaleStr, (TimeValue)TimeValue.timeValueHours((long)24L), (String)(this.getClass().getSimpleName() + ".scale")).getMillis();
            this.offset = TimeValue.parseTimeValue((String)offsetStr, (TimeValue)TimeValue.timeValueHours((long)24L), (String)(this.getClass().getSimpleName() + ".offset")).getMillis();
            this.scaling = 0.5 * Math.pow(scale, 2.0) / Math.log(decay);
        }

        public double decayDateGauss(JodaCompatibleZonedDateTime docValueDate) {
            long docValue = docValueDate.toInstant().toEpochMilli();
            long diff = docValue >= this.origin ? docValue - this.origin : this.origin - docValue;
            long distance = Math.max(0L, diff - this.offset);
            return Math.exp(0.5 * Math.pow(distance, 2.0) / this.scaling);
        }
    }

    public static final class DecayDateExp {
        long origin;
        long offset;
        double scaling;

        public DecayDateExp(String originStr, String scaleStr, String offsetStr, double decay) {
            this.origin = dateParser.parse(originStr, null, false, defaultZoneId);
            long scale = TimeValue.parseTimeValue((String)scaleStr, (TimeValue)TimeValue.timeValueHours((long)24L), (String)(this.getClass().getSimpleName() + ".scale")).getMillis();
            this.offset = TimeValue.parseTimeValue((String)offsetStr, (TimeValue)TimeValue.timeValueHours((long)24L), (String)(this.getClass().getSimpleName() + ".offset")).getMillis();
            this.scaling = Math.log(decay) / (double)scale;
        }

        public double decayDateExp(JodaCompatibleZonedDateTime docValueDate) {
            long docValue = docValueDate.toInstant().toEpochMilli();
            long diff = docValue >= this.origin ? docValue - this.origin : this.origin - docValue;
            long distance = Math.max(0L, diff - this.offset);
            return Math.exp(this.scaling * (double)distance);
        }
    }

    public static final class DecayDateLinear {
        long origin;
        long offset;
        double scaling;

        public DecayDateLinear(String originStr, String scaleStr, String offsetStr, double decay) {
            this.origin = dateParser.parse(originStr, null, false, defaultZoneId);
            long scale = TimeValue.parseTimeValue((String)scaleStr, (TimeValue)TimeValue.timeValueHours((long)24L), (String)(this.getClass().getSimpleName() + ".scale")).getMillis();
            this.offset = TimeValue.parseTimeValue((String)offsetStr, (TimeValue)TimeValue.timeValueHours((long)24L), (String)(this.getClass().getSimpleName() + ".offset")).getMillis();
            this.scaling = (double)scale / (1.0 - decay);
        }

        public double decayDateLinear(JodaCompatibleZonedDateTime docValueDate) {
            long docValue = docValueDate.toInstant().toEpochMilli();
            long diff = docValue >= this.origin ? docValue - this.origin : this.origin - docValue;
            long distance = Math.max(0L, diff - this.offset);
            return Math.max(0.0, (this.scaling - (double)distance) / this.scaling);
        }
    }

    public static final class DecayNumericGauss {
        double origin;
        double offset;
        double scaling;

        public DecayNumericGauss(double origin, double scale, double offset, double decay) {
            this.origin = origin;
            this.offset = offset;
            this.scaling = 0.5 * Math.pow(scale, 2.0) / Math.log(decay);
        }

        public double decayNumericGauss(double docValue) {
            double distance = Math.max(0.0, Math.abs(docValue - this.origin) - this.offset);
            return Math.exp(0.5 * Math.pow(distance, 2.0) / this.scaling);
        }
    }

    public static final class DecayNumericExp {
        double origin;
        double offset;
        double scaling;

        public DecayNumericExp(double origin, double scale, double offset, double decay) {
            this.origin = origin;
            this.offset = offset;
            this.scaling = Math.log(decay) / scale;
        }

        public double decayNumericExp(double docValue) {
            double distance = Math.max(0.0, Math.abs(docValue - this.origin) - this.offset);
            return Math.exp(this.scaling * distance);
        }
    }

    public static final class DecayNumericLinear {
        double origin;
        double offset;
        double scaling;

        public DecayNumericLinear(double origin, double scale, double offset, double decay) {
            this.origin = origin;
            this.offset = offset;
            this.scaling = scale / (1.0 - decay);
        }

        public double decayNumericLinear(double docValue) {
            double distance = Math.max(0.0, Math.abs(docValue - this.origin) - this.offset);
            return Math.max(0.0, (this.scaling - distance) / this.scaling);
        }
    }

    public static final class DecayGeoGauss {
        double originLat;
        double originLon;
        double offset;
        double scaling;

        public DecayGeoGauss(String originStr, String scaleStr, String offsetStr, double decay) {
            GeoPoint origin = GeoUtils.parseGeoPoint(originStr, false);
            double scale = DistanceUnit.DEFAULT.parse(scaleStr, DistanceUnit.DEFAULT);
            this.originLat = origin.lat();
            this.originLon = origin.lon();
            this.offset = DistanceUnit.DEFAULT.parse(offsetStr, DistanceUnit.DEFAULT);
            this.scaling = 0.5 * Math.pow(scale, 2.0) / Math.log(decay);
        }

        public double decayGeoGauss(GeoPoint docValue) {
            double distance = GeoDistance.ARC.calculate(this.originLat, this.originLon, docValue.lat(), docValue.lon(), DistanceUnit.METERS);
            distance = Math.max(0.0, distance - this.offset);
            return Math.exp(0.5 * Math.pow(distance, 2.0) / this.scaling);
        }
    }

    public static final class DecayGeoExp {
        double originLat;
        double originLon;
        double offset;
        double scaling;

        public DecayGeoExp(String originStr, String scaleStr, String offsetStr, double decay) {
            GeoPoint origin = GeoUtils.parseGeoPoint(originStr, false);
            double scale = DistanceUnit.DEFAULT.parse(scaleStr, DistanceUnit.DEFAULT);
            this.originLat = origin.lat();
            this.originLon = origin.lon();
            this.offset = DistanceUnit.DEFAULT.parse(offsetStr, DistanceUnit.DEFAULT);
            this.scaling = Math.log(decay) / scale;
        }

        public double decayGeoExp(GeoPoint docValue) {
            double distance = GeoDistance.ARC.calculate(this.originLat, this.originLon, docValue.lat(), docValue.lon(), DistanceUnit.METERS);
            distance = Math.max(0.0, distance - this.offset);
            return Math.exp(this.scaling * distance);
        }
    }

    public static final class DecayGeoLinear {
        double originLat;
        double originLon;
        double offset;
        double scaling;

        public DecayGeoLinear(String originStr, String scaleStr, String offsetStr, double decay) {
            GeoPoint origin = GeoUtils.parseGeoPoint(originStr, false);
            double scale = DistanceUnit.DEFAULT.parse(scaleStr, DistanceUnit.DEFAULT);
            this.originLat = origin.lat();
            this.originLon = origin.lon();
            this.offset = DistanceUnit.DEFAULT.parse(offsetStr, DistanceUnit.DEFAULT);
            this.scaling = scale / (1.0 - decay);
        }

        public double decayGeoLinear(GeoPoint docValue) {
            double distance = GeoDistance.ARC.calculate(this.originLat, this.originLon, docValue.lat(), docValue.lon(), DistanceUnit.METERS);
            distance = Math.max(0.0, distance - this.offset);
            return Math.max(0.0, (this.scaling - distance) / this.scaling);
        }
    }

    public static final class RandomNotReproducible {
        private final Random rnd = Randomness.get();

        public double randomNotReproducible() {
            return this.rnd.nextDouble();
        }
    }
}

