/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestGetMappingAction
extends BaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestGetMappingAction.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);

    public RestGetMappingAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_mapping", this);
        controller.registerHandler(RestRequest.Method.GET, "/_mappings", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mappings", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mapping", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_mapping/{type}", this);
    }

    @Override
    public String getName() {
        return "get_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (request.method().equals((Object)RestRequest.Method.HEAD)) {
            deprecationLogger.deprecated("Type exists requests are deprecated, as types have been deprecated.", new Object[0]);
        }
        final boolean includeTypeName = request.paramAsBoolean("include_type_name", true);
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        final String[] types = request.paramAsStringArrayOrEmptyIfAll("type");
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        ((GetMappingsRequest)getMappingsRequest.indices(indices)).types(types);
        getMappingsRequest.indicesOptions(IndicesOptions.fromRequest(request, getMappingsRequest.indicesOptions()));
        getMappingsRequest.masterNodeTimeout(request.paramAsTime("master_timeout", getMappingsRequest.masterNodeTimeout()));
        getMappingsRequest.local(request.paramAsBoolean("local", getMappingsRequest.local()));
        return channel -> client.admin().indices().getMappings(getMappingsRequest, (ActionListener<GetMappingsResponse>)new RestBuilderListener<GetMappingsResponse>(channel){

            @Override
            public RestResponse buildResponse(GetMappingsResponse response, XContentBuilder builder) throws Exception {
                RestStatus status;
                ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappingsByIndex = response.getMappings();
                if (mappingsByIndex.isEmpty() && types.length != 0) {
                    builder.close();
                    return new BytesRestResponse(this.channel, new TypeMissingException("_all", String.join((CharSequence)",", types)));
                }
                HashSet<String> typeNames = new HashSet<String>();
                for (ObjectCursor cursor : mappingsByIndex.values()) {
                    for (ObjectCursor inner : ((ImmutableOpenMap)cursor.value).keys()) {
                        typeNames.add((String)inner.value);
                    }
                }
                SortedSet difference = Sets.sortedDifference(Arrays.stream(types).collect(Collectors.toSet()), typeNames);
                ArrayList<String> matches = new ArrayList<String>();
                block2: for (String pattern : difference) {
                    if (!pattern.contains("*")) continue;
                    for (String typeName : typeNames) {
                        if (!Regex.simpleMatch(pattern, typeName)) continue;
                        matches.add(pattern);
                        continue block2;
                    }
                }
                difference.removeAll(matches);
                builder.startObject();
                if (difference.isEmpty()) {
                    status = RestStatus.OK;
                } else {
                    status = RestStatus.NOT_FOUND;
                    String message = String.format(Locale.ROOT, "type" + (difference.size() == 1 ? "" : "s") + " [%s] missing", Strings.collectionToCommaDelimitedString(difference));
                    builder.field("error", message);
                    builder.field("status", status.getStatus());
                }
                response.toXContent(builder, ToXContent.EMPTY_PARAMS, includeTypeName);
                builder.endObject();
                return new BytesRestResponse(status, builder);
            }
        });
    }
}

