/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterGraphFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterIterator;
import org.elasticsearch.Version;
import org.elasticsearch.analysis.common.WordDelimiterTokenFilterFactory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.analysis.TokenFilterFactory;

public class WordDelimiterGraphTokenFilterFactory
extends AbstractTokenFilterFactory {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(WordDelimiterGraphTokenFilterFactory.class));
    private final byte[] charTypeTable;
    private final int flags;
    private final CharArraySet protoWords;

    public WordDelimiterGraphTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        List charTypeTableValues = Analysis.getWordList((Environment)env, (Settings)settings, (String)"type_table");
        this.charTypeTable = charTypeTableValues == null ? WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE : WordDelimiterTokenFilterFactory.parseTypes(charTypeTableValues);
        int flags = 0;
        flags |= this.getFlag(1, settings, "generate_word_parts", true);
        flags |= this.getFlag(2, settings, "generate_number_parts", true);
        flags |= this.getFlag(4, settings, "catenate_words", false);
        flags |= this.getFlag(8, settings, "catenate_numbers", false);
        flags |= this.getFlag(16, settings, "catenate_all", false);
        flags |= this.getFlag(64, settings, "split_on_case_change", true);
        flags |= this.getFlag(32, settings, "preserve_original", false);
        flags |= this.getFlag(128, settings, "split_on_numerics", true);
        CharArraySet protectedWords = Analysis.getWordSet((Environment)env, (Settings)settings, (String)"protected_words");
        this.protoWords = protectedWords == null ? null : CharArraySet.copy((Set)protectedWords);
        this.flags = flags |= this.getFlag(256, settings, "stem_english_possessive", true);
    }

    public TokenStream create(TokenStream tokenStream) {
        return new WordDelimiterGraphFilter(tokenStream, true, this.charTypeTable, this.flags, this.protoWords);
    }

    public TokenFilterFactory getSynonymFilter() {
        if (this.indexSettings.getIndexVersionCreated().onOrAfter(Version.V_7_0_0)) {
            throw new IllegalArgumentException("Token filter [" + this.name() + "] cannot be used to parse synonyms");
        }
        DEPRECATION_LOGGER.deprecatedAndMaybeLog("synonym_tokenfilters", "Token filter [" + this.name() + "] will not be usable to parse synonyms after v7.0", new Object[0]);
        return this;
    }

    private int getFlag(int flag, Settings settings, String key, boolean defaultValue) {
        if (settings.getAsBoolean(key, Boolean.valueOf(defaultValue)).booleanValue()) {
            return flag;
        }
        return 0;
    }
}

