/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PointInSetQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.FixedBitSet;

abstract class PointInSetIncludingScoreQuery
extends Query {
    static BiFunction<byte[], Class<? extends Number>, String> toString = (value, numericType) -> {
        if (Integer.class.equals(numericType)) {
            return Integer.toString(IntPoint.decodeDimension((byte[])value, (int)0));
        }
        if (Long.class.equals(numericType)) {
            return Long.toString(LongPoint.decodeDimension((byte[])value, (int)0));
        }
        if (Float.class.equals(numericType)) {
            return Float.toString(FloatPoint.decodeDimension((byte[])value, (int)0));
        }
        if (Double.class.equals(numericType)) {
            return Double.toString(DoublePoint.decodeDimension((byte[])value, (int)0));
        }
        return "unsupported";
    };
    final ScoreMode scoreMode;
    final Query originalQuery;
    final boolean multipleValuesPerDocument;
    final PrefixCodedTerms sortedPackedPoints;
    final int sortedPackedPointsHashCode;
    final String field;
    final int bytesPerDim;
    final List<Float> aggregatedJoinScores;

    PointInSetIncludingScoreQuery(ScoreMode scoreMode, Query originalQuery, boolean multipleValuesPerDocument, String field, int bytesPerDim, Stream packedPoints) {
        BytesRef current;
        this.scoreMode = scoreMode;
        this.originalQuery = originalQuery;
        this.multipleValuesPerDocument = multipleValuesPerDocument;
        this.field = field;
        if (bytesPerDim < 1 || bytesPerDim > 16) {
            throw new IllegalArgumentException("bytesPerDim must be > 0 and <= 16; got " + bytesPerDim);
        }
        this.bytesPerDim = bytesPerDim;
        this.aggregatedJoinScores = new ArrayList<Float>();
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        BytesRefBuilder previous = null;
        while ((current = packedPoints.next()) != null) {
            if (current.length != bytesPerDim) {
                throw new IllegalArgumentException("packed point length should be " + bytesPerDim + " but got " + current.length + "; field=\"" + field + "\"bytesPerDim=" + bytesPerDim);
            }
            if (previous == null) {
                previous = new BytesRefBuilder();
            } else {
                int cmp = previous.get().compareTo(current);
                if (cmp == 0) {
                    throw new IllegalArgumentException("unexpected duplicated value: " + current);
                }
                if (cmp >= 0) {
                    throw new IllegalArgumentException("values are out of order: saw " + previous + " before " + current);
                }
            }
            builder.add(field, current);
            this.aggregatedJoinScores.add(Float.valueOf(packedPoints.score));
            previous.copyBytes(current);
        }
        this.sortedPackedPoints = builder.finish();
        this.sortedPackedPointsHashCode = this.sortedPackedPoints.hashCode();
    }

    public final Weight createWeight(IndexSearcher searcher, org.apache.lucene.search.ScoreMode scoreMode, float boost) throws IOException {
        return new Weight(this){

            public void extractTerms(Set<Term> terms) {
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                int target;
                Scorer scorer = this.scorer(context);
                if (scorer != null && doc == (target = scorer.iterator().advance(doc))) {
                    return Explanation.match((Number)Float.valueOf(scorer.score()), (String)"A match", (Explanation[])new Explanation[0]);
                }
                return Explanation.noMatch((String)"Not a match", (Explanation[])new Explanation[0]);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(PointInSetIncludingScoreQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                if (fieldInfo.getPointDataDimensionCount() != 1) {
                    throw new IllegalArgumentException("field=\"" + PointInSetIncludingScoreQuery.this.field + "\" was indexed with numDims=" + fieldInfo.getPointDataDimensionCount() + " but this query has numDims=1");
                }
                if (fieldInfo.getPointNumBytes() != PointInSetIncludingScoreQuery.this.bytesPerDim) {
                    throw new IllegalArgumentException("field=\"" + PointInSetIncludingScoreQuery.this.field + "\" was indexed with bytesPerDim=" + fieldInfo.getPointNumBytes() + " but this query has bytesPerDim=" + PointInSetIncludingScoreQuery.this.bytesPerDim);
                }
                PointValues values = reader.getPointValues(PointInSetIncludingScoreQuery.this.field);
                if (values == null) {
                    return null;
                }
                final FixedBitSet result = new FixedBitSet(reader.maxDoc());
                final float[] scores = new float[reader.maxDoc()];
                values.intersect((PointValues.IntersectVisitor)new MergePointVisitor(PointInSetIncludingScoreQuery.this.sortedPackedPoints, result, scores));
                return new Scorer(this){
                    DocIdSetIterator disi;
                    {
                        super(arg0);
                        this.disi = new BitSetIterator((BitSet)result, 10L);
                    }

                    public float score() throws IOException {
                        return scores[this.docID()];
                    }

                    public float getMaxScore(int upTo) throws IOException {
                        return Float.POSITIVE_INFINITY;
                    }

                    public int docID() {
                        return this.disi.docID();
                    }

                    public DocIdSetIterator iterator() {
                        return this.disi;
                    }
                };
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public final int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.scoreMode.hashCode();
        hash = 31 * hash + this.field.hashCode();
        hash = 31 * hash + this.originalQuery.hashCode();
        hash = 31 * hash + this.sortedPackedPointsHashCode;
        hash = 31 * hash + this.bytesPerDim;
        return hash;
    }

    public final boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((PointInSetIncludingScoreQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(PointInSetIncludingScoreQuery other) {
        return other.scoreMode.equals((Object)this.scoreMode) && other.field.equals(this.field) && other.originalQuery.equals((Object)this.originalQuery) && other.bytesPerDim == this.bytesPerDim && other.sortedPackedPointsHashCode == this.sortedPackedPointsHashCode && other.sortedPackedPoints.equals((Object)this.sortedPackedPoints);
    }

    public final String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("{");
        PrefixCodedTerms.TermIterator iterator = this.sortedPackedPoints.iterator();
        byte[] pointBytes = new byte[this.bytesPerDim];
        boolean first = true;
        BytesRef point = iterator.next();
        while (point != null) {
            if (!first) {
                sb.append(" ");
            }
            first = false;
            System.arraycopy(point.bytes, point.offset, pointBytes, 0, pointBytes.length);
            sb.append(this.toString(pointBytes));
            point = iterator.next();
        }
        sb.append("}");
        return sb.toString();
    }

    protected abstract String toString(byte[] var1);

    private class MergePointVisitor
    implements PointValues.IntersectVisitor {
        private final FixedBitSet result;
        private final float[] scores;
        private PrefixCodedTerms.TermIterator iterator;
        private Iterator<Float> scoreIterator;
        private BytesRef nextQueryPoint;
        float nextScore;
        private final BytesRef scratch = new BytesRef();

        private MergePointVisitor(PrefixCodedTerms sortedPackedPoints, FixedBitSet result, float[] scores) throws IOException {
            this.result = result;
            this.scores = scores;
            this.scratch.length = PointInSetIncludingScoreQuery.this.bytesPerDim;
            this.iterator = sortedPackedPoints.iterator();
            this.scoreIterator = PointInSetIncludingScoreQuery.this.aggregatedJoinScores.iterator();
            this.nextQueryPoint = this.iterator.next();
            if (this.scoreIterator.hasNext()) {
                this.nextScore = this.scoreIterator.next().floatValue();
            }
        }

        public void visit(int docID) {
            throw new IllegalStateException("shouldn't get here, since CELL_INSIDE_QUERY isn't emitted");
        }

        public void visit(int docID, byte[] packedValue) {
            this.scratch.bytes = packedValue;
            while (this.nextQueryPoint != null) {
                int cmp = this.nextQueryPoint.compareTo(this.scratch);
                if (cmp == 0) {
                    if (PointInSetIncludingScoreQuery.this.multipleValuesPerDocument) {
                        if (this.result.get(docID)) break;
                        this.result.set(docID);
                        this.scores[docID] = this.nextScore;
                        break;
                    }
                    this.result.set(docID);
                    this.scores[docID] = this.nextScore;
                    break;
                }
                if (cmp >= 0) break;
                this.nextQueryPoint = this.iterator.next();
                if (!this.scoreIterator.hasNext()) continue;
                this.nextScore = this.scoreIterator.next().floatValue();
            }
        }

        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            while (this.nextQueryPoint != null) {
                this.scratch.bytes = minPackedValue;
                int cmpMin = this.nextQueryPoint.compareTo(this.scratch);
                if (cmpMin < 0) {
                    this.nextQueryPoint = this.iterator.next();
                    if (!this.scoreIterator.hasNext()) continue;
                    this.nextScore = this.scoreIterator.next().floatValue();
                    continue;
                }
                this.scratch.bytes = maxPackedValue;
                int cmpMax = this.nextQueryPoint.compareTo(this.scratch);
                if (cmpMax > 0) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
    }

    static abstract class Stream
    extends PointInSetQuery.Stream {
        float score;

        Stream() {
        }
    }
}

