/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorable;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lucene.ScorerAware;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.ParameterMap;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;

abstract class AbstractSortScript
implements ScorerAware {
    private static final Map<String, String> DEPRECATIONS;
    private final Map<String, Object> params;
    private Scorable scorer;
    private final LeafSearchLookup leafLookup;

    AbstractSortScript(Map<String, Object> params, SearchLookup lookup, LeafReaderContext leafContext) {
        this.leafLookup = lookup.getLeafSearchLookup(leafContext);
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        parameters.putAll(this.leafLookup.asMap());
        this.params = new ParameterMap(parameters, DEPRECATIONS);
    }

    protected AbstractSortScript() {
        this.params = null;
        this.leafLookup = null;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    @Override
    public void setScorer(Scorable scorer) {
        this.scorer = scorer;
    }

    public double get_score() {
        try {
            return this.scorer.score();
        }
        catch (IOException e) {
            throw new ElasticsearchException("couldn't lookup score", (Throwable)e, new Object[0]);
        }
    }

    public Map<String, ScriptDocValues<?>> getDoc() {
        return this.leafLookup.doc();
    }

    public void setDocument(int docid) {
        this.leafLookup.setDocument(docid);
    }

    static {
        HashMap<String, String> deprecations = new HashMap<String, String>();
        deprecations.put("doc", "Accessing variable [doc] via [params.doc] from within a sort-script is deprecated in favor of directly accessing [doc].");
        deprecations.put("_doc", "Accessing variable [doc] via [params._doc] from within a sort-script is deprecated in favor of directly accessing [doc].");
        DEPRECATIONS = Collections.unmodifiableMap(deprecations);
    }
}

