/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestGetAliasesAction
extends BaseRestHandler {
    public RestGetAliasesAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_alias", this);
        controller.registerHandler(RestRequest.Method.GET, "/_aliases", this);
        controller.registerHandler(RestRequest.Method.GET, "/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_alias", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/_alias", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/_alias/{name}", this);
    }

    @Override
    public String getName() {
        return "get_aliases_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        final boolean namesProvided = request.hasParam("name");
        final String[] aliases = request.paramAsStringArrayOrEmptyIfAll("name");
        GetAliasesRequest getAliasesRequest = new GetAliasesRequest(aliases);
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        getAliasesRequest.indices(indices);
        getAliasesRequest.indicesOptions(IndicesOptions.fromRequest(request, getAliasesRequest.indicesOptions()));
        getAliasesRequest.local(request.paramAsBoolean("local", getAliasesRequest.local()));
        return channel -> client.admin().indices().getAliases(getAliasesRequest, (ActionListener<GetAliasesResponse>)new RestBuilderListener<GetAliasesResponse>(channel){

            @Override
            public RestResponse buildResponse(GetAliasesResponse response, XContentBuilder builder) throws Exception {
                RestStatus status;
                ImmutableOpenMap<String, List<AliasMetaData>> aliasMap = response.getAliases();
                HashSet<String> aliasNames = new HashSet<String>();
                HashSet<String> indicesToDisplay = new HashSet<String>();
                for (ObjectObjectCursor<String, List<AliasMetaData>> objectObjectCursor : aliasMap) {
                    for (AliasMetaData aliasMetaData : (List)objectObjectCursor.value) {
                        aliasNames.add(aliasMetaData.alias());
                        if (!namesProvided) continue;
                        indicesToDisplay.add((String)objectObjectCursor.key);
                    }
                }
                SortedSet<String> difference = Sets.sortedDifference(Arrays.stream(aliases).collect(Collectors.toSet()), aliasNames);
                ArrayList<String> arrayList = new ArrayList<String>();
                block2: for (String pattern : difference) {
                    if (!pattern.contains("*")) continue;
                    for (String aliasName : aliasNames) {
                        if (!Regex.simpleMatch(pattern, aliasName)) continue;
                        arrayList.add(pattern);
                        continue block2;
                    }
                }
                difference.removeAll(arrayList);
                builder.startObject();
                if (difference.isEmpty()) {
                    status = RestStatus.OK;
                } else {
                    status = RestStatus.NOT_FOUND;
                    String message = difference.size() == 1 ? String.format(Locale.ROOT, "alias [%s] missing", Strings.collectionToCommaDelimitedString(difference)) : String.format(Locale.ROOT, "aliases [%s] missing", Strings.collectionToCommaDelimitedString(difference));
                    builder.field("error", message);
                    builder.field("status", status.getStatus());
                }
                for (ObjectObjectCursor<String, List<AliasMetaData>> objectObjectCursor : response.getAliases()) {
                    if (namesProvided && (!namesProvided || !indicesToDisplay.contains(objectObjectCursor.key))) continue;
                    builder.startObject((String)objectObjectCursor.key);
                    builder.startObject("aliases");
                    for (AliasMetaData alias : (List)objectObjectCursor.value) {
                        AliasMetaData.Builder.toXContent(alias, builder, ToXContent.EMPTY_PARAMS);
                    }
                    builder.endObject();
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(status, builder);
            }
        });
    }
}

