/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.shard.ShardId;

public class DeleteRequest
extends ReplicatedWriteRequest<DeleteRequest>
implements DocWriteRequest<DeleteRequest>,
CompositeIndicesRequest {
    private String type = "_doc";
    private String id;
    @Nullable
    private String routing;
    private long version = -3L;
    private VersionType versionType = VersionType.INTERNAL;

    public DeleteRequest() {
    }

    public DeleteRequest(String index) {
        this.index = index;
    }

    @Deprecated
    public DeleteRequest(String index, String type, String id) {
        this.index = index;
        this.type = type;
        this.id = id;
    }

    public DeleteRequest(String index, String id) {
        this.index = index;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (Strings.isEmpty(this.type)) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (Strings.isEmpty(this.id)) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        if (!this.versionType.validateVersionForWrites(this.version)) {
            validationException = ValidateActions.addValidationError("illegal version value [" + this.version + "] for version type [" + this.versionType.name() + "]", validationException);
        }
        if (this.versionType == VersionType.FORCE) {
            validationException = ValidateActions.addValidationError("version type [force] may no longer be used", validationException);
        }
        return validationException;
    }

    @Override
    @Deprecated
    public String type() {
        return this.type;
    }

    @Override
    @Deprecated
    public DeleteRequest type(String type) {
        this.type = type;
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    public DeleteRequest id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public DeleteRequest routing(String routing) {
        this.routing = routing != null && routing.length() == 0 ? null : routing;
        return this;
    }

    @Override
    public String routing() {
        return this.routing;
    }

    @Override
    public DeleteRequest version(long version) {
        this.version = version;
        return this;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public DeleteRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    @Override
    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public DocWriteRequest.OpType opType() {
        return DocWriteRequest.OpType.DELETE;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.type = in.readString();
        this.id = in.readString();
        this.routing = in.readOptionalString();
        if (in.getVersion().before(Version.V_7_0_0)) {
            in.readOptionalString();
        }
        this.version = in.readLong();
        this.versionType = VersionType.fromValue(in.readByte());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeOptionalString(this.routing());
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeOptionalString(null);
        }
        out.writeLong(this.version);
        out.writeByte(this.versionType.getValue());
    }

    @Override
    public String toString() {
        return "delete {[" + this.index + "][" + this.type + "][" + this.id + "]}";
    }

    @Override
    public DeleteRequest setShardId(ShardId shardId) {
        throw new UnsupportedOperationException("shard id should never be set on DeleteRequest");
    }
}

