/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.bootstrap;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.cluster.bootstrap.BootstrapConfiguration;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetDiscoveredNodesResponse
extends ActionResponse {
    private final Set<DiscoveryNode> nodes;

    public GetDiscoveredNodesResponse(Set<DiscoveryNode> nodes) {
        this.nodes = Collections.unmodifiableSet(new HashSet<DiscoveryNode>(nodes));
    }

    public GetDiscoveredNodesResponse(StreamInput in) throws IOException {
        super(in);
        this.nodes = Collections.unmodifiableSet(in.readSet(DiscoveryNode::new));
    }

    public Set<DiscoveryNode> getNodes() {
        return this.nodes;
    }

    public BootstrapConfiguration getBootstrapConfiguration() {
        return new BootstrapConfiguration(this.nodes.stream().map(BootstrapConfiguration.NodeDescription::new).collect(Collectors.toList()));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeCollection(this.nodes, (o, v) -> v.writeTo(o));
    }
}

