/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.QueryShardContext;

public class FeatureVectorFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "feature_vector";

    private FeatureVectorFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        assert (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) <= 0);
    }

    protected FeatureVectorFieldMapper clone() {
        return (FeatureVectorFieldMapper)super.clone();
    }

    public FeatureVectorFieldType fieldType() {
        return (FeatureVectorFieldType)super.fieldType();
    }

    public void parse(ParseContext context) throws IOException {
        if (context.externalValueSet()) {
            throw new IllegalArgumentException("[feature_vector] fields can't be used in multi-fields");
        }
        if (context.parser().currentToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("[feature_vector] fields must be json objects, expected a START_OBJECT but got: " + context.parser().currentToken());
        }
        String feature = null;
        XContentParser.Token token = context.parser().nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                feature = context.parser().currentName();
            } else if (token != XContentParser.Token.VALUE_NULL) {
                if (token == XContentParser.Token.VALUE_NUMBER || token == XContentParser.Token.VALUE_STRING) {
                    String key = this.name() + "." + feature;
                    float value = context.parser().floatValue(true);
                    if (context.doc().getByKey((Object)key) != null) {
                        throw new IllegalArgumentException("[feature_vector] fields do not support indexing multiple values for the same feature [" + key + "] in the same document");
                    }
                    context.doc().addWithKey((Object)key, (IndexableField)new FeatureField(this.name(), feature, value));
                } else {
                    throw new IllegalArgumentException("[feature_vector] fields take hashes that map a feature to a strictly positive float, but got unexpected token " + token);
                }
            }
            token = context.parser().nextToken();
        }
    }

    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class FeatureVectorFieldType
    extends MappedFieldType {
        public FeatureVectorFieldType() {
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        protected FeatureVectorFieldType(FeatureVectorFieldType ref) {
            super((MappedFieldType)ref);
        }

        public FeatureVectorFieldType clone() {
            return new FeatureVectorFieldType(this);
        }

        public String typeName() {
            return FeatureVectorFieldMapper.CONTENT_TYPE;
        }

        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException("[feature_vector] fields do not support [exists] queries");
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            throw new UnsupportedOperationException("[feature_vector] fields do not support sorting, scripting or aggregating");
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new UnsupportedOperationException("Queries on [feature_vector] fields are not supported");
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, FeatureVectorFieldMapper> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public FeatureVectorFieldType fieldType() {
            return (FeatureVectorFieldType)super.fieldType();
        }

        public FeatureVectorFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new FeatureVectorFieldMapper(this.name, this.fieldType, this.defaultFieldType, context.indexSettings(), this.multiFieldsBuilder.build((FieldMapper.Builder)this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new FeatureVectorFieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setHasDocValues(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

