/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterMatchesIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafSimScorer;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.IntervalScorer;
import org.apache.lucene.search.intervals.IntervalsSource;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.ArrayUtil;

public final class IntervalQuery
extends Query {
    private final String field;
    private final IntervalsSource intervalsSource;

    public IntervalQuery(String field, IntervalsSource intervalsSource) {
        this.field = field;
        this.intervalsSource = intervalsSource;
    }

    public String getField() {
        return this.field;
    }

    public String toString(String field) {
        return this.intervalsSource.toString();
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new IntervalWeight(this, scoreMode.needsScores() ? this.buildSimScorer(searcher, boost) : null, searcher.getSimilarity(), scoreMode);
    }

    private Similarity.SimScorer buildSimScorer(IndexSearcher searcher, float boost) throws IOException {
        HashSet<Term> terms = new HashSet<Term>();
        this.intervalsSource.extractTerms(this.field, terms);
        Object[] termStats = new TermStatistics[terms.size()];
        int termUpTo = 0;
        for (Term term : terms) {
            TermStatistics termStatistics = searcher.termStatistics(term, TermStates.build((IndexReaderContext)searcher.getTopReaderContext(), (Term)term, (boolean)true));
            if (termStatistics == null) continue;
            termStats[termUpTo++] = termStatistics;
        }
        if (termUpTo == 0) {
            return null;
        }
        CollectionStatistics collectionStats = searcher.collectionStatistics(this.field);
        return searcher.getSimilarity().scorer(boost, collectionStats, (TermStatistics[])ArrayUtil.copyOfSubArray((Object[])termStats, (int)0, (int)termUpTo));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IntervalQuery that = (IntervalQuery)((Object)o);
        return Objects.equals(this.field, that.field) && Objects.equals(this.intervalsSource, that.intervalsSource);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.intervalsSource);
    }

    private class IntervalWeight
    extends Weight {
        final Similarity.SimScorer simScorer;
        final Similarity similarity;
        final ScoreMode scoreMode;

        public IntervalWeight(Query query, Similarity.SimScorer simScorer, Similarity similarity, ScoreMode scoreMode) {
            super(query);
            this.simScorer = simScorer;
            this.similarity = similarity;
            this.scoreMode = scoreMode;
        }

        public void extractTerms(Set<Term> terms) {
            IntervalQuery.this.intervalsSource.extractTerms(IntervalQuery.this.field, terms);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            IntervalScorer scorer = (IntervalScorer)this.scorer(context);
            if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                return scorer.explain("weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "]");
            }
            return Explanation.noMatch((String)"no matching intervals", (Explanation[])new Explanation[0]);
        }

        public Matches matches(LeafReaderContext context, int doc) throws IOException {
            return MatchesUtils.forField((String)IntervalQuery.this.field, () -> {
                MatchesIterator mi = IntervalQuery.this.intervalsSource.matches(IntervalQuery.this.field, context, doc);
                if (mi == null) {
                    return null;
                }
                return new FilterMatchesIterator(mi){

                    public Query getQuery() {
                        return new IntervalQuery(IntervalQuery.this.field, IntervalQuery.this.intervalsSource);
                    }
                };
            });
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            IntervalIterator intervals = IntervalQuery.this.intervalsSource.intervals(IntervalQuery.this.field, context);
            if (intervals == null) {
                return null;
            }
            LeafSimScorer leafScorer = this.simScorer == null ? null : new LeafSimScorer(this.simScorer, context.reader(), IntervalQuery.this.field, this.scoreMode.needsScores());
            return new IntervalScorer(this, intervals, leafScorer);
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }
    }
}

