/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tools.launchers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class JvmErgonomics {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private static final Pattern MAX_HEAP_SIZE = Pattern.compile("^(-Xmx|-XX:MaxHeapSize=)(?<size>\\d+)(?<unit>\\w)?$");
    private static final Pattern SYSTEM_PROPERTY = Pattern.compile("^-D(?<key>[\\w+].*?)=(?<value>.*)$");

    private JvmErgonomics() {
        throw new AssertionError((Object)"No instances intended");
    }

    static List<String> choose(List<String> userDefinedJvmOptions) {
        ArrayList<String> ergonomicChoices = new ArrayList<String>();
        Long heapSize = JvmErgonomics.extractHeapSize(userDefinedJvmOptions);
        Map<String, String> systemProperties = JvmErgonomics.extractSystemProperties(userDefinedJvmOptions);
        if (heapSize != null && !systemProperties.containsKey("io.netty.allocator.type")) {
            if (heapSize <= 0x40000000L) {
                ergonomicChoices.add("-Dio.netty.allocator.type=unpooled");
            } else {
                ergonomicChoices.add("-Dio.netty.allocator.type=pooled");
            }
        }
        return ergonomicChoices;
    }

    static Long extractHeapSize(List<String> userDefinedJvmOptions) {
        for (String jvmOption : userDefinedJvmOptions) {
            Matcher matcher = MAX_HEAP_SIZE.matcher(jvmOption);
            if (!matcher.matches()) continue;
            long size = Long.parseLong(matcher.group("size"));
            String unit = matcher.group("unit");
            if (unit == null) {
                return size;
            }
            switch (unit.toLowerCase(Locale.ROOT)) {
                case "k": {
                    return size * 1024L;
                }
                case "m": {
                    return size * 0x100000L;
                }
                case "g": {
                    return size * 0x40000000L;
                }
            }
            throw new IllegalArgumentException("Unknown unit [" + unit + "] for max heap size in [" + jvmOption + "]");
        }
        return null;
    }

    static Map<String, String> extractSystemProperties(List<String> userDefinedJvmOptions) {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        for (String jvmOption : userDefinedJvmOptions) {
            Matcher matcher = SYSTEM_PROPERTY.matcher(jvmOption);
            if (!matcher.matches()) continue;
            systemProperties.put(matcher.group("key"), matcher.group("value"));
        }
        return systemProperties;
    }
}

