/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.transport.RemoteConnectionInfo;

public final class RemoteInfoResponse
extends ActionResponse
implements ToXContentObject {
    private List<RemoteConnectionInfo> infos;

    RemoteInfoResponse() {
    }

    RemoteInfoResponse(Collection<RemoteConnectionInfo> infos) {
        this.infos = Collections.unmodifiableList(new ArrayList<RemoteConnectionInfo>(infos));
    }

    public List<RemoteConnectionInfo> getInfos() {
        return this.infos;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeList(this.infos);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.infos = in.readList(RemoteConnectionInfo::new);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (RemoteConnectionInfo info : this.infos) {
            info.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }
}

