/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.script.DeprecationMap;
import org.elasticsearch.script.ScriptContext;

public abstract class UpdateScript {
    public static final String[] PARAMETERS = new String[0];
    private static final Map<String, String> DEPRECATIONS;
    public static final ScriptContext<Factory> CONTEXT;
    private final Map<String, Object> params;
    private final Map<String, Object> ctx;

    public UpdateScript(Map<String, Object> params, Map<String, Object> ctx) {
        HashMap<String, Object> paramsWithCtx = new HashMap<String, Object>(params);
        paramsWithCtx.put("ctx", ctx);
        this.params = new DeprecationMap(paramsWithCtx, DEPRECATIONS);
        this.ctx = ctx;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Map<String, Object> getCtx() {
        return this.ctx;
    }

    public abstract void execute();

    static {
        HashMap<String, String> deprecations = new HashMap<String, String>();
        deprecations.put("ctx", "Accessing variable [ctx] via [params.ctx] from within a update script is deprecated in favor of directly accessing [ctx].");
        DEPRECATIONS = Collections.unmodifiableMap(deprecations);
        CONTEXT = new ScriptContext<Factory>("update", Factory.class);
    }

    public static interface Factory {
        public UpdateScript newInstance(Map<String, Object> var1, Map<String, Object> var2);
    }
}

