/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.search.ConjunctionDISI;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

class ConjunctionScorer
extends Scorer {
    final DocIdSetIterator disi;
    final Scorer[] scorers;
    final Collection<Scorer> required;

    ConjunctionScorer(Weight weight, Collection<Scorer> required, Collection<Scorer> scorers) {
        super(weight);
        assert (required.containsAll(scorers));
        this.disi = ConjunctionDISI.intersectScorers(required);
        this.scorers = scorers.toArray(new Scorer[scorers.size()]);
        this.required = required;
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return TwoPhaseIterator.unwrap(this.disi);
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.disi;
    }

    @Override
    public int docID() {
        return this.disi.docID();
    }

    @Override
    public float score() throws IOException {
        double sum = 0.0;
        for (Scorer scorer : this.scorers) {
            sum += (double)scorer.score();
        }
        return (float)sum;
    }

    @Override
    public Collection<Scorer.ChildScorer> getChildren() {
        ArrayList<Scorer.ChildScorer> children = new ArrayList<Scorer.ChildScorer>();
        for (Scorer scorer : this.required) {
            children.add(new Scorer.ChildScorer(scorer, "MUST"));
        }
        return children;
    }

    static final class DocsAndFreqs {
        final long cost;
        final DocIdSetIterator iterator;
        int doc = -1;

        DocsAndFreqs(DocIdSetIterator iterator) {
            this.iterator = iterator;
            this.cost = iterator.cost();
        }
    }
}

