/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.search.BooleanQuery;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.NamedRegistry;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.ShapesAvailability;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ParseFieldRegistry;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.BoostingQueryBuilder;
import org.elasticsearch.index.query.CommonTermsQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.DisMaxQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.FieldMaskingSpanQueryBuilder;
import org.elasticsearch.index.query.FuzzyQueryBuilder;
import org.elasticsearch.index.query.GeoBoundingBoxQueryBuilder;
import org.elasticsearch.index.query.GeoDistanceQueryBuilder;
import org.elasticsearch.index.query.GeoPolygonQueryBuilder;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.MatchPhrasePrefixQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.RegexpQueryBuilder;
import org.elasticsearch.index.query.ScriptQueryBuilder;
import org.elasticsearch.index.query.SimpleQueryStringBuilder;
import org.elasticsearch.index.query.SpanContainingQueryBuilder;
import org.elasticsearch.index.query.SpanFirstQueryBuilder;
import org.elasticsearch.index.query.SpanMultiTermQueryBuilder;
import org.elasticsearch.index.query.SpanNearQueryBuilder;
import org.elasticsearch.index.query.SpanNotQueryBuilder;
import org.elasticsearch.index.query.SpanOrQueryBuilder;
import org.elasticsearch.index.query.SpanTermQueryBuilder;
import org.elasticsearch.index.query.SpanWithinQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.TermsSetQueryBuilder;
import org.elasticsearch.index.query.TypeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.index.query.WrapperQueryBuilder;
import org.elasticsearch.index.query.functionscore.ExponentialDecayFunctionBuilder;
import org.elasticsearch.index.query.functionscore.FieldValueFactorFunctionBuilder;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.index.query.functionscore.GaussDecayFunctionBuilder;
import org.elasticsearch.index.query.functionscore.LinearDecayFunctionBuilder;
import org.elasticsearch.index.query.functionscore.RandomScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionParser;
import org.elasticsearch.index.query.functionscore.ScriptScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.WeightBuilder;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchExtBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BaseAggregationBuilder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.adjacency.AdjacencyMatrixAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.adjacency.InternalAdjacencyMatrix;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.InternalComposite;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilter;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilters;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoGridAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoHashGrid;
import org.elasticsearch.search.aggregations.bucket.global.GlobalAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.global.InternalGlobal;
import org.elasticsearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalAutoDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.elasticsearch.search.aggregations.bucket.missing.InternalMissing;
import org.elasticsearch.search.aggregations.bucket.missing.MissingAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.nested.InternalNested;
import org.elasticsearch.search.aggregations.bucket.nested.InternalReverseNested;
import org.elasticsearch.search.aggregations.bucket.nested.NestedAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.nested.ReverseNestedAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.DateRangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.GeoDistanceAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.InternalBinaryRange;
import org.elasticsearch.search.aggregations.bucket.range.InternalDateRange;
import org.elasticsearch.search.aggregations.bucket.range.InternalGeoDistance;
import org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.elasticsearch.search.aggregations.bucket.range.IpRangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.sampler.InternalSampler;
import org.elasticsearch.search.aggregations.bucket.sampler.SamplerAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.sampler.UnmappedSampler;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantLongTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTextAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.significant.UnmappedSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.ChiSquare;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.GND;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.JLHScore;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.MutualInformation;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.PercentageScore;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.ScriptHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParser;
import org.elasticsearch.search.aggregations.bucket.terms.DoubleTerms;
import org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.elasticsearch.search.aggregations.metrics.avg.AvgAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.avg.InternalAvg;
import org.elasticsearch.search.aggregations.metrics.cardinality.CardinalityAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.cardinality.InternalCardinality;
import org.elasticsearch.search.aggregations.metrics.geobounds.GeoBoundsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.geobounds.InternalGeoBounds;
import org.elasticsearch.search.aggregations.metrics.geocentroid.GeoCentroidAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.geocentroid.InternalGeoCentroid;
import org.elasticsearch.search.aggregations.metrics.max.InternalMax;
import org.elasticsearch.search.aggregations.metrics.max.MaxAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.min.InternalMin;
import org.elasticsearch.search.aggregations.metrics.min.MinAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentileRanksAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.hdr.InternalHDRPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.percentiles.hdr.InternalHDRPercentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.InternalTDigestPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.InternalTDigestPercentiles;
import org.elasticsearch.search.aggregations.metrics.scripted.InternalScriptedMetric;
import org.elasticsearch.search.aggregations.metrics.scripted.ScriptedMetricAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.stats.InternalStats;
import org.elasticsearch.search.aggregations.metrics.stats.StatsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.stats.extended.ExtendedStatsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.stats.extended.InternalExtendedStats;
import org.elasticsearch.search.aggregations.metrics.sum.InternalSum;
import org.elasticsearch.search.aggregations.metrics.sum.SumAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.tophits.InternalTopHits;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHitsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.valuecount.InternalValueCount;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCountAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.weighted_avg.InternalWeightedAvg;
import org.elasticsearch.search.aggregations.metrics.weighted_avg.WeightedAvgAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.InternalBucketMetricValue;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.avg.AvgBucketPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.avg.AvgBucketPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.max.MaxBucketPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.max.MaxBucketPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.min.MinBucketPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.min.MinBucketPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile.InternalPercentilesBucket;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile.PercentilesBucketPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile.PercentilesBucketPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.InternalStatsBucket;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.StatsBucketPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.StatsBucketPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.extended.ExtendedStatsBucketParser;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.extended.ExtendedStatsBucketPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.extended.ExtendedStatsBucketPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.extended.InternalExtendedStatsBucket;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.sum.SumBucketPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.sum.SumBucketPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.bucketscript.BucketScriptPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.bucketscript.BucketScriptPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.bucketselector.BucketSelectorPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.bucketselector.BucketSelectorPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.bucketsort.BucketSortPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.bucketsort.BucketSortPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.cumulativesum.CumulativeSumPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.cumulativesum.CumulativeSumPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.derivative.DerivativePipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.derivative.DerivativePipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.derivative.InternalDerivative;
import org.elasticsearch.search.aggregations.pipeline.movavg.MovAvgPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.movavg.MovAvgPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.EwmaModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.HoltLinearModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.HoltWintersModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.LinearModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.SimpleModel;
import org.elasticsearch.search.aggregations.pipeline.movfn.MovFnPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.movfn.MovFnPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.serialdiff.SerialDiffPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.serialdiff.SerialDiffPipelineAggregator;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.DocValueFieldsFetchSubPhase;
import org.elasticsearch.search.fetch.subphase.ExplainFetchSubPhase;
import org.elasticsearch.search.fetch.subphase.FetchSourceSubPhase;
import org.elasticsearch.search.fetch.subphase.MatchedQueriesFetchSubPhase;
import org.elasticsearch.search.fetch.subphase.ParentFieldSubFetchPhase;
import org.elasticsearch.search.fetch.subphase.ScriptFieldsFetchSubPhase;
import org.elasticsearch.search.fetch.subphase.VersionFetchSubPhase;
import org.elasticsearch.search.fetch.subphase.highlight.FastVectorHighlighter;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightPhase;
import org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.elasticsearch.search.fetch.subphase.highlight.PlainHighlighter;
import org.elasticsearch.search.fetch.subphase.highlight.UnifiedHighlighter;
import org.elasticsearch.search.rescore.QueryRescorerBuilder;
import org.elasticsearch.search.rescore.RescorerBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionBuilder;
import org.elasticsearch.search.suggest.phrase.Laplace;
import org.elasticsearch.search.suggest.phrase.LinearInterpolation;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestionBuilder;
import org.elasticsearch.search.suggest.phrase.SmoothingModel;
import org.elasticsearch.search.suggest.phrase.StupidBackoff;
import org.elasticsearch.search.suggest.term.TermSuggestionBuilder;

public class SearchModule {
    public static final Setting<Integer> INDICES_MAX_CLAUSE_COUNT_SETTING = Setting.intSetting("indices.query.bool.max_clause_count", 1024, 1, Integer.MAX_VALUE, Setting.Property.NodeScope);
    private final boolean transportClient;
    private final Map<String, Highlighter> highlighters;
    private final ParseFieldRegistry<SignificanceHeuristicParser> significanceHeuristicParserRegistry = new ParseFieldRegistry("significance_heuristic");
    private final ParseFieldRegistry<MovAvgModel.AbstractModelParser> movingAverageModelParserRegistry = new ParseFieldRegistry("moving_avg_model");
    private final List<FetchSubPhase> fetchSubPhases = new ArrayList<FetchSubPhase>();
    private final Settings settings;
    private final List<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();
    private final List<NamedXContentRegistry.Entry> namedXContents = new ArrayList<NamedXContentRegistry.Entry>();

    public SearchModule(Settings settings, boolean transportClient, List<SearchPlugin> plugins) {
        this.settings = settings;
        this.transportClient = transportClient;
        this.registerSuggesters(plugins);
        this.highlighters = this.setupHighlighters(settings, plugins);
        this.registerScoreFunctions(plugins);
        this.registerQueryParsers(plugins);
        this.registerRescorers(plugins);
        this.registerSorts();
        this.registerValueFormats();
        this.registerSignificanceHeuristics(plugins);
        this.registerMovingAverageModels(plugins);
        this.registerAggregations(plugins);
        this.registerPipelineAggregations(plugins);
        this.registerFetchSubPhases(plugins);
        this.registerSearchExts(plugins);
        this.registerShapes();
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return this.namedWriteables;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContents() {
        return this.namedXContents;
    }

    public Map<String, Highlighter> getHighlighters() {
        return this.highlighters;
    }

    public ParseFieldRegistry<SignificanceHeuristicParser> getSignificanceHeuristicParserRegistry() {
        return this.significanceHeuristicParserRegistry;
    }

    public ParseFieldRegistry<MovAvgModel.AbstractModelParser> getMovingAverageModelParserRegistry() {
        return this.movingAverageModelParserRegistry;
    }

    private void registerAggregations(List<SearchPlugin> plugins) {
        this.registerAggregation(new SearchPlugin.AggregationSpec("avg", AvgAggregationBuilder::new, AvgAggregationBuilder::parse).addResultReader(InternalAvg::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("weighted_avg", WeightedAvgAggregationBuilder::new, WeightedAvgAggregationBuilder::parse).addResultReader(InternalWeightedAvg::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("sum", SumAggregationBuilder::new, SumAggregationBuilder::parse).addResultReader(InternalSum::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("min", MinAggregationBuilder::new, MinAggregationBuilder::parse).addResultReader(InternalMin::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("max", MaxAggregationBuilder::new, MaxAggregationBuilder::parse).addResultReader(InternalMax::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("stats", StatsAggregationBuilder::new, StatsAggregationBuilder::parse).addResultReader(InternalStats::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("extended_stats", ExtendedStatsAggregationBuilder::new, ExtendedStatsAggregationBuilder::parse).addResultReader(InternalExtendedStats::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("value_count", ValueCountAggregationBuilder::new, ValueCountAggregationBuilder::parse).addResultReader(InternalValueCount::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("percentiles", PercentilesAggregationBuilder::new, PercentilesAggregationBuilder::parse).addResultReader("tdigest_percentiles", InternalTDigestPercentiles::new).addResultReader("hdr_percentiles", InternalHDRPercentiles::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("percentile_ranks", PercentileRanksAggregationBuilder::new, PercentileRanksAggregationBuilder::parse).addResultReader("tdigest_percentile_ranks", InternalTDigestPercentileRanks::new).addResultReader("hdr_percentile_ranks", InternalHDRPercentileRanks::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("cardinality", CardinalityAggregationBuilder::new, CardinalityAggregationBuilder::parse).addResultReader(InternalCardinality::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("global", GlobalAggregationBuilder::new, GlobalAggregationBuilder::parse).addResultReader(InternalGlobal::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("missing", MissingAggregationBuilder::new, MissingAggregationBuilder::parse).addResultReader(InternalMissing::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("filter", FilterAggregationBuilder::new, FilterAggregationBuilder::parse).addResultReader(InternalFilter::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("filters", FiltersAggregationBuilder::new, FiltersAggregationBuilder::parse).addResultReader(InternalFilters::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("adjacency_matrix", AdjacencyMatrixAggregationBuilder::new, AdjacencyMatrixAggregationBuilder::parse).addResultReader(InternalAdjacencyMatrix::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("sampler", SamplerAggregationBuilder::new, SamplerAggregationBuilder::parse).addResultReader("mapped_sampler", InternalSampler::new).addResultReader("unmapped_sampler", UnmappedSampler::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("diversified_sampler", DiversifiedAggregationBuilder::new, DiversifiedAggregationBuilder::parse));
        this.registerAggregation(new SearchPlugin.AggregationSpec("terms", TermsAggregationBuilder::new, TermsAggregationBuilder::parse).addResultReader("sterms", StringTerms::new).addResultReader("umterms", UnmappedTerms::new).addResultReader("lterms", LongTerms::new).addResultReader("dterms", DoubleTerms::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("significant_terms", SignificantTermsAggregationBuilder::new, SignificantTermsAggregationBuilder.getParser(this.significanceHeuristicParserRegistry)).addResultReader("sigsterms", SignificantStringTerms::new).addResultReader("siglterms", SignificantLongTerms::new).addResultReader("umsigterms", UnmappedSignificantTerms::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("significant_text", SignificantTextAggregationBuilder::new, SignificantTextAggregationBuilder.getParser(this.significanceHeuristicParserRegistry)));
        this.registerAggregation(new SearchPlugin.AggregationSpec("range", RangeAggregationBuilder::new, RangeAggregationBuilder::parse).addResultReader(InternalRange::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("date_range", DateRangeAggregationBuilder::new, DateRangeAggregationBuilder::parse).addResultReader(InternalDateRange::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("ip_range", IpRangeAggregationBuilder::new, IpRangeAggregationBuilder::parse).addResultReader(InternalBinaryRange::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("histogram", HistogramAggregationBuilder::new, HistogramAggregationBuilder::parse).addResultReader(InternalHistogram::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("date_histogram", DateHistogramAggregationBuilder::new, DateHistogramAggregationBuilder::parse).addResultReader(InternalDateHistogram::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("auto_date_histogram", AutoDateHistogramAggregationBuilder::new, AutoDateHistogramAggregationBuilder::parse).addResultReader(InternalAutoDateHistogram::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("geo_distance", GeoDistanceAggregationBuilder::new, GeoDistanceAggregationBuilder::parse).addResultReader(InternalGeoDistance::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("geohash_grid", GeoGridAggregationBuilder::new, GeoGridAggregationBuilder::parse).addResultReader(InternalGeoHashGrid::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("nested", NestedAggregationBuilder::new, NestedAggregationBuilder::parse).addResultReader(InternalNested::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("reverse_nested", ReverseNestedAggregationBuilder::new, ReverseNestedAggregationBuilder::parse).addResultReader(InternalReverseNested::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("top_hits", TopHitsAggregationBuilder::new, TopHitsAggregationBuilder::parse).addResultReader(InternalTopHits::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("geo_bounds", GeoBoundsAggregationBuilder::new, GeoBoundsAggregationBuilder::parse).addResultReader(InternalGeoBounds::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("geo_centroid", GeoCentroidAggregationBuilder::new, GeoCentroidAggregationBuilder::parse).addResultReader(InternalGeoCentroid::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("scripted_metric", ScriptedMetricAggregationBuilder::new, ScriptedMetricAggregationBuilder::parse).addResultReader(InternalScriptedMetric::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("composite", CompositeAggregationBuilder::new, CompositeAggregationBuilder::parse).addResultReader(InternalComposite::new));
        this.registerFromPlugin(plugins, SearchPlugin::getAggregations, this::registerAggregation);
    }

    private void registerAggregation(SearchPlugin.AggregationSpec spec) {
        if (!this.transportClient) {
            this.namedXContents.add(new NamedXContentRegistry.Entry(BaseAggregationBuilder.class, spec.getName(), (p, c) -> {
                AggregatorFactories.AggParseContext context = (AggregatorFactories.AggParseContext)c;
                return ((Aggregator.Parser)spec.getParser()).parse(context.name, p);
            }));
        }
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(AggregationBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
        for (Map.Entry<String, Writeable.Reader<? extends InternalAggregation>> t : spec.getResultReaders().entrySet()) {
            String writeableName = t.getKey();
            Writeable.Reader<? extends InternalAggregation> internalReader = t.getValue();
            this.namedWriteables.add(new NamedWriteableRegistry.Entry(InternalAggregation.class, writeableName, internalReader));
        }
    }

    private void registerPipelineAggregations(List<SearchPlugin> plugins) {
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("derivative", DerivativePipelineAggregationBuilder::new, DerivativePipelineAggregator::new, DerivativePipelineAggregationBuilder::parse).addResultReader(InternalDerivative::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("max_bucket", MaxBucketPipelineAggregationBuilder::new, MaxBucketPipelineAggregator::new, MaxBucketPipelineAggregationBuilder.PARSER).addResultReader("bucket_metric_value", InternalBucketMetricValue::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("min_bucket", MinBucketPipelineAggregationBuilder::new, MinBucketPipelineAggregator::new, MinBucketPipelineAggregationBuilder.PARSER));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("avg_bucket", AvgBucketPipelineAggregationBuilder::new, AvgBucketPipelineAggregator::new, AvgBucketPipelineAggregationBuilder.PARSER).addResultReader("simple_value", InternalSimpleValue::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("sum_bucket", SumBucketPipelineAggregationBuilder::new, SumBucketPipelineAggregator::new, SumBucketPipelineAggregationBuilder.PARSER));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("stats_bucket", StatsBucketPipelineAggregationBuilder::new, StatsBucketPipelineAggregator::new, StatsBucketPipelineAggregationBuilder.PARSER).addResultReader(InternalStatsBucket::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("extended_stats_bucket", ExtendedStatsBucketPipelineAggregationBuilder::new, ExtendedStatsBucketPipelineAggregator::new, (PipelineAggregator.Parser)new ExtendedStatsBucketParser()).addResultReader(InternalExtendedStatsBucket::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("percentiles_bucket", PercentilesBucketPipelineAggregationBuilder::new, PercentilesBucketPipelineAggregator::new, PercentilesBucketPipelineAggregationBuilder.PARSER).addResultReader(InternalPercentilesBucket::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("moving_avg", MovAvgPipelineAggregationBuilder::new, MovAvgPipelineAggregator::new, (n, c) -> MovAvgPipelineAggregationBuilder.parse(this.movingAverageModelParserRegistry, n, c)));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("cumulative_sum", CumulativeSumPipelineAggregationBuilder::new, CumulativeSumPipelineAggregator::new, CumulativeSumPipelineAggregationBuilder::parse));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("bucket_script", BucketScriptPipelineAggregationBuilder::new, BucketScriptPipelineAggregator::new, BucketScriptPipelineAggregationBuilder::parse));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("bucket_selector", BucketSelectorPipelineAggregationBuilder::new, BucketSelectorPipelineAggregator::new, BucketSelectorPipelineAggregationBuilder::parse));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("bucket_sort", BucketSortPipelineAggregationBuilder::new, BucketSortPipelineAggregator::new, BucketSortPipelineAggregationBuilder::parse));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("serial_diff", SerialDiffPipelineAggregationBuilder::new, SerialDiffPipelineAggregator::new, SerialDiffPipelineAggregationBuilder::parse));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("moving_fn", MovFnPipelineAggregationBuilder::new, MovFnPipelineAggregator::new, MovFnPipelineAggregationBuilder::parse));
        this.registerFromPlugin(plugins, SearchPlugin::getPipelineAggregations, this::registerPipelineAggregation);
    }

    private void registerPipelineAggregation(SearchPlugin.PipelineAggregationSpec spec) {
        if (!this.transportClient) {
            this.namedXContents.add(new NamedXContentRegistry.Entry(BaseAggregationBuilder.class, spec.getName(), (p, c) -> {
                AggregatorFactories.AggParseContext context = (AggregatorFactories.AggParseContext)c;
                return ((PipelineAggregator.Parser)spec.getParser()).parse(context.name, p);
            }));
        }
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(PipelineAggregationBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(PipelineAggregator.class, spec.getName().getPreferredName(), spec.getAggregatorReader()));
        for (Map.Entry<String, Writeable.Reader<? extends InternalAggregation>> resultReader : spec.getResultReaders().entrySet()) {
            this.namedWriteables.add(new NamedWriteableRegistry.Entry(InternalAggregation.class, resultReader.getKey(), resultReader.getValue()));
        }
    }

    private void registerShapes() {
        if (ShapesAvailability.JTS_AVAILABLE && ShapesAvailability.SPATIAL4J_AVAILABLE) {
            this.namedWriteables.addAll(GeoShapeType.getShapeWriteables());
        }
    }

    private void registerRescorers(List<SearchPlugin> plugins) {
        this.registerRescorer(new SearchPlugin.RescorerSpec<QueryRescorerBuilder>("query", QueryRescorerBuilder::new, QueryRescorerBuilder::fromXContent));
        this.registerFromPlugin(plugins, SearchPlugin::getRescorers, this::registerRescorer);
    }

    private void registerRescorer(SearchPlugin.RescorerSpec<?> spec) {
        if (!this.transportClient) {
            this.namedXContents.add(new NamedXContentRegistry.Entry(RescorerBuilder.class, spec.getName(), (p, c) -> (RescorerBuilder)((CheckedFunction)spec.getParser()).apply((Object)p)));
        }
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(RescorerBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
    }

    private void registerSorts() {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SortBuilder.class, "_geo_distance", GeoDistanceSortBuilder::new));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SortBuilder.class, "_score", ScoreSortBuilder::new));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SortBuilder.class, "_script", ScriptSortBuilder::new));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SortBuilder.class, "field_sort", FieldSortBuilder::new));
    }

    private <T> void registerFromPlugin(List<SearchPlugin> plugins, Function<SearchPlugin, List<T>> producer, Consumer<T> consumer) {
        for (SearchPlugin plugin : plugins) {
            for (T t : producer.apply(plugin)) {
                consumer.accept(t);
            }
        }
    }

    public static void registerSmoothingModels(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(SmoothingModel.class, "laplace", Laplace::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(SmoothingModel.class, "linear", LinearInterpolation::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(SmoothingModel.class, "stupid_backoff", StupidBackoff::new));
    }

    private void registerSuggesters(List<SearchPlugin> plugins) {
        SearchModule.registerSmoothingModels(this.namedWriteables);
        this.registerSuggester(new SearchPlugin.SuggesterSpec<TermSuggestionBuilder>("term", TermSuggestionBuilder::new, TermSuggestionBuilder::fromXContent));
        this.registerSuggester(new SearchPlugin.SuggesterSpec<PhraseSuggestionBuilder>("phrase", PhraseSuggestionBuilder::new, PhraseSuggestionBuilder::fromXContent));
        this.registerSuggester(new SearchPlugin.SuggesterSpec<CompletionSuggestionBuilder>("completion", CompletionSuggestionBuilder::new, CompletionSuggestionBuilder::fromXContent));
        this.registerFromPlugin(plugins, SearchPlugin::getSuggesters, this::registerSuggester);
    }

    private void registerSuggester(SearchPlugin.SuggesterSpec<?> suggester) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SuggestionBuilder.class, suggester.getName().getPreferredName(), suggester.getReader()));
        this.namedXContents.add(new NamedXContentRegistry.Entry(SuggestionBuilder.class, suggester.getName(), (CheckedFunction)suggester.getParser()));
    }

    private Map<String, Highlighter> setupHighlighters(Settings settings, List<SearchPlugin> plugins) {
        NamedRegistry<Highlighter> highlighters = new NamedRegistry<Highlighter>("highlighter");
        highlighters.register("fvh", new FastVectorHighlighter(settings));
        highlighters.register("plain", new PlainHighlighter());
        highlighters.register("unified", new UnifiedHighlighter());
        highlighters.extractAndRegister(plugins, SearchPlugin::getHighlighters);
        return Collections.unmodifiableMap(highlighters.getRegistry());
    }

    private void registerScoreFunctions(List<SearchPlugin> plugins) {
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<ScriptScoreFunctionBuilder>("script_score", ScriptScoreFunctionBuilder::new, ScriptScoreFunctionBuilder::fromXContent));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<GaussDecayFunctionBuilder>("gauss", GaussDecayFunctionBuilder::new, GaussDecayFunctionBuilder.PARSER));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<LinearDecayFunctionBuilder>("linear", LinearDecayFunctionBuilder::new, LinearDecayFunctionBuilder.PARSER));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<ExponentialDecayFunctionBuilder>("exp", ExponentialDecayFunctionBuilder::new, ExponentialDecayFunctionBuilder.PARSER));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<RandomScoreFunctionBuilder>("random_score", RandomScoreFunctionBuilder::new, RandomScoreFunctionBuilder::fromXContent));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<FieldValueFactorFunctionBuilder>("field_value_factor", FieldValueFactorFunctionBuilder::new, FieldValueFactorFunctionBuilder::fromXContent));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(ScoreFunctionBuilder.class, "weight", WeightBuilder::new));
        this.registerFromPlugin(plugins, SearchPlugin::getScoreFunctions, this::registerScoreFunction);
    }

    private void registerScoreFunction(SearchPlugin.ScoreFunctionSpec<?> scoreFunction) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(ScoreFunctionBuilder.class, scoreFunction.getName().getPreferredName(), scoreFunction.getReader()));
        this.namedXContents.add(new NamedXContentRegistry.Entry(ScoreFunctionBuilder.class, scoreFunction.getName(), (p, c) -> ((ScoreFunctionParser)scoreFunction.getParser()).fromXContent(p)));
    }

    private void registerValueFormats() {
        this.registerValueFormat(DocValueFormat.BOOLEAN.getWriteableName(), in -> DocValueFormat.BOOLEAN);
        this.registerValueFormat("date_time", DocValueFormat.DateTime::new);
        this.registerValueFormat("decimal", DocValueFormat.Decimal::new);
        this.registerValueFormat(DocValueFormat.GEOHASH.getWriteableName(), in -> DocValueFormat.GEOHASH);
        this.registerValueFormat(DocValueFormat.IP.getWriteableName(), in -> DocValueFormat.IP);
        this.registerValueFormat(DocValueFormat.RAW.getWriteableName(), in -> DocValueFormat.RAW);
        this.registerValueFormat(DocValueFormat.BINARY.getWriteableName(), in -> DocValueFormat.BINARY);
    }

    private void registerValueFormat(String name, Writeable.Reader<? extends DocValueFormat> reader) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(DocValueFormat.class, name, reader));
    }

    private void registerSignificanceHeuristics(List<SearchPlugin> plugins) {
        this.registerSignificanceHeuristic(new SearchPlugin.SearchExtensionSpec<SignificanceHeuristic, SignificanceHeuristicParser>("chi_square", ChiSquare::new, ChiSquare.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SearchExtensionSpec<SignificanceHeuristic, SignificanceHeuristicParser>("gnd", GND::new, GND.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SearchExtensionSpec<SignificanceHeuristic, SignificanceHeuristicParser>("jlh", JLHScore::new, JLHScore::parse));
        this.registerSignificanceHeuristic(new SearchPlugin.SearchExtensionSpec<SignificanceHeuristic, SignificanceHeuristicParser>("mutual_information", MutualInformation::new, MutualInformation.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SearchExtensionSpec<SignificanceHeuristic, SignificanceHeuristicParser>("percentage", PercentageScore::new, PercentageScore::parse));
        this.registerSignificanceHeuristic(new SearchPlugin.SearchExtensionSpec<SignificanceHeuristic, SignificanceHeuristicParser>("script_heuristic", ScriptHeuristic::new, ScriptHeuristic::parse));
        this.registerFromPlugin(plugins, SearchPlugin::getSignificanceHeuristics, this::registerSignificanceHeuristic);
    }

    private void registerSignificanceHeuristic(SearchPlugin.SearchExtensionSpec<SignificanceHeuristic, SignificanceHeuristicParser> heuristic) {
        this.significanceHeuristicParserRegistry.register(heuristic.getParser(), heuristic.getName());
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SignificanceHeuristic.class, heuristic.getName().getPreferredName(), heuristic.getReader()));
    }

    private void registerMovingAverageModels(List<SearchPlugin> plugins) {
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("simple", SimpleModel::new, SimpleModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("linear", LinearModel::new, LinearModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("ewma", EwmaModel::new, EwmaModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("holt", HoltLinearModel::new, HoltLinearModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("holt_winters", HoltWintersModel::new, HoltWintersModel.PARSER));
        this.registerFromPlugin(plugins, SearchPlugin::getMovingAverageModels, this::registerMovingAverageModel);
    }

    private void registerMovingAverageModel(SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser> movAvgModel) {
        this.movingAverageModelParserRegistry.register(movAvgModel.getParser(), movAvgModel.getName());
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(MovAvgModel.class, movAvgModel.getName().getPreferredName(), movAvgModel.getReader()));
    }

    private void registerFetchSubPhases(List<SearchPlugin> plugins) {
        this.registerFetchSubPhase(new ExplainFetchSubPhase());
        this.registerFetchSubPhase(new DocValueFieldsFetchSubPhase());
        this.registerFetchSubPhase(new ScriptFieldsFetchSubPhase());
        this.registerFetchSubPhase(new FetchSourceSubPhase());
        this.registerFetchSubPhase(new VersionFetchSubPhase());
        this.registerFetchSubPhase(new MatchedQueriesFetchSubPhase());
        this.registerFetchSubPhase(new HighlightPhase(this.settings, this.highlighters));
        this.registerFetchSubPhase(new ParentFieldSubFetchPhase());
        SearchPlugin.FetchPhaseConstructionContext context = new SearchPlugin.FetchPhaseConstructionContext(this.highlighters);
        this.registerFromPlugin(plugins, p -> p.getFetchSubPhases(context), this::registerFetchSubPhase);
    }

    private void registerSearchExts(List<SearchPlugin> plugins) {
        this.registerFromPlugin(plugins, SearchPlugin::getSearchExts, this::registerSearchExt);
    }

    private void registerSearchExt(SearchPlugin.SearchExtSpec<?> spec) {
        this.namedXContents.add(new NamedXContentRegistry.Entry(SearchExtBuilder.class, spec.getName(), (CheckedFunction)spec.getParser()));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SearchExtBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
    }

    private void registerFetchSubPhase(FetchSubPhase subPhase) {
        Class<?> subPhaseClass = subPhase.getClass();
        if (this.fetchSubPhases.stream().anyMatch(p -> p.getClass().equals(subPhaseClass))) {
            throw new IllegalArgumentException("FetchSubPhase [" + subPhaseClass + "] already registered");
        }
        this.fetchSubPhases.add(Objects.requireNonNull(subPhase, "FetchSubPhase must not be null"));
    }

    private void registerQueryParsers(List<SearchPlugin> plugins) {
        this.registerQuery(new SearchPlugin.QuerySpec<MatchQueryBuilder>("match", MatchQueryBuilder::new, MatchQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchPhraseQueryBuilder>("match_phrase", MatchPhraseQueryBuilder::new, MatchPhraseQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchPhrasePrefixQueryBuilder>("match_phrase_prefix", MatchPhrasePrefixQueryBuilder::new, MatchPhrasePrefixQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MultiMatchQueryBuilder>("multi_match", MultiMatchQueryBuilder::new, MultiMatchQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<NestedQueryBuilder>("nested", NestedQueryBuilder::new, NestedQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<DisMaxQueryBuilder>("dis_max", DisMaxQueryBuilder::new, DisMaxQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<IdsQueryBuilder>("ids", IdsQueryBuilder::new, IdsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchAllQueryBuilder>("match_all", MatchAllQueryBuilder::new, MatchAllQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<QueryStringQueryBuilder>("query_string", QueryStringQueryBuilder::new, QueryStringQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<BoostingQueryBuilder>("boosting", BoostingQueryBuilder::new, BoostingQueryBuilder::fromXContent));
        BooleanQuery.setMaxClauseCount((int)INDICES_MAX_CLAUSE_COUNT_SETTING.get(this.settings));
        this.registerQuery(new SearchPlugin.QuerySpec<BoolQueryBuilder>("bool", BoolQueryBuilder::new, BoolQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<TermQueryBuilder>("term", TermQueryBuilder::new, TermQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<TermsQueryBuilder>("terms", TermsQueryBuilder::new, TermsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<FuzzyQueryBuilder>("fuzzy", FuzzyQueryBuilder::new, FuzzyQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<RegexpQueryBuilder>("regexp", RegexpQueryBuilder::new, RegexpQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<RangeQueryBuilder>("range", RangeQueryBuilder::new, RangeQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<PrefixQueryBuilder>("prefix", PrefixQueryBuilder::new, PrefixQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<WildcardQueryBuilder>("wildcard", WildcardQueryBuilder::new, WildcardQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<ConstantScoreQueryBuilder>("constant_score", ConstantScoreQueryBuilder::new, ConstantScoreQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanTermQueryBuilder>("span_term", SpanTermQueryBuilder::new, SpanTermQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanNotQueryBuilder>("span_not", SpanNotQueryBuilder::new, SpanNotQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanWithinQueryBuilder>("span_within", SpanWithinQueryBuilder::new, SpanWithinQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanContainingQueryBuilder>("span_containing", SpanContainingQueryBuilder::new, SpanContainingQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<FieldMaskingSpanQueryBuilder>("field_masking_span", FieldMaskingSpanQueryBuilder::new, FieldMaskingSpanQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanFirstQueryBuilder>("span_first", SpanFirstQueryBuilder::new, SpanFirstQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanNearQueryBuilder>("span_near", SpanNearQueryBuilder::new, SpanNearQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanNearQueryBuilder.SpanGapQueryBuilder>("span_gap", SpanNearQueryBuilder.SpanGapQueryBuilder::new, SpanNearQueryBuilder.SpanGapQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanOrQueryBuilder>("span_or", SpanOrQueryBuilder::new, SpanOrQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MoreLikeThisQueryBuilder>("more_like_this", MoreLikeThisQueryBuilder::new, MoreLikeThisQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<WrapperQueryBuilder>("wrapper", WrapperQueryBuilder::new, WrapperQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<CommonTermsQueryBuilder>("common", CommonTermsQueryBuilder::new, CommonTermsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanMultiTermQueryBuilder>("span_multi", SpanMultiTermQueryBuilder::new, SpanMultiTermQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<FunctionScoreQueryBuilder>("function_score", FunctionScoreQueryBuilder::new, FunctionScoreQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SimpleQueryStringBuilder>("simple_query_string", SimpleQueryStringBuilder::new, SimpleQueryStringBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<TypeQueryBuilder>("type", TypeQueryBuilder::new, TypeQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<ScriptQueryBuilder>("script", ScriptQueryBuilder::new, ScriptQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<GeoDistanceQueryBuilder>("geo_distance", GeoDistanceQueryBuilder::new, GeoDistanceQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<GeoBoundingBoxQueryBuilder>("geo_bounding_box", GeoBoundingBoxQueryBuilder::new, GeoBoundingBoxQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<GeoPolygonQueryBuilder>("geo_polygon", GeoPolygonQueryBuilder::new, GeoPolygonQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<ExistsQueryBuilder>("exists", ExistsQueryBuilder::new, ExistsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchNoneQueryBuilder>("match_none", MatchNoneQueryBuilder::new, MatchNoneQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<TermsSetQueryBuilder>("terms_set", TermsSetQueryBuilder::new, TermsSetQueryBuilder::fromXContent));
        if (ShapesAvailability.JTS_AVAILABLE && ShapesAvailability.SPATIAL4J_AVAILABLE) {
            this.registerQuery(new SearchPlugin.QuerySpec<GeoShapeQueryBuilder>("geo_shape", GeoShapeQueryBuilder::new, GeoShapeQueryBuilder::fromXContent));
        }
        this.registerFromPlugin(plugins, SearchPlugin::getQueries, this::registerQuery);
    }

    private void registerQuery(SearchPlugin.QuerySpec<?> spec) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(QueryBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
        this.namedXContents.add(new NamedXContentRegistry.Entry(QueryBuilder.class, spec.getName(), (p, c) -> ((QueryParser)spec.getParser()).fromXContent(p)));
    }

    public FetchPhase getFetchPhase() {
        return new FetchPhase(this.fetchSubPhases);
    }
}

