/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.XShapeCollection;
import org.elasticsearch.common.geo.builders.CoordinatesBuilder;
import org.elasticsearch.common.geo.builders.LineStringBuilder;
import org.elasticsearch.common.geo.builders.PolygonBuilder;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.geo.parsers.ShapeParser;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class MultiPolygonBuilder
extends ShapeBuilder {
    public static final GeoShapeType TYPE = GeoShapeType.MULTIPOLYGON;
    private final List<PolygonBuilder> polygons = new ArrayList<PolygonBuilder>();
    private final ShapeBuilder.Orientation orientation;

    public MultiPolygonBuilder() {
        this(ShapeBuilder.Orientation.RIGHT);
    }

    public MultiPolygonBuilder(ShapeBuilder.Orientation orientation) {
        this.orientation = orientation;
    }

    public MultiPolygonBuilder(StreamInput in) throws IOException {
        this.orientation = ShapeBuilder.Orientation.readFrom(in);
        int holes = in.readVInt();
        for (int i = 0; i < holes; ++i) {
            this.polygon(new PolygonBuilder(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.orientation.writeTo(out);
        out.writeVInt(this.polygons.size());
        for (PolygonBuilder polygon : this.polygons) {
            polygon.writeTo(out);
        }
    }

    public ShapeBuilder.Orientation orientation() {
        return this.orientation;
    }

    public MultiPolygonBuilder polygon(PolygonBuilder polygon) {
        PolygonBuilder pb = new PolygonBuilder(new CoordinatesBuilder().coordinates(polygon.shell().coordinates(false)), this.orientation);
        for (LineStringBuilder hole : polygon.holes()) {
            pb.hole(hole);
        }
        this.polygons.add(pb);
        return this;
    }

    public List<PolygonBuilder> polygons() {
        return this.polygons;
    }

    private static String polygonCoordinatesToWKT(PolygonBuilder polygon) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append((CharSequence)ShapeBuilder.coordinateListToWKT(polygon.shell().coordinates));
        for (LineStringBuilder hole : polygon.holes()) {
            sb.append(",");
            sb.append((CharSequence)ShapeBuilder.coordinateListToWKT(hole.coordinates));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    protected StringBuilder contentToWKT() {
        StringBuilder sb = new StringBuilder();
        if (this.polygons.isEmpty()) {
            sb.append("EMPTY");
        } else {
            sb.append("(");
            if (this.polygons.size() > 0) {
                sb.append(MultiPolygonBuilder.polygonCoordinatesToWKT(this.polygons.get(0)));
            }
            for (int i = 1; i < this.polygons.size(); ++i) {
                sb.append(",");
                sb.append(MultiPolygonBuilder.polygonCoordinatesToWKT(this.polygons.get(i)));
            }
            sb.append(")");
        }
        return sb;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ShapeParser.FIELD_TYPE.getPreferredName(), TYPE.shapeName());
        builder.field(ShapeParser.FIELD_ORIENTATION.getPreferredName(), this.orientation.name().toLowerCase(Locale.ROOT));
        builder.startArray(ShapeParser.FIELD_COORDINATES.getPreferredName());
        for (PolygonBuilder polygon : this.polygons) {
            builder.startArray();
            polygon.coordinatesArray(builder, params);
            builder.endArray();
        }
        builder.endArray();
        return builder.endObject();
    }

    @Override
    public GeoShapeType type() {
        return TYPE;
    }

    @Override
    public int numDimensions() {
        if (this.polygons == null || this.polygons.isEmpty()) {
            throw new IllegalStateException("unable to get number of dimensions, Polygons have not yet been initialized");
        }
        return this.polygons.get(0).numDimensions();
    }

    public Shape build() {
        ArrayList<JtsGeometry> shapes = new ArrayList<JtsGeometry>(this.polygons.size());
        if (this.wrapdateline) {
            for (PolygonBuilder polygon : this.polygons) {
                for (Coordinate[][] part : polygon.coordinates()) {
                    shapes.add(this.jtsGeometry((Geometry)PolygonBuilder.polygon(FACTORY, part)));
                }
            }
        } else {
            for (PolygonBuilder polygon : this.polygons) {
                shapes.add(this.jtsGeometry((Geometry)polygon.toPolygon(FACTORY)));
            }
        }
        if (shapes.size() == 1) {
            return (Shape)shapes.get(0);
        }
        return new XShapeCollection(shapes, (SpatialContext)SPATIAL_CONTEXT);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.polygons, this.orientation});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MultiPolygonBuilder other = (MultiPolygonBuilder)obj;
        return Objects.equals(this.polygons, other.polygons) && Objects.equals((Object)this.orientation, (Object)other.orientation);
    }
}

