/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.LockObtainFailedException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.action.index.NodeMappingRefreshAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.env.ShardLockObtainFailedException;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.seqno.GlobalCheckpointSyncAction;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.PrimaryReplicaSyncer;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.flush.SyncedFlushService;
import org.elasticsearch.indices.recovery.PeerRecoverySourceService;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.snapshots.SnapshotShardsService;
import org.elasticsearch.threadpool.ThreadPool;

public class IndicesClusterStateService
extends AbstractLifecycleComponent
implements ClusterStateApplier {
    final AllocatedIndices<? extends Shard, ? extends AllocatedIndex<? extends Shard>> indicesService;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final PeerRecoveryTargetService recoveryTargetService;
    private final ShardStateAction shardStateAction;
    private final NodeMappingRefreshAction nodeMappingRefreshAction;
    private static final ShardStateAction.Listener SHARD_STATE_ACTION_LISTENER = new ShardStateAction.Listener(){};
    final ConcurrentMap<ShardId, ShardRouting> failedShardsCache = ConcurrentCollections.newConcurrentMap();
    private final RepositoriesService repositoriesService;
    private final FailedShardHandler failedShardHandler = new FailedShardHandler();
    private final boolean sendRefreshMapping;
    private final List<IndexEventListener> buildInIndexListener;
    private final PrimaryReplicaSyncer primaryReplicaSyncer;
    private final Consumer<ShardId> globalCheckpointSyncer;

    @Inject
    public IndicesClusterStateService(Settings settings, IndicesService indicesService, ClusterService clusterService, ThreadPool threadPool, PeerRecoveryTargetService recoveryTargetService, ShardStateAction shardStateAction, NodeMappingRefreshAction nodeMappingRefreshAction, RepositoriesService repositoriesService, SearchService searchService, SyncedFlushService syncedFlushService, PeerRecoverySourceService peerRecoverySourceService, SnapshotShardsService snapshotShardsService, PrimaryReplicaSyncer primaryReplicaSyncer, GlobalCheckpointSyncAction globalCheckpointSyncAction) {
        this(settings, (AllocatedIndices<? extends Shard, ? extends AllocatedIndex<? extends Shard>>)indicesService, clusterService, threadPool, recoveryTargetService, shardStateAction, nodeMappingRefreshAction, repositoriesService, searchService, syncedFlushService, peerRecoverySourceService, snapshotShardsService, primaryReplicaSyncer, globalCheckpointSyncAction::updateGlobalCheckpointForShard);
    }

    IndicesClusterStateService(Settings settings, AllocatedIndices<? extends Shard, ? extends AllocatedIndex<? extends Shard>> indicesService, ClusterService clusterService, ThreadPool threadPool, PeerRecoveryTargetService recoveryTargetService, ShardStateAction shardStateAction, NodeMappingRefreshAction nodeMappingRefreshAction, RepositoriesService repositoriesService, SearchService searchService, SyncedFlushService syncedFlushService, PeerRecoverySourceService peerRecoverySourceService, SnapshotShardsService snapshotShardsService, PrimaryReplicaSyncer primaryReplicaSyncer, Consumer<ShardId> globalCheckpointSyncer) {
        super(settings);
        this.buildInIndexListener = Arrays.asList(peerRecoverySourceService, recoveryTargetService, searchService, syncedFlushService, snapshotShardsService);
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.recoveryTargetService = recoveryTargetService;
        this.shardStateAction = shardStateAction;
        this.nodeMappingRefreshAction = nodeMappingRefreshAction;
        this.repositoriesService = repositoriesService;
        this.primaryReplicaSyncer = primaryReplicaSyncer;
        this.globalCheckpointSyncer = globalCheckpointSyncer;
        this.sendRefreshMapping = this.settings.getAsBoolean("indices.cluster.send_refresh_mapping", true);
    }

    @Override
    protected void doStart() {
        if (DiscoveryNode.isDataNode(this.settings) || DiscoveryNode.isMasterNode(this.settings)) {
            this.clusterService.addHighPriorityApplier(this);
        }
    }

    @Override
    protected void doStop() {
        if (DiscoveryNode.isDataNode(this.settings) || DiscoveryNode.isMasterNode(this.settings)) {
            this.clusterService.removeApplier(this);
        }
    }

    @Override
    protected void doClose() {
    }

    @Override
    public synchronized void applyClusterState(ClusterChangedEvent event) {
        if (!this.lifecycle.started()) {
            return;
        }
        ClusterState state = event.state();
        if (state.blocks().disableStatePersistence()) {
            for (AllocatedIndex indexService : this.indicesService) {
                this.indicesService.removeIndex(indexService.index(), AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, "cleaning index (disabled block persistence)");
            }
            return;
        }
        this.updateFailedShardsCache(state);
        this.deleteIndices(event);
        this.removeUnallocatedIndices(event);
        this.failMissingShards(state);
        this.removeShards(state);
        this.updateIndices(event);
        this.createIndices(state);
        this.createOrUpdateShards(state);
    }

    private void updateFailedShardsCache(ClusterState state) {
        RoutingNode localRoutingNode = state.getRoutingNodes().node(state.nodes().getLocalNodeId());
        if (localRoutingNode == null) {
            this.failedShardsCache.clear();
            return;
        }
        DiscoveryNode masterNode = state.nodes().getMasterNode();
        Iterator iterator = this.failedShardsCache.entrySet().iterator();
        while (iterator.hasNext()) {
            ShardRouting failedShardRouting = (ShardRouting)iterator.next().getValue();
            ShardRouting matchedRouting = localRoutingNode.getByShardId(failedShardRouting.shardId());
            if (matchedRouting == null || !matchedRouting.isSameAllocation(failedShardRouting)) {
                iterator.remove();
                continue;
            }
            if (masterNode == null) continue;
            String message = "master " + masterNode + " has not removed previously failed shard. resending shard failure";
            this.logger.trace("[{}] re-sending failed shard [{}], reason [{}]", (Object)matchedRouting.shardId(), (Object)matchedRouting, (Object)message);
            this.shardStateAction.localShardFailed(matchedRouting, message, null, SHARD_STATE_ACTION_LISTENER, state);
        }
    }

    private void deleteIndices(ClusterChangedEvent event) {
        ClusterState previousState = event.previousState();
        ClusterState state = event.state();
        String localNodeId = state.nodes().getLocalNodeId();
        assert (localNodeId != null);
        for (final Index index : event.indicesDeleted()) {
            IndexMetaData metaData;
            IndexSettings indexSettings;
            AllocatedIndex<? extends Shard> indexService;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{}] cleaning index, no longer part of the metadata", (Object)index);
            }
            if ((indexService = this.indicesService.indexService(index)) != null) {
                indexSettings = indexService.getIndexSettings();
                this.indicesService.removeIndex(index, AllocatedIndices.IndexRemovalReason.DELETED, "index no longer part of the metadata");
            } else if (previousState.metaData().hasIndex(index.getName())) {
                metaData = previousState.metaData().index(index);
                indexSettings = new IndexSettings(metaData, this.settings);
                this.indicesService.deleteUnassignedIndex("deleted index was not assigned to local node", metaData, state);
            } else {
                assert (previousState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK));
                metaData = this.indicesService.verifyIndexIsDeleted(index, event.state());
                indexSettings = metaData != null ? new IndexSettings(metaData, this.settings) : null;
            }
            if (indexSettings == null) continue;
            this.threadPool.generic().execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    IndicesClusterStateService.this.logger.warn(() -> new ParameterizedMessage("[{}] failed to complete pending deletion for index", (Object)index), (Throwable)e);
                }

                @Override
                protected void doRun() throws Exception {
                    try {
                        IndicesClusterStateService.this.indicesService.processPendingDeletes(index, indexSettings, new TimeValue(30L, TimeUnit.MINUTES));
                    }
                    catch (LockObtainFailedException exc) {
                        IndicesClusterStateService.this.logger.warn("[{}] failed to lock all shards for index - timed out after 30 seconds", (Object)index);
                    }
                    catch (InterruptedException e) {
                        IndicesClusterStateService.this.logger.warn("[{}] failed to lock all shards for index - interrupted", (Object)index);
                    }
                }
            });
        }
    }

    private void removeUnallocatedIndices(ClusterChangedEvent event) {
        ClusterState state = event.state();
        String localNodeId = state.nodes().getLocalNodeId();
        assert (localNodeId != null);
        HashSet<Index> indicesWithShards = new HashSet<Index>();
        RoutingNode localRoutingNode = state.getRoutingNodes().node(localNodeId);
        if (localRoutingNode != null) {
            for (ShardRouting shardRouting : localRoutingNode) {
                indicesWithShards.add(shardRouting.index());
            }
        }
        for (AllocatedIndex indexService : this.indicesService) {
            Index index = indexService.index();
            if (indicesWithShards.contains(index)) continue;
            IndexMetaData indexMetaData = state.metaData().index(index);
            assert (indexMetaData != null || event.isNewCluster()) : "index " + index + " does not exist in the cluster state, it should either have been deleted or the cluster must be new";
            AllocatedIndices.IndexRemovalReason reason = indexMetaData != null && indexMetaData.getState() == IndexMetaData.State.CLOSE ? AllocatedIndices.IndexRemovalReason.CLOSED : AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED;
            this.logger.debug("{} removing index, [{}]", (Object)index, (Object)reason);
            this.indicesService.removeIndex(index, reason, "removing index (no shards allocated)");
        }
    }

    private void failMissingShards(ClusterState state) {
        RoutingNode localRoutingNode = state.getRoutingNodes().node(state.nodes().getLocalNodeId());
        if (localRoutingNode == null) {
            return;
        }
        for (ShardRouting shardRouting : localRoutingNode) {
            ShardId shardId = shardRouting.shardId();
            if (shardRouting.initializing() || this.failedShardsCache.containsKey(shardId) || this.indicesService.getShardOrNull(shardId) != null) continue;
            this.sendFailShard(shardRouting, "master marked shard as active, but shard has not been created, mark shard as failed", null, state);
        }
    }

    private void removeShards(ClusterState state) {
        String localNodeId = state.nodes().getLocalNodeId();
        assert (localNodeId != null);
        RoutingNode localRoutingNode = state.getRoutingNodes().node(localNodeId);
        for (AllocatedIndex indexService : this.indicesService) {
            for (Shard shard : indexService) {
                ShardRouting newShardRouting;
                ShardRouting currentRoutingEntry = shard.routingEntry();
                ShardId shardId = currentRoutingEntry.shardId();
                ShardRouting shardRouting = newShardRouting = localRoutingNode == null ? null : localRoutingNode.getByShardId(shardId);
                if (newShardRouting == null) {
                    this.logger.debug("{} removing shard (not allocated)", (Object)shardId);
                    indexService.removeShard(shardId.id(), "removing shard (not allocated)");
                    continue;
                }
                if (!newShardRouting.isSameAllocation(currentRoutingEntry)) {
                    this.logger.debug("{} removing shard (stale allocation id, stale {}, new {})", (Object)shardId, (Object)currentRoutingEntry, (Object)newShardRouting);
                    indexService.removeShard(shardId.id(), "removing shard (stale copy)");
                    continue;
                }
                if (newShardRouting.initializing() && currentRoutingEntry.active()) {
                    this.logger.debug("{} removing shard (not active, current {}, new {})", (Object)shardId, (Object)currentRoutingEntry, (Object)newShardRouting);
                    indexService.removeShard(shardId.id(), "removing shard (stale copy)");
                    continue;
                }
                if (!newShardRouting.primary() || currentRoutingEntry.primary() || !newShardRouting.initializing()) continue;
                assert (currentRoutingEntry.initializing()) : currentRoutingEntry;
                this.logger.debug("{} removing shard (not active, current {}, new {})", (Object)shardId, (Object)currentRoutingEntry, (Object)newShardRouting);
                indexService.removeShard(shardId.id(), "removing shard (stale copy)");
            }
        }
    }

    private void createIndices(ClusterState state) {
        Index index;
        RoutingNode localRoutingNode = state.getRoutingNodes().node(state.nodes().getLocalNodeId());
        if (localRoutingNode == null) {
            return;
        }
        HashMap<Index, List> indicesToCreate = new HashMap<Index, List>();
        for (ShardRouting shardRouting : localRoutingNode) {
            if (this.failedShardsCache.containsKey(shardRouting.shardId()) || this.indicesService.indexService(index = shardRouting.index()) != null) continue;
            indicesToCreate.computeIfAbsent(index, k -> new ArrayList()).add(shardRouting);
        }
        for (Map.Entry entry : indicesToCreate.entrySet()) {
            index = (Index)entry.getKey();
            IndexMetaData indexMetaData = state.metaData().index(index);
            this.logger.debug("[{}] creating index", (Object)index);
            AllocatedIndex<? extends Shard> indexService = null;
            try {
                indexService = this.indicesService.createIndex(indexMetaData, this.buildInIndexListener);
                if (!indexService.updateMapping(null, indexMetaData) || !this.sendRefreshMapping) continue;
                this.nodeMappingRefreshAction.nodeMappingRefresh(state.nodes().getMasterNode(), new NodeMappingRefreshAction.NodeMappingRefreshRequest(indexMetaData.getIndex().getName(), indexMetaData.getIndexUUID(), state.nodes().getLocalNodeId()));
            }
            catch (Exception e) {
                String failShardReason;
                if (indexService == null) {
                    failShardReason = "failed to create index";
                } else {
                    failShardReason = "failed to update mapping for index";
                    this.indicesService.removeIndex(index, AllocatedIndices.IndexRemovalReason.FAILURE, "removing index (mapping update failed)");
                }
                for (ShardRouting shardRouting : (List)entry.getValue()) {
                    this.sendFailShard(shardRouting, failShardReason, e, state);
                }
            }
        }
    }

    private void updateIndices(ClusterChangedEvent event) {
        if (!event.metaDataChanged()) {
            return;
        }
        ClusterState state = event.state();
        for (AllocatedIndex indexService : this.indicesService) {
            Index index = indexService.index();
            IndexMetaData currentIndexMetaData = indexService.getIndexSettings().getIndexMetaData();
            IndexMetaData newIndexMetaData = state.metaData().index(index);
            assert (newIndexMetaData != null) : "index " + index + " should have been removed by deleteIndices";
            if (!ClusterChangedEvent.indexMetaDataChanged(currentIndexMetaData, newIndexMetaData)) continue;
            indexService.updateMetaData(currentIndexMetaData, newIndexMetaData);
            try {
                if (!indexService.updateMapping(currentIndexMetaData, newIndexMetaData) || !this.sendRefreshMapping) continue;
                this.nodeMappingRefreshAction.nodeMappingRefresh(state.nodes().getMasterNode(), new NodeMappingRefreshAction.NodeMappingRefreshRequest(newIndexMetaData.getIndex().getName(), newIndexMetaData.getIndexUUID(), state.nodes().getLocalNodeId()));
            }
            catch (Exception e) {
                this.indicesService.removeIndex(indexService.index(), AllocatedIndices.IndexRemovalReason.FAILURE, "removing index (mapping update failed)");
                RoutingNode localRoutingNode = state.getRoutingNodes().node(state.nodes().getLocalNodeId());
                if (localRoutingNode == null) continue;
                for (ShardRouting shardRouting : localRoutingNode) {
                    if (!shardRouting.index().equals(index) || this.failedShardsCache.containsKey(shardRouting.shardId())) continue;
                    this.sendFailShard(shardRouting, "failed to update mapping for index", e, state);
                }
            }
        }
    }

    private void createOrUpdateShards(ClusterState state) {
        RoutingNode localRoutingNode = state.getRoutingNodes().node(state.nodes().getLocalNodeId());
        if (localRoutingNode == null) {
            return;
        }
        DiscoveryNodes nodes = state.nodes();
        RoutingTable routingTable = state.routingTable();
        for (ShardRouting shardRouting : localRoutingNode) {
            ShardId shardId = shardRouting.shardId();
            if (this.failedShardsCache.containsKey(shardId)) continue;
            AllocatedIndex<? extends Shard> indexService = this.indicesService.indexService(shardId.getIndex());
            assert (indexService != null) : "index " + shardId.getIndex() + " should have been created by createIndices";
            Shard shard = indexService.getShardOrNull(shardId.id());
            if (shard == null) {
                assert (shardRouting.initializing()) : shardRouting + " should have been removed by failMissingShards";
                this.createShard(nodes, routingTable, shardRouting, state);
                continue;
            }
            this.updateShard(nodes, shardRouting, shard, routingTable, state);
        }
    }

    private void createShard(DiscoveryNodes nodes, RoutingTable routingTable, ShardRouting shardRouting, ClusterState state) {
        assert (shardRouting.initializing()) : "only allow shard creation for initializing shard but was " + shardRouting;
        DiscoveryNode sourceNode = null;
        if (shardRouting.recoverySource().getType() == RecoverySource.Type.PEER && (sourceNode = IndicesClusterStateService.findSourceNodeForPeerRecovery(this.logger, routingTable, nodes, shardRouting)) == null) {
            this.logger.trace("ignoring initializing shard {} - no source node can be found.", (Object)shardRouting.shardId());
            return;
        }
        try {
            this.logger.debug("{} creating shard", (Object)shardRouting.shardId());
            RecoveryState recoveryState = new RecoveryState(shardRouting, nodes.getLocalNode(), sourceNode);
            this.indicesService.createShard(shardRouting, recoveryState, this.recoveryTargetService, new RecoveryListener(shardRouting), this.repositoriesService, this.failedShardHandler, this.globalCheckpointSyncer);
        }
        catch (Exception e) {
            this.failAndRemoveShard(shardRouting, true, "failed to create shard", e, state);
        }
    }

    private void updateShard(DiscoveryNodes nodes, ShardRouting shardRouting, Shard shard, RoutingTable routingTable, ClusterState clusterState) {
        ShardRouting currentRoutingEntry = shard.routingEntry();
        assert (currentRoutingEntry.isSameAllocation(shardRouting)) : "local shard has a different allocation id but wasn't cleaning by removeShards. cluster state: " + shardRouting + " local: " + currentRoutingEntry;
        try {
            IndexMetaData indexMetaData = clusterState.metaData().index(shard.shardId().getIndex());
            long primaryTerm = indexMetaData.primaryTerm(shard.shardId().id());
            Set<String> inSyncIds = indexMetaData.inSyncAllocationIds(shard.shardId().id());
            IndexShardRoutingTable indexShardRoutingTable = routingTable.shardRoutingTable(shardRouting.shardId());
            Set<String> pre60AllocationIds = indexShardRoutingTable.assignedShards().stream().flatMap(shr -> {
                if (shr.relocating()) {
                    return Stream.of(shr, shr.getTargetRelocatingShard());
                }
                return Stream.of(shr);
            }).filter(shr -> nodes.get(shr.currentNodeId()).getVersion().before(Version.V_6_0_0_alpha1)).map(ShardRouting::allocationId).map(AllocationId::getId).collect(Collectors.toSet());
            shard.updateShardState(shardRouting, primaryTerm, this.primaryReplicaSyncer::resync, clusterState.version(), inSyncIds, indexShardRoutingTable, pre60AllocationIds);
        }
        catch (Exception e) {
            this.failAndRemoveShard(shardRouting, true, "failed updating shard routing entry", e, clusterState);
            return;
        }
        IndexShardState state = shard.state();
        if (shardRouting.initializing() && (state == IndexShardState.STARTED || state == IndexShardState.POST_RECOVERY)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("{} master marked shard as initializing, but shard has state [{}], resending shard started to {}", (Object)shardRouting.shardId(), (Object)state, (Object)nodes.getMasterNode());
            }
            if (nodes.getMasterNode() != null) {
                this.shardStateAction.shardStarted(shardRouting, "master " + nodes.getMasterNode() + " marked shard as initializing, but shard state is [" + (Object)((Object)state) + "], mark shard as started", SHARD_STATE_ACTION_LISTENER, clusterState);
            }
        }
    }

    private static DiscoveryNode findSourceNodeForPeerRecovery(Logger logger, RoutingTable routingTable, DiscoveryNodes nodes, ShardRouting shardRouting) {
        DiscoveryNode sourceNode = null;
        if (!shardRouting.primary()) {
            ShardRouting primary = routingTable.shardRoutingTable(shardRouting.shardId()).primaryShard();
            if (primary.active()) {
                sourceNode = nodes.get(primary.currentNodeId());
                if (sourceNode == null) {
                    logger.trace("can't find replica source node because primary shard {} is assigned to an unknown node.", (Object)primary);
                }
            } else {
                logger.trace("can't find replica source node because primary shard {} is not active.", (Object)primary);
            }
        } else if (shardRouting.relocatingNodeId() != null) {
            sourceNode = nodes.get(shardRouting.relocatingNodeId());
            if (sourceNode == null) {
                logger.trace("can't find relocation source node for shard {} because it is assigned to an unknown node [{}].", (Object)shardRouting.shardId(), (Object)shardRouting.relocatingNodeId());
            }
        } else {
            throw new IllegalStateException("trying to find source node for peer recovery when routing state means no peer recovery: " + shardRouting);
        }
        return sourceNode;
    }

    private synchronized void handleRecoveryFailure(ShardRouting shardRouting, boolean sendShardFailure, Exception failure) {
        this.failAndRemoveShard(shardRouting, sendShardFailure, "failed recovery", failure, this.clusterService.state());
    }

    private void failAndRemoveShard(ShardRouting shardRouting, boolean sendShardFailure, String message, @Nullable Exception failure, ClusterState state) {
        try {
            AllocatedIndex<? extends Shard> indexService = this.indicesService.indexService(shardRouting.shardId().getIndex());
            if (indexService != null) {
                indexService.removeShard(shardRouting.shardId().id(), message);
            }
        }
        catch (ShardNotFoundException indexService) {
        }
        catch (Exception inner) {
            inner.addSuppressed(failure);
            this.logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to remove shard after failure ([{}])", new Object[]{shardRouting.getIndexName(), shardRouting.getId(), message}), (Throwable)inner);
        }
        if (sendShardFailure) {
            this.sendFailShard(shardRouting, message, failure, state);
        }
    }

    private void sendFailShard(ShardRouting shardRouting, String message, @Nullable Exception failure, ClusterState state) {
        try {
            this.logger.warn(() -> new ParameterizedMessage("[{}] marking and sending shard failed due to [{}]", (Object)shardRouting.shardId(), (Object)message), (Throwable)failure);
            this.failedShardsCache.put(shardRouting.shardId(), shardRouting);
            this.shardStateAction.localShardFailed(shardRouting, message, failure, SHARD_STATE_ACTION_LISTENER, state);
        }
        catch (Exception inner) {
            if (failure != null) {
                inner.addSuppressed(failure);
            }
            this.logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to mark shard as failed (because of [{}])", new Object[]{shardRouting.getIndexName(), shardRouting.getId(), message}), (Throwable)inner);
        }
    }

    public static interface AllocatedIndices<T extends Shard, U extends AllocatedIndex<T>>
    extends Iterable<U> {
        public U createIndex(IndexMetaData var1, List<IndexEventListener> var2) throws IOException;

        public IndexMetaData verifyIndexIsDeleted(Index var1, ClusterState var2);

        public void deleteUnassignedIndex(String var1, IndexMetaData var2, ClusterState var3);

        public void removeIndex(Index var1, IndexRemovalReason var2, String var3);

        @Nullable
        public U indexService(Index var1);

        public T createShard(ShardRouting var1, RecoveryState var2, PeerRecoveryTargetService var3, PeerRecoveryTargetService.RecoveryListener var4, RepositoriesService var5, Consumer<IndexShard.ShardFailure> var6, Consumer<ShardId> var7) throws IOException;

        default public T getShardOrNull(ShardId shardId) {
            U indexRef = this.indexService(shardId.getIndex());
            if (indexRef != null) {
                return indexRef.getShardOrNull(shardId.id());
            }
            return null;
        }

        public void processPendingDeletes(Index var1, IndexSettings var2, TimeValue var3) throws IOException, InterruptedException, ShardLockObtainFailedException;

        public static enum IndexRemovalReason {
            NO_LONGER_ASSIGNED,
            DELETED,
            CLOSED,
            FAILURE;

        }
    }

    public static interface AllocatedIndex<T extends Shard>
    extends Iterable<T>,
    IndexComponent {
        public IndexSettings getIndexSettings();

        public void updateMetaData(IndexMetaData var1, IndexMetaData var2);

        public boolean updateMapping(IndexMetaData var1, IndexMetaData var2) throws IOException;

        @Nullable
        public T getShardOrNull(int var1);

        public void removeShard(int var1, String var2);
    }

    public static interface Shard {
        public ShardId shardId();

        public ShardRouting routingEntry();

        public IndexShardState state();

        public RecoveryState recoveryState();

        public void updateShardState(ShardRouting var1, long var2, BiConsumer<IndexShard, ActionListener<PrimaryReplicaSyncer.ResyncTask>> var4, long var5, Set<String> var7, IndexShardRoutingTable var8, Set<String> var9) throws IOException;
    }

    private class FailedShardHandler
    implements Consumer<IndexShard.ShardFailure> {
        private FailedShardHandler() {
        }

        @Override
        public void accept(IndexShard.ShardFailure shardFailure) {
            ShardRouting shardRouting = shardFailure.routing;
            IndicesClusterStateService.this.threadPool.generic().execute(() -> {
                IndicesClusterStateService indicesClusterStateService = IndicesClusterStateService.this;
                synchronized (indicesClusterStateService) {
                    IndicesClusterStateService.this.failAndRemoveShard(shardRouting, true, "shard failure, reason [" + shardFailure.reason + "]", shardFailure.cause, IndicesClusterStateService.this.clusterService.state());
                }
            });
        }
    }

    private class RecoveryListener
    implements PeerRecoveryTargetService.RecoveryListener {
        private final ShardRouting shardRouting;

        private RecoveryListener(ShardRouting shardRouting) {
            this.shardRouting = shardRouting;
        }

        @Override
        public void onRecoveryDone(RecoveryState state) {
            IndicesClusterStateService.this.shardStateAction.shardStarted(this.shardRouting, "after " + state.getRecoverySource(), SHARD_STATE_ACTION_LISTENER);
        }

        @Override
        public void onRecoveryFailure(RecoveryState state, RecoveryFailedException e, boolean sendShardFailure) {
            IndicesClusterStateService.this.handleRecoveryFailure(this.shardRouting, sendShardFailure, e);
        }
    }
}

