/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.elasticsearch.common.time.DateFormatter;

public class EpochSecondsDateFormatter
implements DateFormatter {
    public static DateFormatter INSTANCE = new EpochSecondsDateFormatter();
    private static final Pattern SPLIT_BY_DOT_PATTERN = Pattern.compile("\\.");

    private EpochSecondsDateFormatter() {
    }

    @Override
    public TemporalAccessor parse(String input) {
        try {
            if (input.contains(".")) {
                String[] inputs = SPLIT_BY_DOT_PATTERN.split(input, 2);
                Long seconds = Long.valueOf(inputs[0]);
                if (inputs[1].length() == 0) {
                    return Instant.ofEpochSecond(seconds, 0L).atZone(ZoneOffset.UTC);
                }
                if (inputs[1].contains("e")) {
                    return Instant.ofEpochSecond(Double.valueOf(input).longValue()).atZone(ZoneOffset.UTC);
                }
                if (inputs[1].length() > 9) {
                    throw new DateTimeParseException("too much granularity after dot [" + input + "]", input, 0);
                }
                Long nanos = new BigDecimal(inputs[1]).movePointRight(9 - inputs[1].length()).longValueExact();
                if (seconds < 0L) {
                    nanos = nanos * -1L;
                }
                return Instant.ofEpochSecond(seconds, nanos).atZone(ZoneOffset.UTC);
            }
            return Instant.ofEpochSecond(Long.valueOf(input)).atZone(ZoneOffset.UTC);
        }
        catch (NumberFormatException e) {
            throw new DateTimeParseException("invalid number [" + input + "]", input, 0, e);
        }
    }

    @Override
    public String format(TemporalAccessor accessor) {
        Instant instant = Instant.from(accessor);
        if (instant.getNano() != 0) {
            return String.valueOf(instant.getEpochSecond()) + "." + String.valueOf(instant.getNano()).replaceAll("0*$", "");
        }
        return String.valueOf(instant.getEpochSecond());
    }

    @Override
    public String pattern() {
        return "epoch_second";
    }

    @Override
    public Locale getLocale() {
        return Locale.ROOT;
    }

    @Override
    public ZoneId getZone() {
        return ZoneOffset.UTC;
    }

    @Override
    public DateFormatter withZone(ZoneId zoneId) {
        if (!zoneId.equals(ZoneOffset.UTC)) {
            throw new IllegalArgumentException(this.pattern() + " date formatter can only be in zone offset UTC");
        }
        return this;
    }

    @Override
    public DateFormatter withLocale(Locale locale) {
        if (!Locale.ROOT.equals(locale)) {
            throw new IllegalArgumentException(this.pattern() + " date formatter can only be in locale ROOT");
        }
        return this;
    }

    @Override
    public DateFormatter parseDefaulting(Map<TemporalField, Long> fields) {
        return this;
    }
}

